<?php
error_reporting(0);
sleep(10);
require_once "/etc/brainy/classes/server.php";
require_once "/etc/brainy/classes/bindserver.php";
require_once "/etc/brainy/classes/black_domain.php";
require_once "/etc/brainy/lib/punycode/idna_convert.php";
require_once "/etc/brainy/classes/hostacc.php";
parse_str(implode("&", array_slice($argv, 1)), $_GET);
class bindsync extends bindserver
{
    public function bindsync_get_params()
    {
        $result = array();
        $result["type"] = $_GET["type"];
        $result["server"] = $_GET["cluster"];
        $result["token"] = $_GET["token"];
        $result["typeserv"] = $_GET["typeserv"];
        return $result;
    }
    public function bindsync_start()
    {
        echo "Start synchronize...\n";
        $arr = $this->bindsync_get_params();
        if ($arr["typeserv"] == "brainy") {
            if ($arr["type"] == "cluster") {
                $this->bindsync_from_server($arr["server"], $arr["token"]);
            }
            if ($arr["type"] == "server") {
                $this->bindsync_with_cluster($arr["server"], $arr["token"]);
            }
        }
        if ($arr["typeserv"] == "cpanel") {
            if ($arr["type"] == "cluster") {
                $this->bindsync_from_server_from_cpanel($arr["server"], $arr["token"]);
            }
            if ($arr["type"] == "server") {
                $this->bindsync_with_cluster_to_cpanel($arr["server"], $arr["token"]);
            }
        }
    }
    public function bindsync_from_server_from_cpanel($server, $token)
    {
        $param["bind_ip"] = $server;
        $zone = $this->bindserver_getZone();
        $param["bind_key"] = $token;
        $param["listzones"] = $zone;
        $this->addToClusterCpanelFromcpanel($param);
    }
    public function bindsync_with_cluster_to_cpanel($server, $token)
    {
        $param["bind_ip"] = $server;
        $zone = $this->bindserver_getZone();
        echo "Zones:\n";
        $data = array();
        $count_all = 0;
        foreach ($zone as $key_user) {
            foreach ($key_user as $key) {
                $count_all++;
            }
        }
        $curind = 0;
        foreach ($zone as $key_user) {
            foreach ($key_user as $key) {
                $curind++;
                $text = implode("\n", $this->bindserver_editZone($key));
                $param["domain"] = $key;
                $param["bind_key"] = $token;
                $param["zone"] = $key;
                $param["text"] = $text;
                $this->addToClusterCpanelTocpanel($param);
                echo $key . round($curind / $count_all * 100, 4) . "% \n";
            }
        }
    }
    public function bindsync_with_cluster($server, $token)
    {
        $url = "https://" . $server . ":8000/scripts/bindcluster.php";
        $defaultns = $this->bindserver_getDefaultNsArray();
        echo "Default NS:\n";
        $data = array();
        foreach ($defaultns as $key) {
            $ip = $this->bindserver_getDefaultNsIP($key);
            $data = array("token" => $token, "act" => "add_defns", "host" => $key, "ip" => $ip);
            $this->bindsync_send_data($url, $data);
            echo $key . "\n";
        }
        $zone = $this->bindserver_getZone();
        echo "Zones:\n";
        $data = array();
        foreach ($zone as $key_user) {
            foreach ($key_user as $key) {
                $text = implode("\n", $this->bindserver_editZone($key));
                $data = array("token" => $token, "act" => "save_zone_to_file", "zone" => $key, "text" => $text);
                $this->bindsync_send_data($url, $data);
                echo $key . "\n";
            }
        }
    }
    public function bindsync_from_server($server, $token)
    {
        global $lang;
        $url = "https://" . $server . ":8000/scripts/bindcluster.php";
        $data = array("token" => $token, "act" => "get_zones_array", "user" => "root");
        $defaultns = $this->bindsync_send_data($url, $data)["result"];
        foreach ($defaultns as $key) {
            $data = array("token" => $token, "act" => "get_defaultns_ip", "host" => $key);
            $ip = $this->bindsync_send_data($url, $data)["result"];
            if ($ip) {
                $array_ns[$key] = $ip;
            }
        }
        $data = array("token" => $token, "act" => "get_zones_array", "user" => "root");
        $zone = $this->bindsync_send_data($url, $data)["result"];
        echo "Zones:\n";
        foreach ($zone as $key) {
            if (array_key_exists($key, $array_ns)) {
                continue;
            }
            $data = array("token" => $token, "act" => "edit_zone", "zone" => $key);
            $content = $this->bindsync_send_data($url, $data)["result"];
            $this->bindserver_saveZone($key, $content);
            echo $key . "\n";
        }
        $this->update_dns_zone();
        $data = array("token" => $token, "act" => "get_defaultns_array");
        echo "Default NS:\n";
        foreach ($array_ns as $host_ns => $ip_ns) {
            $this->bindserver_addDefaultNs($host_ns, $ip_ns, "");
            echo $host_ns . "\n";
        }
    }
    public function bindsync_send_data($url, $data)
    {
        $options = array("http" => array("header" => "Content-type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => http_build_query($data)), "ssl" => array("verify_peer" => false, "verify_peer_name" => false));
        $context = stream_context_create($options);
        $input = file_get_contents($url, false, $context);
        $result = json_decode($input, true);
        return $result;
    }
    public function bindsync_sleep($seconds)
    {
        sleep($seconds);
    }
    public function bindsync_finish()
    {
        echo "Synchronize finished!\nComplete";
    }
    public function bindsync_run()
    {
        $this->bindsync_start();
        $this->bindsync_finish();
    }
}
$bind = new bindsync();
$bind->bindsync_run();

?>