<?php
require_once "/etc/brainy/conf/globals.php";
require_once "/etc/brainy/lib/punycode/idna_convert.php";
require_once $GLOBALS["SERVER_PHP_PATH"];
$server = new Server();
$server->load();
$server->load_globals();
$smarty = new Smartest();
$certs = new certs();
error_reporting(0);
$var = getopt("a:s:p:m:n::");
$tpl->clean = 1;
$action = $var["a"];
$params = $var["p"];
$allvar = json_decode($params, 1);
$user = htmlspecialchars($allvar["user"], ENT_QUOTES);
$username_oper = htmlspecialchars($allvar["username_oper"], ENT_QUOTES);
if (!$server->check_value("user", $user)) {
    return 0;
}
if ($username_oper == "root") {
    $conf = $server->config_read("/etc/brainy/data/properties/prop.conf");
} else {
    $conf = $server->config_read($GLOBALS["USERS_PATH"] . $user);
}
if (isset($conf["language"])) {
    $langload = $conf["language"];
} else {
    $langload = "ru";
}
$server->lan_include($langload);
switch ($action) {
    case "create_letencert":
        $user = htmlspecialchars($allvar["user"], ENT_QUOTES);
        $domain = htmlspecialchars($allvar["domain"], ENT_QUOTES);
        $crt = htmlspecialchars($allvar["crt"], ENT_QUOTES);
        $webserver = htmlspecialchars($allvar["webserver"], ENT_QUOTES);
        $mail_ssl = htmlspecialchars($allvar["mail_ssl"], ENT_QUOTES);
        $out = $certs->create_letencert2($user, $domain, $crt, $webserver, $mail_ssl);
        print_r($out);
        break;
    case "install_cert_service":
        $cert = htmlspecialchars($allvar["cert"], ENT_QUOTES);
        $key = htmlspecialchars($allvar["key"], ENT_QUOTES);
        $cabundle = htmlspecialchars($allvar["cabundle"], ENT_QUOTES);
        $listservice = $allvar["listservice"];
        $rescheck = $certs->certs_check_valid($cert, $key, $cabundle);
        $file_list = "/etc/brainy/data/certs_control/service_cert.conf";
        $list_service_cert = preg_split("/\\r\\n|\\r|\\n/", file_get_contents($file_list));
        $namebrainy_serv = "";
        foreach ($list_service_cert as $serv_cert) {
            $exp_serv_cert = explode("=", $serv_cert);
            list($nameserv, $pathserv_cert) = $exp_serv_cert;
            if (in_array($nameserv, $listservice)) {
                if ($nameserv == "brainy") {
                    $namebrainy_serv = "brainy";
                }
                $file_name = basename($pathserv_cert);
                $file_name = str_replace("\"", "", $file_name);
                $file_name = basename($file_name, ".crt");
                $path = pathinfo($pathserv_cert)["dirname"];
                $path = str_replace("\"", "", $path);
                file_put_contents($path . "/" . $file_name . ".crt", $cert);
                file_put_contents($path . "/" . $file_name . ".key", $key);
                file_put_contents($path . "/" . $file_name . ".ca-bundle", $cabundle);
                $cert = trim($cert) . "\n";
                file_put_contents($path . "/" . $file_name . ".crt_v2", $cert . $cabundle);
                if ($nameserv == "smtp" || $nameserv == "ftp") {
                    if (!file_exists("/var/lib/ssl")) {
                        $server->ssh("mkdir /var/lib/ssl ; chmod 755 /var/lib/ssl");
                    }
                    file_put_contents("/var/lib/ssl/" . $file_name . ".crt", $cert);
                    file_put_contents("/var/lib/ssl/" . $file_name . ".key", $key);
                }
                if ($nameserv == "smtp") {
                    $server->monitor_comm_os("exim", "restart");
                }
                if ($nameserv == "ftp") {
                    $server->ssh("cat /etc/brainy/src/ssl/ftp.crt /etc/brainy/src/ssl/ftp.key >/var/lib/ssl/ftp.pem");
                    $server->monitor_comm_os("pure-ftpd", "restart");
                    $server->monitor_comm_os("proftpd", "restart");
                }
                if ($nameserv == "imap") {
                    $server->monitor_comm_os("dovecot", "restart");
                }
            }
        }
        global $lang;
        $res["code"] = 0;
        $res["message"] = $lang["service_install_new_ok"];
        $webserver = new webserver();
        $array_service_list["service_list"] = implode(",", $listservice);
        $server->config_save("/etc/brainy/data/vhosts/!!default.conf", $array_service_list, "add");
        $webserver->webserver_convert_domain("!!default", 0);
        $webserver->webservers_reloadconf(1);
        $certs->updatecert_service_brainy($namebrainy_serv, $cert, $key, $cabundle);
        break;
}
exit;

?>