<?php

# определение данных
$post = array(); // массив пост - данных
$class = array(); // стили полей
$value = array(); // введенные значения
$form = false; // имя формы
$go = false; // переадресация

# проверка отправки формы
if ($_SERVER['REQUEST_METHOD'] == 'POST') { 

# проверка полей
$post['nick'] = (isset($_POST['nick']) && $USER->filter($_POST['nick'], 'nick', DATA['nick'])) ? $_POST['nick'] : 'stopped'; // ник
$post['pass'] = (isset($_POST['pass']) && $USER->filter($_POST['pass'], 'pass', DATA['pass'])) ? $_POST['pass'] : 'stopped'; // пароль
$post['email'] = (isset($_POST['email']) && $USER->filter($_POST['email'], 'email')) ? $_POST['email'] : 'stopped'; // e-mail
$post['sex'] = (isset($_POST['sex']) && $USER->filter($_POST['sex'], 'sex')) ? $_POST['sex'] : 'stopped'; // пол (гендер)
$post['token'] = (isset($_POST['token']) && $_POST['token'] == TOKEN) ? 'true' : 'stopped'; // токен

# проверка в базе данных
if ($post['nick'] != 'stopped') { $post['nick'] = (db_exist($DB, 'users', 'id', array('nick' => $_POST['nick']))) ? 'stopped' : $_POST['nick']; } // ник
if ($post['email'] != 'stopped') { $post['email'] = (db_exist($DB, 'users', 'id', array('email' => $_POST['email']))) ? 'stopped' : $_POST['email']; } // e-mail

# определение наличия ошибок
if (in_array('stopped', $post)) { $register = true; // показ формы регистрации

# проверка полей, определение стилей
$class['nick'] = ($post['nick'] == 'stopped') ? 'no': 'ok'; // ник
$class['pass'] = ($post['pass'] == 'stopped') ? 'no': 'ok'; // пароль
$class['email'] = ($post['email'] == 'stopped') ? 'no': 'ok'; // e-mail
$class['sex'] = ($post['sex'] == 'stopped') ? 'no': 'ok'; // пол (гендер)

# проверка введенных значений, вывод данных
$value['nick'] = (isset($_POST['nick']) && !empty($_POST['nick'])) ? ' value="'. $_POST['nick'] .'"': false; // ник
$value['pass'] = (isset($_POST['pass']) && $USER->filter($_POST['pass'], 'pass', DATA['pass'])) ? ' value="'. $_POST['pass'] .'"': false; // пароль
$value['email'] = (isset($_POST['email']) && !empty($_POST['email'])) ? ' value="'. $_POST['email'] .'"': false; // e-mail
$value['sex_none'] = (isset($_POST['sex']) && $_POST['sex'] == 'none') ? ' selected ' : ' '; // пол (гендер), не указан
$value['sex_male'] = (isset($_POST['sex']) && $_POST['sex'] == 'male') ? ' selected ' : ' '; // пол (гендер), мужской
$value['sex_female'] = (isset($_POST['sex']) && $_POST['sex'] == 'female') ? ' selected ' : ' '; // пол (гендер), женский

# отсутствие ошибок
} else { $token = $FUNC->random(50); // токен активации

# создание нового пользователя, в базе данных, настройки, статистика
$id = db_create($DB, 'users', array('bonus' => time() + 86400, 'email' => $post['email'], 'money' => DATA['money'], // основа
'nick' => trim($post['nick']), 'pass' => $FUNC->hashing($_POST['pass']), 'reg' => time(), 'sex' => $post['sex'], // настройки
'status' => 'user', 'visit' => time()), true); db_create($DB, 'settings'); db_create($DB, 'statistic'); // статистика

# создание ресурсов игры, в базе данных
for ($how = 1; $how <= DATA['garden']; $how++) { db_create($DB, 'garden', array('num' => $how, 'user' => $id)); } // грядки
for ($how = 1; $how <= DATA['animal']; $how++) { db_create($DB, 'animal', array('num' => $how, 'user' => $id)); } // загоны
for ($how = 1; $how <= DATA['technic']; $how++) { db_create($DB, 'technic', array('num' => $how, 'user' => $id)); } // техника

# создание заданий игры, в базе данных
for ($how = 1; $how <= DATA['tasks']; $how++) { $plant = $GAME->random(1, 4); $count = $GAME->random(3, 10); // растение, количество
$perc = $GAME->random(0, 30); $price = round(((SALE['plant_'. $plant] * $count) / 100) * (100 + $perc)); // вычисление награды
$person = $GAME->person(); $image = $person[0]; $name = $person[1]; db_create($DB, 'tasks', array( // персонаж, имя
'image' => $image, 'name' => $name, 'num' => $how, 'one' =>'plant:'. $plant .':'. $count, 'price' => $price, 'user' => $id)); } // запись в базу

# создание активации, в базе данных
db_create($DB, 'tokens', array('time' => time() + DATA['token'], 'token' => $token, 'type' => 'active', 'user' => $id));

# отправка e-mail с активацией
$message = '<h2>Вы успешно зарегистрировались в онлайн - игре "'. SERV['name'] .'"!</h2><p>Для активации аккаунта 
перейдите по ссылке: <a href="https://'. SERV['host'] .'/activate/'. $id .'/token/'. $token .'">активировать</a></p>'; // сообщение
$headers = "From: ". SERV['name'] ." ". SERV['email'] ." \r\n"; // заголовок, от кого письмо
$headers .= "Content-type: text/html; charset=utf-8 \r\n"; // заголовок, кодировка
mail($post['email'], 'Регистрация', $message, $headers);  } } // отправка письма

?>