<?php

# заголовок
define('TITLE', 'Техника');

# определение данных
$params = PARAMS; // получение параметров
$refresh = $FUNC->random(8, true); // случайное число

####################
####################

# покупка техники
if (isset($params['param']) && $params['param'] == 'buy' && isset($params['num']) && 
isset($params['tech']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметров
$num = $FUNC->filter($params['num'], 'int'); // место
$tech = $FUNC->filter($params['tech'], 'int'); // техника

# проверка места техники, в базе данных
if (db_exist($DB, 'technic', 'id', array('num' => $num, 'tech' => 0, 'user' => USER['id'])) && 
$tech > 0 && $tech < 4) { $price = PRICE['tech_'. $tech]; $access = true; } else $access = false;

# проверка на возможность покупки
if ($access && $price <= USER['money']) {

# вывод места техники из базы данных
$technol = db_output($DB, 'technic', 'id', array('num' => $num, 'user' => USER['id']));

# данные о поломке техники
$fritz = explode(';', DATA['crash']); $crash = $GAME->random($fritz[0], $fritz[1]);

# обновление данных, в базе данных
db_update($DB, 'technic', array('crash' => $crash, 'food' => TECHNIC['list_'. $tech], 'strong' => $crash, 'tech' => $tech), array ('id' => $technol['id'])); // техника
db_update($DB, 'users', array('money' => $price .';-'), array ('id' => USER['id'])); } } // монеты игрока

####################

# удаление техники, массовое удаление
if (isset($params['param']) && $params['param'] == 'deletion' && isset($params['act']) && 
$params['act'] == 'delete' && isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, место
$num = $FUNC->filter($params['num'], 'int');

# проверка техники на удаление, в базе данных
if (db_exist($DB, 'technic', 'id', array('num' => $num, 'tech;!=' => 0, 'user' => USER['id']))) { // проверка места
$technol = db_output($DB, 'technic', 'id', array('num' => $num, 'user' => USER['id'])); // выбор места
db_update($DB, 'technic', array('crash' => 0, 'food' => 'empty', 'prod' => 0, 'strong' => 0, 'tech' => 0), array ('id' => $technol['id'])); } } // обновление места

####################

# ремонт техники, массовый ремонт
if (isset($params['param']) && $params['param'] == 'repairs' && isset($params['act']) && 
$params['act'] == 'repair' && isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, место
$num = $FUNC->filter($params['num'], 'int');

# проверка техники на ремонт, в базе данных
if (db_exist($DB, 'technic', 'id', array('crash' => 0, 'num' => $num, 'tech;!=' => 0, 'user' => USER['id']))) { // проверка места
$technol = db_output($DB, 'technic', array('id', 'strong', 'tech'), array('num' => $num, 'user' => USER['id'])); // техника
$price = $GAME->repair($technol['tech'], $technol['strong']); $access = true; } else $access = false; // сумма ремонта

# проверка на возможность ремонта
if ($access && $price <= USER['money']) {

# данные о поломке техники
$fritz = explode(';', DATA['crash']); $crash = $GAME->random($fritz[0], $fritz[1]);

db_update($DB, 'technic', array('crash' => $crash, 'strong' => $crash), array ('id' => $technol['id'])); // обновление места
db_update($DB, 'users', array('money' => $price .';-'), array ('id' => USER['id'])); } } // монеты игрока

####################

# массовое удаление техники
if (isset($params['param']) && $params['param'] == 'deletion' && isset($params['token']) && $params['token'] == TOKEN) {

# проверка техники на удаление, в базе данных
if (db_exist($DB, 'technic', 'id', array('tech;!=' => 0, 'user' => USER['id']))) $deletion = true; }

####################

# массовый ремонт техники
if (isset($params['param']) && $params['param'] == 'repairs' && isset($params['token']) && $params['token'] == TOKEN) {

# проверка техники на ремонт, в базе данных
if (db_exist($DB, 'technic', 'id', array('crash' => 0, 'tech;!=' => 0, 'user' => USER['id']))) $repaire = true; }

####################

# загрузка продуктов
if (isset($params['param']) && $params['param'] == 'load' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, техника
$num = $FUNC->filter($params['num'], 'int');

# проверка и вывод техники, из базы данных
if (db_exist($DB, 'technic', 'id', array('crash;!=' => 0, 'num' => $num, 'prod' => 0, 'tech;!=' => 0,  'user' => USER['id']))) {
$out = db_output($DB, 'technic', 'food', array('num' => $num, 'user' => USER['id'])); $food = explode('-', $out['food']); $load = 0; // продукты техники
for ($how = 0; $how < count($food); $how++) { $exp = explode(':', $food[$how]); // проверка продуктов
if (db_exist($DB, 'storage', 'id', array('object' => $exp[1], 'type' => $exp[0], 'user' => USER['id']))) $load++; } // подсчет продуктов
if (count($food) == $load) $access = true; else $access = false; } if (!isset($access)) $access = false; // проверка разрешения

# проверка, определение списка имеющихся, загружаемых продуктов
if ($access) { for ($how = 0; $how < count($food); $how++) { $exp = explode(':', $food[$how]); // определение продуктов
db_update($DB, 'storage', array('count' => '1;-'), array ('object' => $exp[1], 'type' => $exp[0], 'user' => USER['id'])); } // загрузка продуктов, обновление

# проверка количества в базе данных, удаление пустых
if (db_exist($DB, 'storage', 'id', array('count' => 0, 'user' => USER['id']))) db_delete($DB, 'storage', array('count' => 0, 'user' => USER['id']));

# выбор техники из базы данных
$technol = db_output($DB, 'technic', array('id','tech'), array('num' => $num, 'user' => USER['id']));

# данные о времени изготовления продукции
$wait = explode(';', TECHNIC['food_'. $technol['tech']]); $prod = time() + $GAME->random($wait[0], $wait[1]);

# обновление статистики игрока, очки
db_update($DB, 'statistic', array('points' => '3;+'), array('id' => USER['id']));

# обновление данных, в базе данных
db_update($DB, 'settings', array('storage' => count($food) .';-'), array ('id' => USER['id'])); // место на складе
db_update($DB, 'technic', array('prod' => $prod), array ('id' => $technol['id'])); } } // техника

####################

# сбор продуктов
if (isset($params['param']) && $params['param'] == 'prod' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, техника
$num = $FUNC->filter($params['num'], 'int');

# проверка на сбор продуктов, в базе данных
if (db_exist($DB, 'technic', 'id', array('crash;!=' => 0, 'num' => $num, 'prod;<' => time(), 
'prod;!=' => 0, 'tech;!=' => 0, 'user' => USER['id'])) && SETUP['storage'] < DATA['storage']) { 

# выбор техники из базы данных
$technol = db_output($DB, 'technic', array('id', 'tech'), array('num' => $num, 'user' => USER['id']));

# обновление количества продуктов на складе, в базе данных
if (db_exist($DB, 'storage', 'id', array('object' => $technol['tech'], 'type' => 'tech', 'user' => USER['id'])))
db_update($DB, 'storage', array('count' => '1;+'), array ('object' => $technol['tech'], 'type' => 'tech', 'user' => USER['id'])); // продукт имеется
else db_create($DB, 'storage', array('count' => 1, 'object' => $technol['tech'], 'type' => 'tech', 'user' => USER['id'])); // новый продукт

# обновление статистика игрока
db_update($DB, 'statistic', array('points' => '3;+', 'product' => '1;+'), array('id' => USER['id']));

# обновление данных, в базе данных
db_update($DB, 'settings', array('storage' => '1;+'), array ('id' => USER['id'])); // место на складе
db_update($DB, 'technic', array('crash' => '1;-', 'prod' => 0), array ('id' => $technol['id'])); } } // техника

####################

# выбор места для покупки техники
if (isset($params['param']) && $params['param'] == 'tech' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, место
$num = $FUNC->filter($params['num'], 'int');

# проверка техники на покупку, в базе данных
if (db_exist($DB, 'technic', 'id', array('tech' => 0, 'user' => USER['id'])) && $num > 0 && $num < 4) $purchase = $num; }

####################
####################

# вывод техники из базы данных
$query = db_output($DB, 'technic', array('id', 'crash', 'food', 'num', 'prod', 'strong', 'tech'), array('user' => USER['id']), true, 'num', DATA['technic']);

# данные верхней ссылки
if (isset($deletion) || isset($repaire)) $top = array('icon' => 'back', 'link' => 'Вернуться к технике'); // назад
else $top = array('icon' => 'refresh', 'link' => 'Обновить'); // обновить

# данные нижних ссылок
$delets = (db_exist($DB, 'technic', 'id', array('tech;!=' => 0, 'user' => USER['id']))) ? true : false; // удаление техники
$repair = (db_exist($DB, 'technic', 'id', array('crash' => 0, 'tech;!=' => 0, 'user' => USER['id']))) ? true : false; // поломка техники

# разбор техники, переработка данных в массиве
$index = 0; while ($assoc = $query->fetch_assoc()) {
$technic[$index] = $assoc; $index++; }

####################

# определение автообновления
$update = (isset($deletion) || isset($repaire)) ? false : 'update ';

# вывод техники, определение данных
foreach ($technic as &$post) { $post['color'] = false; // стиль названия по умолчанию
$post['name'] = ($post['tech'] == 0) ? 'Пустое место' : TECHNIC['name_'. $post['tech']]; // заголовок
$post['image'] = ($post['tech'] == 0) ? 'area/empty' : $GAME->technic(TECHNIC['image_'. $post['tech']], $post['prod']); // картинка
$prod = ($post['tech'] != 0) ? mb_strtolower(TECHNIC['prod_'. $post['tech']]) : false; // название продукта

####################

# время ожидания продукции
$odds = $post['prod'] - time(); $wait = ($post['prod'] > time()) ? 'через '. $USER->when($odds, true, true) : 'можно забрать';

# выбор места для покупки техники
if (isset($purchase)) { if (USER['money'] >= PRICE['tech_'. $purchase] && $post['tech'] == 0) { $post['icon'] = 'load';  // проверка баланса
$post['text'] = 'Поставить здесь'; $post['link'] = 'technic/buy/num/'. $post['num'] .'/tech/'. $purchase; } else { $lacks = PRICE['tech_'. $purchase] - USER['money']; // покупка возможна
$post['icon'] = 'cross'; $post['text'] = ($post['tech'] == 0) ? 'Не хватает '. $lacks .' монет' : 'Место занято'; $post['link'] = false; } } // покупка невозможна

####################

# массовое удаление техники
elseif (isset($params['param']) && $params['param'] == 'deletion' && isset($params['token']) && $params['token'] == TOKEN && 
db_exist($DB, 'technic', 'id', array('tech;!=' => 0, 'user' => USER['id']))) { $delets = false; // удаление нижней ссылки

# действие, определение данных
if ($post['tech'] != 0) { $post['icon'] = 'delete'; $post['text'] = 'Убрать технику'; // иконка
$post['link'] = 'technic/deletion/act/delete/num/'. $post['num']; } else {  // ссылка
$post['icon'] = 'cross'; $post['text'] = 'Нет действия'; $post['link'] = false; } }  // нет действия

####################

# массовый ремонт техники
elseif (isset($params['param']) && $params['param'] == 'repairs' && isset($params['token']) && $params['token'] == TOKEN && 
db_exist($DB, 'technic', 'id', array('crash' => 0, 'tech;!=' => 0, 'user' => USER['id']))) { $repair = false; // удаление нижней ссылки

# действие, определение суммы ремонта
if ($post['crash'] == 0 && $post['tech'] != 0) { $money = $GAME->repair($post['tech'], $post['strong']);

# определение данных
if (USER['money'] >= $money) { $post['icon'] = 'repair'; $post['text'] = 'Ремонт ('. $money .' монет)'; // иконка
$post['link'] = 'technic/repairs/act/repair/num/'. $post['num']; } else { $lacks = $money - USER['money']; // ссылка, подсчет монет
$post['icon'] = 'cross'; $post['text'] = 'Не хватает '. $lacks .' монет'; $post['link'] = false; } // иконка, ссылка, нет монет
} else { $post['icon'] = 'cross'; $post['text'] = 'Нет действия'; $post['link'] = false; } }  // нет действия

####################

# загрузка продуктов, разбор действий
else { if ($post['tech'] != 0 && $post['prod'] == 0) { $food = explode('-', $post['food']); $loaded[$post['num']] = 0; // продукты техники
for ($how = 0; $how < count($food); $how++) { $exp = explode(':', $food[$how]); // проверка продуктов, количество
if (db_exist($DB, 'storage', 'id', array('object' => $exp[1], 'type' => $exp[0], 'user' => USER['id']))) $loaded[$post['num']]++; } } // загрузка продуктов

# вывод животных, определение действия
if ($post['tech'] == 0) { $post['icon'] = 'money'; $post['text'] = 'Купить технику'; $post['link'] = 'shop/technic/num/'. $post['num']; } // покупка техники
elseif ($post['crash'] == 0 && $post['tech'] != 0) { $post['color'] = true; $post['icon'] = 'cross'; $post['text'] = 'Техника сломана'; $post['link'] = false; } // техника сломана
elseif ($post['tech'] != 0 && $post['prod'] == 0 && isset($loaded[$post['num']]) && $loaded[$post['num']] == count($food)) {
$post['color'] = true; $post['icon'] = 'load'; $post['text'] = 'Загрузить продукты'; $post['link'] = 'technic/load/num/'. $post['num']; } // загрузка продуктов
elseif ($post['prod'] < time() && $post['prod'] != 0 && $post['tech'] != 0 && SETUP['storage'] < DATA['storage']) { $post['color'] = true; $post['icon'] = 'hand'; 
$post['text'] = 'Взять '. $prod; $post['link'] = 'technic/prod/num/'. $post['num']; } // сбор продуктов, есть место на складе
elseif ($post['prod'] < time() && $post['prod'] != 0 && $post['tech'] != 0 && SETUP['storage'] >= DATA['storage']) { 
$post['color'] = true; $post['icon'] = 'cross'; $post['text'] = 'Нет места на складе'; $post['link'] = false; } // сбор продуктов, нет места на складе
elseif ($post['prod'] == 0) { $post['icon'] = 'time'; $post['text'] = 'Ожидание продуктов'; $post['link'] = false; } // время ожидания, продукты
else { $post['icon'] = 'time'; $post['text'] = TECHNIC['prod_'. $post['tech']] .' '. $wait; $post['link'] = false; } } // время ожидания, приготовление
$post['name'] = ($post['color']) ? '<span class="color">'. $post['name'] .'</span>' : $post['name']; } // стиль названия

?>