<?php

# заголовок
define('TITLE', 'Чат');

# определение данных
$params = PARAMS; $page = 1; // получение параметров
$empty = false; $reply = false; // данные по умолчанию
$refresh = $FUNC->random(8, true); // случайное число

# обновление времени визита
db_update($DB, 'users', array('chat' => time()), array ('id' => USER['id']));

####################
####################

# блокировка, удаления сообщения
if (isset($params['block']) && isset($params['token']) && 
$params['token'] == TOKEN && USER['status'] == 'admin') {

# идентификатор сообщения
$id = $FUNC->filter($params['block'], 'int');

# проверка на возможность ответа, обработка данных
if (db_exist($DB, 'chat', 'id', array('id' => $id, 'user;!=' => USER['id']))) {
$mess = db_output($DB, 'chat', array('id','user'), array('id' => $id)); // данные сообщения
db_update($DB, 'settings', array('chat' => 'no'), array ('id' => $mess['user'])); // запрет на чат
db_delete($DB, 'chat', array('id' => $mess['id'])); } } // удаление сообщения

####################

# ответ на сообщение
if (isset($params['reply']) && isset($params['token']) && 
$params['token'] == TOKEN  && SETUP['chat'] == 'yes') {

# идентификатор сообщения
$id = $FUNC->filter($params['reply'], 'int');

# проверка на возможность ответа, вывод данных
if (db_exist($DB, 'chat', 'id', array('id' => $id, 'user;!=' => USER['id']))) { $reply = true;
$return = db_output($DB, 'chat', array('id','text','user'), array('id' => $id)); // данные чата
$locked = 'Заблокировать'; $icon = 'lock'; if (db_exist($DB, 'settings', 'id', array(
'chat' => 'no', 'id' => $return['user']))) { $locked = 'Удалить'; $icon = 'trash'; } // вид ссылки
$author = db_output($DB, 'users', array('nick','sex'), array('id' => $return['user'])); } } // автор
$answer = ($reply) ? 'Ответ <span class="color">'. $author['nick'] .'</span>' : 'Сообщение'; // указание

####################
####################

# проверка наличия сообщений
if (db_count($DB, 'chat', 'id') == 0) $empty = true; else {

# работа с данными, из базы данных
$msg = db_count($DB, 'chat', 'id'); $pages = ceil($msg / DATA['chat']); if ($pages > 5) $pages = 5; // страницы чата
if (isset($params['page'])) { $page = $FUNC->filter($params['page'], 'int'); if ($page > $pages) $page = $pages; // проверка навигации
elseif ($page < 1) $page = 1; } else $page = 1; $offset = ($page * DATA['chat']) - DATA['chat']; // определение смещения
$query = db_output($DB, 'chat', '*', false, true, 'id', DATA['chat'], $offset, 'DESC'); // вывод сообщений из базы
$one = ($pages == 2) ? '<' : 1; $two = ($pages == 2) ? '>' : 2; // навигация, определение переходов

# разбор чата, переработка данных в массиве
$index = 0; while ($assoc = $query->fetch_assoc()) {
$chat[$index] = $assoc; $index++; }

# обработка данных
foreach ($chat as &$post) { $user = db_output($DB, 'users', array('id', 'nick', 'sex', 'visit'), array('id' => $post['user'])); if ($post['reply'] != 0) // данные автора
$repl = db_output($DB, 'users', 'nick', array('id' => $post['reply'])); else $repl['nick'] = false; $post['user'] = $user['id']; $post['nick'] = $user['nick']; // ответ, ник
$post['sex'] = $user['sex']; $post['reply'] = $repl['nick']; $post['visit'] = (time() < ($user['visit'] + DATA['online'])) ? 'green' : 'gray'; // пол, визит
$post['text'] = $GAME->message($post['text']); $post['time'] = ($post['time'] == time()) ? 'только что' : $USER->when($post['time'], true) .' назад'; // сообщение, время
$post['link'] = (USER['status'] == 'guest' || SETUP['chat'] == 'no') ? '/profile/'. $USER->nick($post['nick']) : '/chat/reply/'. $post['id'] .'/token/'. TOKEN; } } // ссылка на сообщения

####################

# проверка данных, возможность писать в чат
$form = (USER['status'] != 'guest' && SETUP['chat'] == 'yes') ? true : false; if (!$form) { // доступ к форме
if (SETUP['chat'] == 'no') $ban = 'Вам закрыт доступ к чату.'; else $ban = 'Гостям недоступно общение в чате.'; } // блокировка

# данные верхней ссылки
if ($reply) $top = array('icon' => 'back', 'link' => 'Вернуться назад'); // назад
else $top = array('icon' => 'refresh', 'link' => 'Обновить'); $spot = ($page == 1) ? // обновить
'/chat/refresh/'. $refresh : '/chat/page/'. $page .'/refresh/'. $refresh;  // ссылка

# кнопка
$button = ($reply) ? 'Ответить' : 'Отправить'; // кнопка

?>