<?php

# основные функции
class functions {

# проверка ajax запроса
public function ajax() { return (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && // наличие заголовка
strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') ? true : false; } // соответствие запроса

# изменение обратной ссылки
public function back($url, $back = false) { return (!$back) ? str_replace('/','-', $url) : str_replace('-','/', $url); }

# определение браузера
public function browser($agent) {
if (preg_match('#(msie|rv:11.0)#ui', $agent)) return 'Internet Explorer'; // десктопный
elseif (preg_match('#edge#ui', $agent)) return 'Microsoft Edge'; // десктопный
elseif (preg_match('#firefox#ui', $agent)) return 'Mozilla Firefox'; // любой
elseif (preg_match('#(opr|opera)#ui', $agent)) return 'Opera'; // любой
elseif (preg_match('#ucbrowser#ui', $agent)) return 'UC Browser'; // любой
elseif (preg_match('#yabrowser#ui', $agent)) return 'Yandex Browser'; // любой
elseif (preg_match('#chrome#ui', $agent)) return 'Google Chrome'; // любой
elseif (preg_match('#safari#ui', $agent)) return 'Safari'; // любой
else return 'Unknown'; } // неизвестный браузер

# определение устройства
public function device($agent) {
$devices = 'android|bada|blackberry|bb10|iphone|ipod|series40|series 60|symbian|windows phone'; // сравнение агентов
return (preg_match('/('. $devices .')/i', $agent)) ? 'mobi' : 'comp'; } // определение устройства

# фильтрация данных
public function filter($var, $type = 'var') { global $DB; switch($type) { // база данных, проверка типа данных
case 'sql': return (trim(htmlspecialchars($DB->real_escape_string($var)))); // проверка для базы данных  
case 'int': return (intval($var) && $var > 0) ? $var : 0; break; // проверка числа
case 'var': return (trim(htmlspecialchars($var))); break; } } // проверка строки

# переадресация на ссылку
public function go($url, $http = false, $host = false) {
if (!$host) $host = SERV['host']; if (!$http) { // проверка хоста
$http = (isset($_SERVER['HTTPS'])) ? 'https' : 'http'; } // проверка протокола
header('Location: '. $http .'://'. $host . $url); exit; return false; } // переадресация

# работа с хешами
public function hashing($var, $hash = false) {
if (!$hash) return password_hash($var, PASSWORD_BCRYPT); // установка хеша
else return (password_verify($var, $hash)) ? true : false; } // проверка хеша

# определение ip - адреса
public function ip($ip) {
if (preg_match('#^([0-9]{1,3}[\.]){3}[0-9]{1,3}\z#', $ip)) return $ip; // версия 4
elseif (preg_match('#^((^|:)([0-9a-fA-F]{0,4})){1,8}\z#i', $ip)) return $ip; // версия 6
else return '0.0.0.0'; } // ip - адрес не определен, указан ноль

# определение операционной системы
public function os($agent) {
if (preg_match('#android#ui', $agent)) return 'Android'; // мобильный
elseif (preg_match('#cros#ui', $agent)) return 'Chrome OS'; // десктопный
elseif (preg_match('#freebsd#ui', $agent)) return 'FreeBSD'; // десктопный
elseif (preg_match('#(ipad|iphone)#ui', $agent)) return 'iOS'; // мобильный
elseif (preg_match('#linux#ui', $agent)) return 'Linux'; // десктопный
elseif (preg_match('#macintosh#ui', $agent)) return 'MacOS'; // десктопный
elseif (preg_match('#ubuntu#ui', $agent)) return 'Ubuntu'; // десктопный
elseif (preg_match('#windows#ui', $agent)) return 'Windows'; // любой
else return 'Unknown'; } // неизвестная система

# получение параметров ссылки
public function params($parts, $key, $param) {
$slice = $key + 1; $parts = array_slice($parts, $slice); // отрезок ссылки, параметры
$counter = 1; $num = ($param) ? 1 : 2; $count = count($parts) - $num; // подсчет количества массива
$counter += ($count > 0) ? floor($count / 2) : 0; // подсчет количества параметров
$params = array(); for ($how = 0; $how < $counter; $how++) { // создание цикла
if ($how == 0 && $param) $params['param'] = current($parts); // запись начального параметра
elseif ($how == 0) $params[current($parts)] = next($parts); else // запись первого параметра
$params[next($parts)] = next($parts); } return $params; } // запись общих параметров

# парсинг ссылки
public function parse($url) {
$url = str_replace('%20', '', $url);  // удаление пробелов из ссылки
return explode('/', trim($url, ' /')); } // разделение ссылки на части

# вывод случайной строки 
public function random($count, $number = false) {
if ($number) $chars = '1234567890'; else // цифры
$chars = 'abcdefghijklmnopqrstuvwxy1234567890'; // буквы и цифры
$length = strlen($chars); $string = ''; // подсчет количества символов
for ($how = 0; $how < $count; $how++) { // количество случайной строки
$string .= substr($chars, rand(0, $length-1), 1); } return $string; } // получение строки

# обработка данных сессии
public function sess($name, $value = false, $delete = false) {
if ($delete) { if (isset($_SESSION[$name])) unset($_SESSION[$name]); } // удаление данных
elseif ($value) { $_SESSION[$name] = $value; return false; } // запись данных
else return (isset($_SESSION[$name])) ? $_SESSION[$name] : false; } // получение данных

# проверка ссылки на валидность
public function url($url, $link = false, $params = false) {
$sign = (!$params) ? '/' : ''; $link = (!$link) ? '' : '/'. $link . $sign; // проверка определенной ссылки
$params = (!$params) ? '([a-z0-9\-_/]+)' : '(.*)';  // разрешение параметров у ссылки
return (preg_match('#^'. $link . $params .'\z#ui', $url)) ? true : false; } } // валидность текущей ссылки

# запуск класса
$FUNC = new functions();

?>