<?php

# подсчет количества строк в базе данных
function db_count($db, $table, $select, $data = false) {
if ($data) { $count = 1; $where = ''; foreach ($data as $value => $var) { // проверка выборки, цикл
$par = (strpbrk($value, ';')) ? explode(';', $value) : false; // проверка на знаки
$sign = ($par) ? $par[1] : '='; $value = ($par) ? $par[0] : $value; // определение знаков
if ($count == 1) $where .= '`'. $value .'` '. $sign .' \''. $var .'\''; // первый параметр
else $where .= ' AND `'. $value .'` '. $sign .' \''. $var .'\''; $count++; } // остальные параметры
$where = ' WHERE '. $where; } else $where = false; // запись в запрос
$query = $db->query("SELECT `$select` FROM `$table`$where"); // выполнение запроса
return $query->num_rows; } // проверка количества в базе данных

# запись данных в базу
function db_create($db, $table, $data = false, $insert = false) {
if ($data) { $count = 1; $set = ''; foreach ($data as $value => $var) { // проверка выборки, цикл
if ($count == 1) $set .= '`'. $value .'` = \''. $var .'\''; // первый параметр
else $set .= ', `'. $value .'` = \''. $var .'\''; $count++; } // остальные параметры
$query = $db->query("INSERT INTO `$table` SET $set"); } // выполнение, запись в базу с параметрами
else $query = $db->query("INSERT INTO `$table` () VALUES()"); // выполнение, запись в базу без параметров
return ($insert) ? $db->insert_id : false; } // получение идентификатора записи

# удаление данных из базы данных
function db_delete($db, $table, $data) {
$count = 1; $where = ''; foreach ($data as $value => $var) { // проверка выборки, цикл
if ($count == 1) $where .= '`'. $value .'` = \''. $var .'\''; // первый параметр
else $where .= ' AND `'. $value .'` = \''. $var .'\''; $count++; } // остальные параметры
$query = $db->query("DELETE FROM `$table` WHERE $where"); return false; } // выполнение запроса

# проверка на существование данных
function db_exist($db, $table, $select, $data) {
$count = 1; $where = ''; foreach ($data as $value => $var) { // проверка выборки, цикл
$par = (strpbrk($value, ';')) ? explode(';', $value) : false; // проверка на знаки
$sign = ($par) ? $par[1] : '='; $value = ($par) ? $par[0] : $value; // определение знаков
if ($count == 1) $where .= '`'. $value .'` '. $sign .' \''. $var .'\''; // первый параметр
else $where .= ' AND `'. $value .'` '. $sign .' \''. $var .'\''; $count++; } // остальные параметры
$query = $db->query("SELECT `$select` FROM `$table` WHERE $where"); // выполнение запроса
$count = $query->num_rows; return ($count != 0) ? true : false; } // проверка количества, существование

# вывод данных из базы данных
function db_output($db, $table, $select, $data = false, $post = false, $order = 'id', $limit = 0, $limiter = 0, $sort = 'ASC') {
$count = 1; $where = ''; if ($data) { $where .= 'WHERE '; foreach ($data as $value => $var) { // проверка выборки, цикл
$par = (strpbrk($value, ';')) ? explode(';', $value) : false; // проверка на знаки
$sign = ($par) ? $par[1] : '='; $value = ($par) ? $par[0] : $value; // определение знаков
if ($count == 1) $where .= '`'. $value .'` '. $sign .' \''. $var .'\''; // одиночный параметр
else $where .= ' AND `'. $value .'` '. $sign .' \''. $var .'\''; $count++; } } // остальные параметры
if (is_array($select)) { $count = 1; $entry = ''; foreach ($select as $value) { // проверка массива данных, цикл
if ($count == 1) $entry .= '`'. $value .'`'; else $entry .= ', `'. $value .'`'; $count++; } } // параметры массива
elseif ($select == '*') $entry = '*'; else $entry = '`'. $select .'`'; // выборка всего или единочного параметра
$limit = ($limit > 0) ? 'LIMIT '. $limit : 'LIMIT 1'; // установка лимита на вывод данных, первый уровень
$limiter = ($limiter > 0) ? 'OFFSET '. $limiter : ''; // установка лимита на вывод данных, второй уровень
$query = $db->query("SELECT $entry FROM `$table` $where ORDER BY `$order` $sort $limit $limiter"); // выполнение запроса
$output = ($post) ? $query : $query->fetch_assoc(); return $output; } // вывод данных, определение на пост

# обновление данных в базе данных
function db_update($db, $table, $select, $data, $edit = false) {
$count = 1; $where = ''; foreach ($data as $value => $var) { // проверка выборки, цикл
$par = (strpbrk($value, ';')) ? explode(';', $value) : false; // проверка на знаки
$sign = ($par) ? $par[1] : '='; $value = ($par) ? $par[0] : $value; // определение знаков
if ($count == 1) $where .= '`'. $value .'` '. $sign .' \''. $var .'\''; // одиночный параметр
else $where .= ' AND `'. $value .'` '. $sign .' \''. $var .'\''; $count++; } // остальные параметры
$count = 1; $entry = ''; foreach ($select as $value => $var) { // обновляемые данные, цикл
if (!$edit) { $par = (strpbrk($var, ';')) ? explode(';', $var) : false; } else $par = false; // проверка на знаки
$sign = ($par) ? ' '. $par[1] .' '. $par[0] : ''; $var = ($par) ? '`'. $value .'`' : '\''. $var .'\''; // изменение значения
if ($count == 1) $entry .= '`'. $value .'` = '. $var . $sign; // одиночные данные
else $entry .= ', `'. $value .'` = '. $var . $sign; $count++; } // остальные данные
$query = $db->query("UPDATE `$table` SET $entry WHERE $where"); return false; } // выполнение запроса

?>