<?php
include_once ('./core/base.php');
falseauth();

// Подключение логики рангов
include_once ('./core/func.php'); 

$header = 'Арена';
include_once ('./core/head.php');

// --- КРИТИЧЕСКОЕ ИСПРАВЛЕНИЕ: ОЧИСТКА ЗАВИСШИХ СТАТУСОВ ---
// Находим всех игроков, которые отмечены 'pvp', но не имеют активной записи в таблице pvp
$stuck_players_q = $base->query("SELECT u.id FROM `users` u
                                 LEFT JOIN `pvp` p ON (u.id = p.first_user OR u.id = p.second_user)
                                 WHERE u.battle = 'pvp' AND p.id IS NULL AND u.id != 12");
if ($stuck_players_q->num_rows > 0) {
    while($stuck = $stuck_players_q->fetch_assoc()) {
        // Сбрасываем их статус 'pvp' на 'no'
        $base->query("UPDATE `users` SET `battle` = 'no' WHERE `id` = '{$stuck['id']}'");
    }
}
// -----------------------------------------------------------


$arena_data = get_arena_rank_data($u['arena_rank_level']);
$progress_percent = $arena_data['max_rank'] ? 100 : round(($u['arena_points'] / $arena_data['required']) * 100, 1);
if ($progress_percent > 100) $progress_percent = 100;

echo '<div class="b"><div class="title">Арена</div>';

// --- Ранг и Шкала Прогресса ---
echo '<div class="event_item">';
echo '<center>';
echo '<img src="/images/icons/ranks/'.$arena_data['icon'].'" width="64px"><br/>';
echo '<b>Текущий Ранг: '.$arena_data['rank_name'].'</b>';
echo '</center>';

// Шкала прогресса
echo '<div class="exp" style="height: 12px; margin-top: 5px; background-size: '.$progress_percent.'% 12px; text-shadow: black 0 1px 0;">';
if (!$arena_data['max_rank']) {
    echo '<font size="1">Прогресс: '.$u['arena_points'].'/'.$arena_data['required'].' Очков ('.$progress_percent.'%)</font>';
} else {
    echo '<font size="1">Максимальный Ранг Достигнут</font>';
}
echo '</div>';
echo '</div>';

// --- Кнопки Навигации ---
echo '<div class="title">Бои и Магазин</div>';
echo '<a class="btn" href="/arena/rating/"><img src="/images/icons/rank.png"> Рейтинг Бойцов</a>';
echo '<a class="btn" href="/arena/shop/"><img src="/images/icons/arena_coin.png"> Магазин Арены</a>';


// --- Список Игроков (ГЛОБАЛЬНЫЙ ПОИСК ВСЕХ ИГРОКОВ) ---
// Запрашиваем всех игроков, включая время кулдауна
$glob_users_q = $base->query('SELECT u.*, c.cooldown_end_time
                              FROM `users` u
                              LEFT JOIN `pvp_cooldown` c ON u.id = c.target_id AND c.user_id = "'.$u['id'].'"
                              WHERE u.id != "'.$u['id'].'" AND u.id != 12 
                              ORDER BY u.arena_rank_level DESC, u.arena_points DESC LIMIT 20');
$glob_users_nr = $glob_users_q->num_rows;

echo '<div class="title">Вызвать на Дуэль (Всего: '.$glob_users_nr.')</div>';

if($glob_users_nr > 0){
    while($loc_user = $glob_users_q->fetch_assoc()){
        
        $rank_data = get_arena_rank_data($loc_user['arena_rank_level']);
        $user_id = $loc_user['id'];
        
        // --- ПРОВЕРКА СТАТУСА ---
        $cooldown_end = $loc_user['cooldown_end_time'] ?? 0;
        $time_left = $cooldown_end - time();
        $can_attack = $time_left <= 0;
        
        $status_icon = ($loc_user['date_online'] > (time() - 600)) 
                       ? '<img src="/images/icons/online.png" width="18px">' 
                       : '<img src="/images/icons/offline.png" width="18px">';
        
        $disabled = '';
        $button_text = ' <img src="/images/icons/sword.png"> Вызвать';

        if ($loc_user['battle'] != 'no') {
            // Игрок в любом активном бою (PvE, PvB, PvP)
            $disabled = 'style="background-color: #301010; color: #555555;"';
            $button_text = ' [В бою]';
            $can_attack = false;
        } elseif (!$can_attack) {
            // Игрок на кулдауне
            $disabled = 'style="background-color: #301010; color: gray;"';
            $button_text = ' [Кулдаун: '.tl($time_left).']';
        }

        echo '<a class="btn" href="'.($can_attack ? '/pvp/start/'.$user_id.'/' : 'javascript:void(0)').'" '.$disabled.'>';
        echo $status_icon.' ';
        echo '<img src="/images/icons/ranks/'.$rank_data['icon'].'" width="24px"> ';
        echo nolinkname($user_id).' <small>('.$rank_data['rank_name'].')</small>';
        echo $button_text;
        echo '</a>';
    }
} else {
    echo '<center>Нет игроков, доступных для дуэли.</center>';
}

echo '<br/><a class="btn" href="/"><img src="/images/icons/back.png"> Назад в Меню</a>';
echo '</div>';
include_once ('./core/foot.php');
?>