<?php
include_once ('./core/base.php');
falseauth();

$header = 'Боевой Пропуск';
include_once ('./core/head.php');

$current_bp = $base->query("SELECT * FROM `battlepass` WHERE `is_active` = 'yes' LIMIT 1")->fetch_assoc();

if (!$current_bp) {
    $_SESSION['message'] = 'Боевой пропуск сейчас не активен.';
    header('Location: /');
    exit;
}

// --- Логика начисления награды за УРОВЕНЬ (Исправлен баг с многократным получением и добавлена выдача предметов) ---
if (isset($_GET['claim_level']) && $_GET['claim_level'] > 0) {
    $level_to_claim = intval($_GET['claim_level']);

    if ($u['bp_level'] < $level_to_claim) {
        $_SESSION['message'] = 'Этот уровень еще не открыт!';
    } else {
        $level_reward = $base->query("SELECT * FROM `battlepass_levels` WHERE `bp_id` = '{$current_bp['id']}' AND `level` = '{$level_to_claim}' LIMIT 1")->fetch_assoc();
        
        // Проверка: Получена ли уже награда (полагается на таблицу users_claimed_bp_rewards)
        $is_claimed = $base->query("SELECT id FROM `users_claimed_bp_rewards` WHERE `user_id` = '{$u['id']}' AND `bp_level` = '{$level_to_claim}' LIMIT 1")->num_rows;

        if ($level_reward && !$is_claimed) {
            // Начисление награды
            $reward_amount = $level_reward['reward_amount'];
            $reward_type = $level_reward['reward_type'];
            $message = 'Награда получена!';
            
            if ($reward_type == 'crystals') {
                $base->query("UPDATE `users` SET `crystals` = `crystals` + '{$reward_amount}' WHERE `id` = '{$u['id']}' LIMIT 1");
                $message = "Получено {$reward_amount} кристаллов!";
            } elseif ($reward_type == 'gold') {
                $base->query("UPDATE `users` SET `gold` = `gold` + '{$reward_amount}' WHERE `id` = '{$u['id']}' LIMIT 1");
                $message = "Получено {$reward_amount} золота!";
            } elseif ($reward_type == 'silver') {
                $base->query("UPDATE `users` SET `silver` = `silver` + '{$reward_amount}' WHERE `id` = '{$u['id']}' LIMIT 1");
                $message = "Получено {$reward_amount} серебра!";
            } elseif ($reward_type == 'item' && $level_reward['item_id'] > 0) {
                
                $item_id = $level_reward['item_id'];
                $item_amount = $level_reward['item_amount'];
                $item_data = $base->query("SELECT * FROM `items` WHERE `id` = '{$item_id}' LIMIT 1")->fetch_assoc();

                if ($item_data) {
                    // Логика выдачи предмета
                    if ($item_data['what'] == 'clothing') {
                        // Одежда (создаем новую запись)
                        $base->query("INSERT INTO `users_items` (user, name, description, image, level, what, type, attack_type, p_att, m_att, p_def, m_def, endurance, intellect, agility, skill, max_quality, mark, cost, ident_id, amount) VALUES (
                            '{$u['id']}', '{$item_data['name']}', '{$item_data['description']}', '{$item_data['image']}', '{$item_data['level']}', '{$item_data['what']}', '{$item_data['type']}', '{$item_data['attack_type']}', '{$item_data['p_att']}', '{$item_data['m_att']}', '{$item_data['p_def']}', '{$item_data['m_def']}', '{$item_data['endurance']}', '{$item_data['intellect']}', '{$item_data['agility']}', '{$item_data['skill']}', '{$item_data['max_quality']}', '{$item_data['mark']}', '{$item_data['cost']}', '{$item_data['id']}', '{$item_amount}')");
                    } else {
                         // Ресурс/Зелье/Руна (стек)
                         $old_item = $base->query("SELECT id FROM `users_items` WHERE `user` = '{$u['id']}' AND `ident_id` = '{$item_id}' LIMIT 1")->num_rows;
                         if ($old_item > 0) {
                             $base->query("UPDATE `users_items` SET `amount` = `amount` + '{$item_amount}' WHERE `user` = '{$u['id']}' AND `ident_id` = '{$item_id}' LIMIT 1");
                         } else {
                             $base->query("INSERT INTO `users_items` (user, name, image, what, potion, hp_regen, mp_regen, mark, cost, ident_id, amount) VALUES (
                                 '{$u['id']}', '{$item_data['name']}', '{$item_data['image']}', '{$item_data['what']}', '{$item_data['potion']}', '{$item_data['hp_regen']}', '{$item_data['mp_regen']}', '{$item_data['mark']}', '{$item_data['cost']}', '{$item_data['id']}', '{$item_amount}')");
                         }
                    }
                    $message = "Получено {$item_amount} x {$item_data['name']}!";
                } else {
                    $_SESSION['message'] = 'Ошибка: Предмет не найден в базе игры.';
                    header('Location: /battlepass/');
                    exit;
                }
            }


            // Отметка о получении награды за уровень
            $base->query("INSERT INTO `users_claimed_bp_rewards` SET `user_id` = '{$u['id']}', `bp_level` = '{$level_to_claim}', `claim_time` = '".time()."'");
            $_SESSION['message'] = $message;

        } else {
            $_SESSION['message'] = 'Награда уже получена или не существует.';
        }
    }
    header('Location: /battlepass/');
    exit;
}

// --- Логика получения награды за задание (ОПЫТ БП) ---
if (isset($_GET['claim_quest']) && $_GET['claim_quest'] > 0) {
    $quest_id = intval($_GET['claim_quest']);
    $u_quest = $base->query("SELECT * FROM `users_battlepass_quests` WHERE `user_id` = '{$u['id']}' AND `quest_id` = '{$quest_id}' AND `is_completed` = 'yes' AND `is_claimed` = 'no' LIMIT 1")->fetch_assoc();
    $bp_quest = $base->query("SELECT * FROM `battlepass_quests` WHERE `id` = '{$quest_id}' LIMIT 1")->fetch_assoc();

    if ($u_quest && $bp_quest) {
        // Начисление BP опыта
        include_once ('core/bp_logic.php'); // Должен быть подключен
        $exp_message = add_bp_exp($u['id'], $bp_quest['exp_reward'], $base);

        // Обновление статуса задания
        $base->query("UPDATE `users_battlepass_quests` SET `is_claimed` = 'yes' WHERE `id` = '{$u_quest['id']}' LIMIT 1");

        $_SESSION['message'] = "Получено {$bp_quest['exp_reward']} опыта БП за задание «{$bp_quest['name']}»! " . ($exp_message !== true ? $exp_message : '');
    } else {
        $_SESSION['message'] = 'Задание еще не выполнено или награда уже получена.';
    }
    header('Location: /battlepass/');
    exit;
}
// ------------------------------------------

// --- Определение требуемого опыта для следующего уровня (Исправлен расчет) ---
$next_level = $u['bp_level'] + 1;
$next_level_data = $base->query("SELECT `exp_needed` FROM `battlepass_levels` WHERE `bp_id` = '{$current_bp['id']}' AND `level` = '{$next_level}' LIMIT 1")->fetch_assoc();

// Если есть следующий уровень, берем его требования EXP
if ($next_level_data) {
    $exp_needed_for_next = $next_level_data['exp_needed'];
    $progress_in_level = $u['bp_exp']; 
} else {
    // Если это максимальный уровень, то прогресс равен текущему опыту (для 100% заполнения)
    $exp_needed_for_next = $u['bp_exp']; 
    $progress_in_level = $u['bp_exp']; 
}

$progress_percent = $exp_needed_for_next > 0 ? round(($progress_in_level / $exp_needed_for_next) * 100, 1) : 100;
if ($progress_percent > 100) $progress_percent = 100;

?>

<style>
.bp-progress-bar {
    width: 95%;
    background-color: #303040;
    border: 1px solid #404050;
    border-radius: 5px;
    margin: 5px auto;
    position: relative;
    height: 25px;
    overflow: hidden;
}
.bp-progress-fill {
    height: 100%;
    background-color: #DD4FFF; /* Мифический цвет */
    background-image: linear-gradient(45deg, #DD4FFF, #B130E0);
    width: <?=$progress_percent?>%;
    text-align: center;
    line-height: 25px;
    color: white;
    font-weight: bold;
    text-shadow: black 1px 1px 1px;
    transition: width 0.5s;
}
.bp-level-info {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    text-align: center;
    line-height: 25px;
    color: white;
    font-weight: bold;
    text-shadow: black 1px 1px 1px;
}
</style>

<div class="b">
    <div class="title">Боевой Пропуск: <?=$current_bp['name']?></div>

    <div class="bp-progress-bar">
        <div class="bp-progress-fill"></div>
        <div class="bp-level-info">
            Уровень БП: <?=$u['bp_level']?> (<?=$progress_in_level?> / <?=$exp_needed_for_next?> EXP)
        </div>
    </div>
    
    <div class="line"></div>

    <div class="title">Ежедневные Задания</div>

    <?php 
    // Таймер сброса заданий
    $time_to_reset = 86400 - (time() - $u['bp_quests_update_time']);
    $time_to_reset_text = ($time_to_reset > 0) ? tl($time_to_reset) : 'Доступно!';

    echo '<div class="event"><center>Сброс ежедневных заданий: <b>'.$time_to_reset_text.'</b></center></div>';

    // Получение активных ежедневных заданий игрока
    $u_quests_q = $base->query("SELECT uq.*, bq.* FROM `users_battlepass_quests` uq
        JOIN `battlepass_quests` bq ON uq.quest_id = bq.id
        WHERE uq.user_id = '{$u['id']}' AND bq.is_daily = 'yes'");


    if ($u_quests_q->num_rows > 0) {
        while ($uq = $u_quests_q->fetch_assoc()) {
            $progress_percent_q = round(($uq['progress'] / $uq['target_count']) * 100, 1);
            if ($progress_percent_q > 100) $progress_percent_q = 100;
            
            $status_color = 'orange';
            $status_text = 'В процессе';
            $action_link = '';

            if ($uq['is_claimed'] == 'yes') {
                $status_color = 'lime';
                $status_text = 'Награда получена';
                $action_link = '';
            } elseif ($uq['is_completed'] == 'yes') {
                $status_color = 'gold';
                $status_text = 'Готово к получению!';
                $action_link = '<a class="btn_mini green" href="/battlepass/claim_quest/'.$uq['quest_id'].'/">Получить EXP</a>';
            }

            echo '<div class="event_item">';
            echo '<b>'.$uq['name'].'</b> (Цель: '.$uq['target_count'].')<br/>';
            echo '<small>Прогресс: ('.$uq['progress'].'/'.$uq['target_count'].') ';
            echo 'Награда: <img src="/images/icons/exp.png" width="16px"> '.$uq['exp_reward'];
            echo '</small><br/>';
            echo '<div style="background-color: #303040; border-radius: 3px; height: 10px; margin-top: 3px;">';
            echo '<div style="width: '.$progress_percent_q.'%; background-color: #68A8F9; height: 100%; border-radius: 3px;"></div>';
            echo '</div>';
            echo '<font color="'.$status_color.'" size="1">'.$status_text.'</font> '.$action_link;
            echo '</div>';
        }
    } else {
        echo '<div class="event"><center>Ежедневные задания скоро появятся! Зайдите на главную страницу, чтобы обновить их.</center></div>';
    }
    ?>

    <div class="title">Награды за Уровень</div>
    <div class="event_table">
        <table class="a_table a_table-common" width="100%">
            <tr>
                <td>Ур.</td>
                <td>EXP</td>
                <td>Награда</td>
                <td>Действие</td>
            </tr>
            <?php
            $levels_q = $base->query("SELECT * FROM `battlepass_levels` WHERE `bp_id` = '{$current_bp['id']}' ORDER BY `level` ASC");
            while ($level = $levels_q->fetch_assoc()) {
                $is_unlocked = $u['bp_level'] >= $level['level'];
                
                // Проверяем, есть ли запись в users_claimed_bp_rewards
                $is_claimed_level = $base->query("SELECT id FROM `users_claimed_bp_rewards` WHERE `user_id` = '{$u['id']}' AND `bp_level` = '{$level['level']}' LIMIT 1")->num_rows;
                
                $reward_text = '';
                if ($level['reward_type'] == 'crystals') {
                    $reward_text = '<img src="/images/icons/crystals.png" width="12px"> '.$level['reward_amount'];
                } elseif ($level['reward_type'] == 'gold') {
                    $reward_text = '<img src="/images/icons/gold.png" width="12px"> '.$level['reward_amount'];
                } elseif ($level['reward_type'] == 'silver') {
                    $reward_text = '<img src="/images/icons/silver.png" width="12px"> '.$level['reward_amount'];
                } elseif ($level['reward_type'] == 'item') {
                    // Выводим информацию о предмете
                    $item_name_q = $base->query("SELECT `name` FROM `items` WHERE `id` = '{$level['item_id']}' LIMIT 1")->fetch_assoc();
                    $item_name = $item_name_q ? $item_name_q['name'] : 'Ошибка предмета!';
                    $reward_text = '<img src="/images/icons/bag.png" width="12px"> x'.$level['item_amount'].' '.$item_name;
                }

                $action_button = '';
                if ($is_claimed_level) {
                    $action_button = '<div class="btn_mini_pressed">Получено</div>';
                } elseif ($is_unlocked) {
                    $action_button = '<a class="btn_mini green" href="/battlepass/claim_level/'.$level['level'].'/">Получить</a>';
                } else {
                    $action_button = '<div class="btn_mini" style="background-image: none; border-color: gray; color: gray;">Недоступно</div>';
                }

                $level_class = $is_unlocked ? 'row-odd' : 'row-even';

                echo '<tr class="'.$level_class.'">';
                echo '<td>'.$level['level'].'</td>';
                echo '<td>'.n_f($level['exp_needed']).'</td>';
                echo '<td>'.$reward_text.'</td>';
                echo '<td>'.$action_button.'</td>';
                echo '</tr>';
            }
            ?>
        </table>
    </div>

    <br/><a class="btn" href="/"><img src="/images/icons/back.png"> Назад</a>

</div>

<?php include_once ('./core/foot.php'); ?>