<?php
// core/bp_logic.php

// Функция для начисления BP опыта и проверки повышения уровня
function add_bp_exp($user_id, $exp_amount, $base) {
    // Получаем текущие данные игрока
    $u_data = $base->query("SELECT `bp_exp`, `bp_level` FROM `users` WHERE `id` = '{$user_id}' LIMIT 1")->fetch_assoc();
    if (!$u_data) return false;

    $new_exp = $u_data['bp_exp'] + $exp_amount;
    $current_level = $u_data['bp_level'];
    $new_level = $current_level;
    $leveled_up = false;
    
    // Получаем ID активного БП
    $bp_id_q = $base->query("SELECT `id` FROM `battlepass` WHERE `is_active` = 'yes' LIMIT 1")->fetch_assoc();
    if (!$bp_id_q) return $base->query("UPDATE `users` SET `bp_exp` = '{$new_exp}' WHERE `id` = '{$user_id}'");
    $bp_id = $bp_id_q['id'];

    // Проверка повышения уровня (Логика Rolling EXP)
    while (true) {
        // Получаем требуемый EXP для перехода на СЛЕДУЮЩИЙ уровень.
        $next_level_data = $base->query("SELECT `exp_needed` FROM `battlepass_levels` WHERE `bp_id` = '{$bp_id}' AND `level` = '".($new_level + 1)."' LIMIT 1")->fetch_assoc();
        
        if ($next_level_data) {
            $required_exp = $next_level_data['exp_needed'];
            
            if ($new_exp >= $required_exp) {
                // Уровень повышен
                $new_level++;
                $leveled_up = true;
                
                // Вычитаем требуемый EXP
                $new_exp -= $required_exp; 
            } else {
                break; // Недостаточно EXP для следующего уровня
            }
        } else {
            break; // Достигнут максимальный уровень БП
        }
    }
    
    // Обновляем EXP и уровень
    $base->query("UPDATE `users` SET 
        `bp_exp` = '{$new_exp}', 
        `bp_level` = '{$new_level}' 
        WHERE `id` = '{$user_id}' LIMIT 1");
    
    if ($leveled_up) {
        // Здесь можно добавить уведомление в сессию
    }

    return true;
}

// --- ФУНКЦИЯ, КОТОРАЯ ГЕНЕРИРУЕТ ЗАДАНИЯ (ИСПРАВЛЕНА ЛОГИКА СБРОСА) ---
function check_and_generate_bp_quests($user_id, $base) {
    
    $u_data = $base->query("SELECT `bp_quests_update_time` FROM `users` WHERE `id` = '{$user_id}' LIMIT 1")->fetch_assoc();
    if (!$u_data) return false;

    // Считаем общее количество НАЗНАЧЕННЫХ заданий (независимо от выполнения/получения награды)
    $total_assigned_quests = $base->query("SELECT id FROM `users_battlepass_quests` WHERE `user_id` = '{$user_id}'")->num_rows;
    
    $time_since_update = time() - $u_data['bp_quests_update_time'];
    $is_reset_time = $time_since_update >= 86400; // 24 часа

    // КЛЮЧЕВОЙ ФИКС: Если назначено 3 задания И 24 часа не прошло, БЛОКИРУЕМ генерацию.
    // Если assigned_quests_count == 3, это означает, что у игрока есть текущий набор.
    if ($total_assigned_quests == 3 && !$is_reset_time) {
        return false;
    }

    // Если нет активного BP, прекращаем.
    $bp_id_q = $base->query("SELECT `id` FROM `battlepass` WHERE `is_active` = 'yes' LIMIT 1")->fetch_assoc();
    if (!$bp_id_q) return "Нет активного Боевого Пропуска.";
    $bp_id = $bp_id_q['id'];
    
    // 1. Удаляем все старые задания для пользователя
    // Если время сброса пришло, или заданий не было вовсе, мы удаляем все старые записи.
    $base->query("DELETE FROM `users_battlepass_quests` WHERE `user_id` = '{$user_id}'");

    // 2. Выбираем 3 случайных ЕЖЕДНЕВНЫХ задания для присвоения
    $new_quests_q = $base->query("SELECT `id` FROM `battlepass_quests` WHERE `bp_id` = '{$bp_id}' AND `is_daily` = 'yes' ORDER BY RAND() LIMIT 3");
    
    $values = [];
    while($quest = $new_quests_q->fetch_assoc()) {
        $values[] = "('{$user_id}', '{$quest['id']}', 0, 'no', 'no')";
    }

    // 3. Вставляем новые задания и обновляем время
    if (!empty($values)) {
        $insert_query = "INSERT INTO `users_battlepass_quests` (`user_id`, `quest_id`, `progress`, `is_completed`, `is_claimed`) VALUES " . implode(', ', $values);
        $base->query($insert_query);
        
        // Обновляем время только при успешной генерации нового набора
        $base->query("UPDATE `users` SET `bp_quests_update_time` = '".time()."' WHERE `id` = '{$user_id}' LIMIT 1");
        return "Новые ежедневные задания сгенерированы!";
    }
    
    return "Не удалось найти заданий для назначения в таблице БП.";
}

// --- Логика обработки убийства моба для прогресса БП ---
function check_bp_quest_progress_kill($user_id, $mob_id, $base) {
    
    $bp_id_q = $base->query("SELECT `id` FROM `battlepass` WHERE `is_active` = 'yes' LIMIT 1")->fetch_assoc();
    if (!$bp_id_q) return;

    $quests_to_update_q = $base->query("SELECT uq.id, uq.progress, bq.target_count, bq.id as quest_main_id
        FROM `users_battlepass_quests` uq
        JOIN `battlepass_quests` bq ON uq.quest_id = bq.id
        WHERE uq.user_id = '{$user_id}'
        AND bq.type = 'kill_mob'
        AND bq.mob_id = '{$mob_id}'
        AND uq.is_completed = 'no'");

    while ($uq = $quests_to_update_q->fetch_assoc()) {
        if ($uq['progress'] < $uq['target_count']) {
            $new_progress = $uq['progress'] + 1;
            $is_completed = ($new_progress >= $uq['target_count']) ? 'yes' : 'no';

            $base->query("UPDATE `users_battlepass_quests` SET 
                `progress` = '{$new_progress}',
                `is_completed` = '{$is_completed}'
                WHERE `id` = '{$uq['id']}' LIMIT 1");
        }
    }
}
?>