<?php
// core/fishing_logic.php

function calculate_fish_catch($user_id, $base) {
    global $u;
    
    // 1. Получаем экипированные снасти
    $rod = $base->query("SELECT * FROM `fishing_rods` WHERE `id` = '{$u['equipped_rod_id']}' LIMIT 1")->fetch_assoc();
    $bait = $base->query("SELECT * FROM `fishing_baits` WHERE `id` = '{$u['equipped_bait_id']}' LIMIT 1")->fetch_assoc();
    
    // 2. Получаем базовые шансы для всех редкостей
    $base_chances_q = $base->query("SELECT rarity_id, base_chance FROM `fish_rarity_chances`");
    $base_chances = $base_chances_q ? $base_chances_q->fetch_all(MYSQLI_ASSOC) : [];
    
    // 3. Получаем модификаторы от снастей
    $mods = [];
    if ($rod) {
        $rod_mods_q = $base->query("SELECT rarity_id, modifier_percent FROM `fishing_chance_mods` WHERE `type` = 'rod' AND `item_id` = '{$rod['id']}'");
        while($mod = $rod_mods_q->fetch_assoc()) {
            $mods[$mod['rarity_id']] = ($mods[$mod['rarity_id']] ?? 0) + $mod['modifier_percent'];
        }
    }
    if ($bait) {
        $bait_mods_q = $base->query("SELECT rarity_id, modifier_percent FROM `fishing_chance_mods` WHERE `type` = 'bait' AND `item_id` = '{$bait['id']}'");
        while($mod = $bait_mods_q->fetch_assoc()) {
            $mods[$mod['rarity_id']] = ($mods[$mod['rarity_id']] ?? 0) + $mod['modifier_percent'];
        }
    }

    // 4. Расчет финальных шансов и создание "рулетки"
    $total_chance_pool = 0;
    $final_chances = [];
    
    foreach ($base_chances as $bc) {
        $rarity_id = $bc['rarity_id'];
        // Базовый шанс + Модификатор от снастей
        $final_chance = $bc['base_chance'] + ($mods[$rarity_id] ?? 0);
        
        // Шанс не может быть меньше нуля
        if ($final_chance < 0) $final_chance = 0;
        
        $final_chances[$rarity_id] = $final_chance;
        $total_chance_pool += $final_chance;
    }

    // 5. Выбор редкости
    $roll = mt_rand(1, $total_chance_pool > 0 ? $total_chance_pool : 10000); // Roll 1-10000 (или пул)
    $cumulative_chance = 0;
    $caught_rarity_id = null;
    
    foreach ($final_chances as $rarity_id => $chance) {
        $cumulative_chance += $chance;
        if ($roll <= $cumulative_chance) {
            $caught_rarity_id = $rarity_id;
            break;
        }
    }

    // 6. Если редкость определена, выбираем случайную рыбу этой редкости
    if ($caught_rarity_id !== null) {
        $fish_q = $base->query("SELECT id FROM `fish` WHERE `rarity_id` = '{$caught_rarity_id}' ORDER BY RAND() LIMIT 1");
        if ($fish_q && $fish_q->num_rows > 0) {
            return $fish_q->fetch_assoc()['id'];
        }
    }
    
    return null; // Улов не удался
}
?>