<?php
include_once ('./core/base.php');
falseauth();

$header = 'Ежедневная награда';
include_once ('./core/head.php');

$daily_rewards = [
    1 => 5,   // День 1: 5 кристаллов
    2 => 10,  // День 2: 10 кристаллов
    3 => 15,  // День 3: 15 кристаллов
    4 => 20,  // День 4: 20 кристаллов
    5 => 30,  // День 5: 30 кристаллов
    6 => 40,  // День 6: 40 кристаллов
    7 => 50,  // День 7: 50 кристаллов (сброс после получения)
];

$next_day = $u['daily_reward_day'] + 1;
if ($next_day > 7) {
    $next_day = 1;
}
$current_reward = $daily_rewards[$next_day];

// Проверка: можно ли получить награду?
$can_claim = (time() - $u['last_daily_reward_time']) >= 86400; // 86400 секунд = 24 часа

if (isset($_GET['claim']) && $_GET['claim'] == 'yes') {
    if (!$can_claim) {
        $_SESSION['message'] = 'Ежедневная награда доступна не чаще одного раза в сутки.';
        header('Location: /daily_reward/');
        exit;
    }

    $reward_day = $u['daily_reward_day'] + 1;
    if ($reward_day > 7) {
        $reward_day = 1;
    }
    
    $reward_amount = $daily_rewards[$reward_day];

    // Начисление награды
    $base->query("UPDATE `users` SET 
        `crystals` = `crystals` + '{$reward_amount}', 
        `daily_reward_day` = '{$reward_day}',
        `last_daily_reward_time` = '".time()."'
        WHERE `id` = '{$u['id']}' LIMIT 1");

    $_SESSION['message'] = "Вы получили ежедневную награду: {$reward_amount} кристаллов! Текущий день цикла: {$reward_day}";
    header('Location: /daily_reward/');
    exit;
}

echo '<div class="b"><div class="title">Ежедневная награда</div>';

echo '<center><div class="border"><img style="width: 100%; max-width: 64px;" src="/images/events/crystals_daily.png"></div></center>';

echo '<div class="event"><center>';
echo 'Заходите каждый день, чтобы получить больше кристаллов! Награды сбрасываются после 7-го дня.';
echo '</center></div>';

echo '<div class="title">Награда за сегодня (День '.($u['daily_reward_day'] + 1 > 7 ? 1 : $u['daily_reward_day'] + 1).')</div>';

echo '<center>';
if ($can_claim) {
    echo '<div class="event">';
    echo 'Ваша награда: <img src="/images/icons/crystals.png"> <b>'.$current_reward.'</b> кристаллов!';
    echo '<br/><a class="btn_small green" href="/daily_reward/claim/yes/">Получить награду</a>';
    echo '</div>';
} else {
    $time_left = $u['last_daily_reward_time'] + 86400 - time();
    echo '<div class="event">';
    echo '<b>Вы уже получили награду сегодня.</b><br/>';
    echo 'Следующая награда будет доступна через: <b>'.tl($time_left).'</b>';
    echo '</div>';
}
echo '</center>';

echo '<div class="title">Цикл наград</div>';

echo '<div class="event_table">';
echo '<table class="a_table a_table-common" width="100%">';
echo '<tr><td>День</td><td>Награда</td><td>Статус</td></tr>';

for ($i = 1; $i <= 7; $i++) {
    $status = '—';
    $is_next = false;
    
    if ($u['daily_reward_day'] == 7 && $i == 1) {
        $is_next = true;
    } elseif ($i == $u['daily_reward_day'] + 1) {
        $is_next = true;
    }
    
    if ($i <= $u['daily_reward_day'] && $u['daily_reward_day'] != 7) {
        $status = '<font color="lime">Получено</font>';
    } elseif ($i == 7 && $u['daily_reward_day'] == 7) {
        $status = '<font color="lime">Получено (Сброс)</font>';
    } elseif ($is_next) {
        $status = '<font color="gold">Текущий</font>';
    }

    echo '<tr>';
    echo '<td>'.$i.'</td>';
    echo '<td><img src="/images/icons/crystals.png"> '.$daily_rewards[$i].'</td>';
    echo '<td>'.$status.'</td>';
    echo '</tr>';
}

echo '</table>';
echo '</div>';


echo '<br/><a class="btn" href="/"><img src="/images/icons/back.png"> Назад</a>';

echo '</div>';

include_once ('./core/foot.php');
?>