<?php
include_once ('./core/base.php');
falseauth();

$header = 'Рыбалка';
include_once ('./core/head.php');
// --- ПОДКЛЮЧЕНИЕ ЛОГИКИ РЫБАЛКИ ---
// Этот файл должен содержать функцию calculate_fish_catch()
include_once ('./core/fishing_logic.php'); 
// ------------------------------------

$action = fl($_GET['action']);
$user_item_id = fl($_GET['item_id']);

// Время рыбалки в минутах (для отображения)
$FISHING_TIME_SEC = 0; 
$rod = $u['equipped_rod_id'] > 0 ? $base->query("SELECT * FROM `fishing_rods` WHERE `id` = '{$u['equipped_rod_id']}' LIMIT 1")->fetch_assoc() : null;
$bait = $u['equipped_bait_id'] > 0 ? $base->query("SELECT * FROM `fishing_baits` WHERE `id` = '{$u['equipped_bait_id']}' LIMIT 1")->fetch_assoc() : null;

if ($rod) $FISHING_TIME_SEC = $rod['fishing_time_min'] * 60;


// --- ЛОГИКА ПРОДАЖИ ---
if ($action == 'sell' && $user_item_id > 0) {
    
    // Ищем предмет, который является РЕСУРСОМ (what='resource') и связан с таблицей fish
    $fish_item_q = $base->query("SELECT ui.*, f.sell_price_silver FROM `users_items` ui JOIN `fish` f ON ui.ident_id = f.id WHERE ui.id = '{$user_item_id}' AND ui.user = '{$u['id']}' AND ui.what = 'resource' LIMIT 1");
    $fish_item = $fish_item_q->fetch_assoc();

    if ($fish_item) {
        $total_sell_price = $fish_item['sell_price_silver'] * $fish_item['amount'];
        $amount = $fish_item['amount'];
        
        // 1. Начисляем серебро
        $base->query("UPDATE `users` SET `silver` = `silver` + '{$total_sell_price}' WHERE `id` = '{$u['id']}' LIMIT 1");

        // 2. Логируем продажу (для рейтинга)
        $base->query("INSERT INTO `fishing_sales_log` (`user_id`, `total_silver_sold`, `sale_date`) VALUES ('{$u['id']}', '{$total_sell_price}', '".time()."')");
        
        // 3. Удаляем рыбу
        $base->query("DELETE FROM `users_items` WHERE `id` = '{$user_item_id}' LIMIT 1");

        $_SESSION['message'] = "Вы продали {$amount}x {$fish_item['name']} за ".n_f($total_sell_price)." серебра!";
        header('Location: /fishing/');
        exit;
    }
    $_SESSION['message'] = 'Ошибка при продаже: предмет не найден в инвентаре.';
    header('Location: /fishing/');
    exit;
}
// ------------------------------------


// --- ЛОГИКА НАЧАЛА РЫБАЛКИ ---
if ($action == 'start' && $u['fishing_start_time'] == 0 && $u['equipped_rod_id'] > 0 && $u['equipped_bait_id'] > 0) {
    // В этом блоке также должна быть логика расходования наживки
    $base->query("UPDATE `users` SET `fishing_start_time` = '".time()."' WHERE `id` = '{$u['id']}' LIMIT 1");
    $_SESSION['message'] = 'Удочка закинута! Ждем улова...';
    header('Location: /fishing/');
    exit;
}

// --- ЛОГИКА СБОРА УЛОВА (КРИТИЧЕСКИ ИСПРАВЛЕНО) ---
if ($action == 'collect' && $u['fishing_start_time'] > 0) {
    $time_elapsed = time() - $u['fishing_start_time'];
    if ($time_elapsed >= $FISHING_TIME_SEC && $FISHING_TIME_SEC > 0) {
        
        // --- Шаг 1: Определение улова (Используем fishing_logic.php) ---
        $fish_id = calculate_fish_catch($u['id'], $base); 
        $amount = 1;
        
        if ($fish_id !== null) {
            $fish_data = $base->query("SELECT * FROM `fish` WHERE `id` = '{$fish_id}' LIMIT 1")->fetch_assoc();
            
            if ($fish_data) {
                // 1. Пытаемся обновить существующий стек (what='resource')
                $base->query("UPDATE `users_items` SET `amount` = `amount` + '{$amount}' WHERE `user` = '{$u['id']}' AND `ident_id` = '{$fish_id}' AND `what` = 'resource'");
                
                if ($base->affected_rows == 0) {
                     // 2. Если стек не найден, вставляем новый элемент со всеми обязательными полями
                     // Заполняем дефолтные значения (0/none) для всех полей, чтобы избежать ошибок NOT NULL
                     $insert_sql = "INSERT INTO `users_items` 
                                     (`user`, `ident_id`, `name`, `what`, `image`, `amount`, `mark`, `cost`, 
                                      `level`, `type`, `attack_type`, `p_att`, `m_att`, `p_def`, `m_def`, `endurance`, `intellect`, `agility`, `skill`, `max_quality`, `potion`, `hp_regen`, `mp_regen`, `rune_type`) 
                                     VALUES (
                                     '{$u['id']}', '{$fish_data['id']}', '{$fish_data['name']}', 'resource', '{$fish_data['image']}', '{$amount}', '{$fish_data['rarity_id']}', '{$fish_data['sell_price_silver']}',
                                     '0', 'none', 'none', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', ''
                                     )";
                     
                    $base->query($insert_sql);
                }

                // Сбрасываем таймер
                $base->query("UPDATE `users` SET `fishing_start_time` = '0' WHERE `id` = '{$u['id']}' LIMIT 1");
                
                $_SESSION['message'] = 'Вы поймали: '.get_item_color_by_rarity($fish_data['rarity_id'], $fish_data['name']).'!';

            } else {
                $_SESSION['message'] = 'Ошибка: Данные рыбы не найдены в справочнике.';
                $base->query("UPDATE `users` SET `fishing_start_time` = '0' WHERE `id` = '{$u['id']}' LIMIT 1");
            }

        } else {
            $_SESSION['message'] = 'Рыба сорвалась...';
            $base->query("UPDATE `users` SET `fishing_start_time` = '0' WHERE `id` = '{$u['id']}' LIMIT 1");
        }

    } else {
        $_SESSION['message'] = 'Время рыбалки еще не истекло.';
    }
    header('Location: /fishing/');
    exit;
}

// --- ОТОБРАЖЕНИЕ ---
echo '<div class="b"><div class="title">Рыбалка</div>';

echo '<center>';
echo '<a class="btn_small" href="/fishing/shop/rods/">Рыболовный Магазин</a>';
echo '<a class="btn_small" href="/fishing/rating/">Рейтинг Продаж</a>';
echo '</center>';

// --- КАРТИНКА РЕКИ ---
echo '<center><div class="border" style="margin-top: 5px;"><img style="width: 100%; max-width: 336px;" src="/images/places/river.png"></div></center>';

echo '<div class="title">Мои Снасти</div>';
echo '<div class="event">';
echo '<b>Удочка:</b> ';
if ($rod) {
    echo get_item_color_by_rarity($rod['rarity_id'], $rod['name']) . ' (<img src="/images/icons/clock.png" width="12px"> '. $rod['fishing_time_min'] .' мин.)';
    echo ' <img src="/images/items/fishing/'.$rod['image'].'" width="24px">';
} else {
    echo '<font color="gray">Не выбрана</font>';
}
echo '<br/><b>Наживка:</b> ';
if ($bait) {
    echo get_item_color_by_rarity($bait['rarity_id'], $bait['name']);
    echo ' <img src="/images/items/fishing/'.$bait['image'].'" width="24px">';
} else {
    echo '<font color="gray">Не выбрана</font>';
}
echo '</div>';

// --- КНОПКА ЗАБРОСА / ТАЙМЕР ---
echo '<div class="title">Заброс Удочки</div>';
echo '<center>';
if ($rod && $bait) {
    if ($u['fishing_start_time'] == 0) {
        echo '<a class="btn green" href="/fishing/start/">Закинуть Удочку</a>';
    } else {
        $time_left = $u['fishing_start_time'] + $FISHING_TIME_SEC - time();
        if ($time_left <= 0) {
            echo '<a class="btn green" href="/fishing/collect/">Забрать Улов!</a>';
        } else {
            echo '<div class="btn_pressed"><img src="/images/icons/clock.png" width="20px"> Ждем: '.tl($time_left).'</div>';
        }
    }
} else {
    echo '<div class="btn_pressed">Выберите удочку и наживку, чтобы начать.</div>';
}
echo '</center>';

// --- ИНВЕНТАРЬ РЫБЫ ---
echo '<div class="title">Мой Улов</div>';
// Запрос на отображение. Ищем предметы с what='resource' и связываем их с fish.
$fish_inv_q = $base->query("SELECT ui.*, f.rarity_id, f.image as fish_image_name, f.sell_price_silver FROM `users_items` ui JOIN `fish` f ON ui.ident_id = f.id WHERE ui.user = '{$u['id']}' AND ui.what = 'resource' AND ui.amount > 0 ORDER BY f.rarity_id DESC");

if ($fish_inv_q && $fish_inv_q->num_rows > 0) {
    while($fish = $fish_inv_q->fetch_assoc()) {
        $color_code = get_rarity_color($fish['rarity_id']);
        $total_silver = $fish['sell_price_silver'] * $fish['amount'];
        
        echo '<div class="event_item">';
        echo '<table cellpadding="0" cellspacing="0" width="100%"><tr>';
        echo '<td width="50%">';
        echo '<img src="/images/items/fish/'.$fish['fish_image_name'].'" width="32px" style="border: 1px solid '.$color_code.';"> ';
        echo get_item_color_by_rarity($fish['rarity_id'], $fish['name']).'';
        echo '</td>';
        echo '<td width="50%" align="right">';
        echo 'x'.$fish['amount'].' | <img src="/images/icons/silver.png" width="12px"> '.n_f($total_silver);
        echo ' <a class="btn_mini" href="/fishing/sell/'.$fish['id'].'/">Продать</a>'; 
        echo '</td></tr></table>';
        echo '</div>';
    }
} else {
    echo '<div class="event"><center>Ваш инвентарь рыбы пуст.</center></div>';
}


echo '<br/><a class="btn" href="/"><img src="/images/icons/back.png"> Назад</a>';
echo '</div>';

include_once ('./core/foot.php');
?>