<?php
include_once ('./core/base.php');
falseauth();

$header = 'Рейтинг Продаж'; 
include_once ('./core/head.php');

$now = time();
$yesterday_midnight = strtotime(date('Y-m-d', $now)) - 86400; // Полночь вчера

// --- Чтение fishing_reward_time из таблицы settings по ID=1 ---
$result_settings = $base->query("SELECT `fishing_reward_time` FROM `settings` WHERE `id` = '1' LIMIT 1");

if ($result_settings === false) {
    // Fallback
    $last_reward_time = 0;
} else {
    $settings_data = $result_settings->fetch_assoc();
    $last_reward_time = $settings_data['fishing_reward_time'] ?? 0;
}
// ----------------------------------------------------------------------


// --- ЛОГИКА НАГРАДЫ (Сброс в полночь) ---
$midnight_today = strtotime(date('Y-m-d', $now)); // Полночь сегодня
$next_reward_time = $midnight_today + 86400; // Следующая полночь

if ($last_reward_time < $midnight_today && $now > $midnight_today) {
    
    // Начисление награды
    $top_sellers_q = $base->query("SELECT user_id, SUM(total_silver_sold) AS total_sold 
                                    FROM `fishing_sales_log` 
                                    WHERE sale_date > '{$yesterday_midnight}' 
                                    GROUP BY user_id 
                                    ORDER BY total_sold DESC 
                                    LIMIT 3");
    
    $place = 1;
    $rewards = [1 => 50, 2 => 30, 3 => 10]; // Кристаллы
    
    if ($top_sellers_q && $top_sellers_q->num_rows > 0) { 
        while ($seller = $top_sellers_q->fetch_assoc()) {
            if ($place <= 3) {
                $reward_amount = $rewards[$place];
                $base->query("UPDATE `users` SET `crystals` = `crystals` + '{$reward_amount}' WHERE `id` = '{$seller['user_id']}' LIMIT 1");
                
                // TODO: Отправка системного сообщения о награде
            }
            $place++;
        }
    }

    // --- ФИКС: Очистка лога продаж за прошлый день ---
    // Удаляем все записи о продажах, которые произошли до полуночи текущего дня.
    // Это гарантирует, что рейтинг обнулится для нового дня.
    $base->query("DELETE FROM `fishing_sales_log` WHERE `sale_date` < '{$midnight_today}'");

    // Обновление таймера в settings
    $base->query("UPDATE `settings` SET `fishing_reward_time` = '{$now}' WHERE `id` = '1' LIMIT 1");
    
    $_SESSION['message'] = 'Награды за прошлый день начислены!';
    header('Location: /fishing/rating/');
    exit;
}
// ------------------------------------------

echo '<div class="b"><div class="title">Рейтинг Продаж</div>';

// --- ОТОБРАЖЕНИЕ ТАЙМЕРА ---
$time_until_reset = $next_reward_time - $now;
echo '<div class="event"><center>';
if ($time_until_reset > 0) {
    echo 'Сброс рейтинга и начисление наград через: <b>'.tl($time_until_reset).'</b>';
} else {
    echo 'Награды начислены. Рейтинг текущего дня начат.';
}
echo '</center></div>';
// ----------------------------


// --- ОТОБРАЖЕНИЕ РЕЙТИНГА ---
// Показываем рейтинг продаж, которые произошли с полуночи вчерашнего дня (т.к. старые уже удалены)
$top_sellers_q = $base->query("SELECT user_id, SUM(total_silver_sold) AS total_sold 
                                FROM `fishing_sales_log` 
                                WHERE sale_date > '{$yesterday_midnight}' 
                                GROUP BY user_id 
                                ORDER BY total_sold DESC 
                                LIMIT 10");

echo '<div class="event_table">';
echo '<table class="a_table a_table-common" width="100%">';
echo '<tr><td>#</td><td>Игрок</td><td>Продано (серебро)</td></tr>';

$rank = 1;
if ($top_sellers_q && $top_sellers_q->num_rows > 0) {
    while ($seller = $top_sellers_q->fetch_assoc()) {
        $user_name = nolinkname($seller['user_id']);
        echo '<tr>';
        echo '<td>'.$rank.'</td>';
        echo '<td>'.$user_name.'</td>';
        echo '<td><img src="/images/icons/silver.png" width="12px"> '.n_f($seller['total_sold']).'</td>';
        echo '</tr>';
        $rank++;
    }
} else {
    echo '<tr><td colspan="3"><center>Рейтинг пока пуст.</center></td></tr>';
}
echo '</table></div>';

echo '<div class="event"><center>
Награда (Кристаллы): 1 место: 50, 2 место: 30, 3 место: 10.
</center></div>';


echo '<br/><a class="btn" href="/fishing/"><img src="/images/icons/back.png"> Назад в Рыбалку</a>';
echo '</div>';
include_once ('./core/foot.php');
?>