<?php
include_once ('./core/base.php');
falseauth();

$header = 'Рыболовный Магазин';
include_once ('./core/head.php');

$section = fl($_GET['section']);
if (!$section) $section = 'rods';

echo '<div class="b"><div class="title">Рыболовный Магазин</div>';

// --- НАВИГАЦИЯ ---
echo '<center>';
if ($section == 'rods') {
    echo '<div class="btn_small_pressed">Удочки</div>';
    echo '<a class="btn_small" href="/fishing/shop/baits/">Наживки</a>';
} else {
    echo '<a class="btn_small" href="/fishing/shop/rods/">Удочки</a>';
    echo '<div class="btn_small_pressed">Наживки</div>';
}
echo '</center>';
echo '<div class="line"></div>';

// --- ЛОГИКА ПОКУПКИ ---
if (isset($_GET['buy'])) {
    $item_id = fl($_GET['buy']);
    $type = fl($_GET['type']);
    
    if ($type == 'rod') {
        $item = $base->query("SELECT * FROM `fishing_rods` WHERE `id` = '{$item_id}' LIMIT 1")->fetch_assoc();
    } elseif ($type == 'bait') {
        $item = $base->query("SELECT * FROM `fishing_baits` WHERE `id` = '{$item_id}' LIMIT 1")->fetch_assoc();
    } else {
        error('Неизвестный тип предмета.');
        goto end_of_shop_logic;
    }

    if ($item) {
        if ($u[$item['price_currency']] >= $item['price_amount']) {
            
            // Снятие средств
            $base->query("UPDATE `users` SET `{$item['price_currency']}` = `{$item['price_currency']}` - '{$item['price_amount']}' WHERE `id` = '{$u['id']}' LIMIT 1");
            
            if ($type == 'rod') {
                // Выдача удочки (замена текущей)
                $base->query("UPDATE `users` SET `equipped_rod_id` = '{$item_id}' WHERE `id` = '{$u['id']}' LIMIT 1");
                $_SESSION['message'] = "Вы купили и надели {$item['name']}!";
            } elseif ($type == 'bait') {
                // Наживка (экипировка)
                $base->query("UPDATE `users` SET `equipped_bait_id` = '{$item_id}' WHERE `id` = '{$u['id']}' LIMIT 1");
                $_SESSION['message'] = "Вы купили и надели {$item['name']}!";
            }
            
        } else {
            $_SESSION['message'] = 'Недостаточно средств.';
        }
    } else {
        $_SESSION['message'] = 'Предмет не найден.';
    }
    header('Location: /fishing/shop/'.$section.'/');
    exit;
}

// --- СПИСОК УДОЧЕК ---
if ($section == 'rods') {
    $list_q = $base->query("SELECT fr.*, r.color_code, r.name_ru FROM `fishing_rods` fr JOIN `rarities` r ON fr.rarity_id = r.id ORDER BY fr.rarity_id DESC, price_amount ASC");
    if ($list_q->num_rows > 0) {
        while($item = $list_q->fetch_assoc()) {
            $cost_color = $u[$item['price_currency']] >= $item['price_amount'] ? '#E0E0E0' : 'ff5050';
            $color_code = get_rarity_color($item['rarity_id']);

            echo '<div class="event_item">';
            echo '<table cellpadding="0" cellspacing="0" width="100%"><tr><td width="60%">';
            // --- ОТОБРАЖЕНИЕ КАРТИНКИ УДОЧКИ ---
            echo '<img src="/images/items/fishing/'.$item['image'].'" width="32px" style="border: 1px solid '.$color_code.'; margin-right: 5px; vertical-align: middle;">';
            echo '<b>' . get_item_color_by_rarity($item['rarity_id'], $item['name']) . '</b>';
            echo '<br/>Время ловли: '.$item['fishing_time_min'].' мин.';
            echo '</td><td width="40%" align="right" valign="middle">';
            // --- ЦЕНА ---
            echo 'Цена: <img src="/images/icons/'.$item['price_currency'].'.png" width="12px"> <font color="'.$cost_color.'">'.n_f($item['price_amount']).'</font>';
            echo ' <a class="btn_mini" href="/fishing/shop/buy/'.$item['id'].'/?type=rod">Купить и Надеть</a>'; 
            echo '</td></tr></table></div>';
        }
    } else {
        echo '<div class="event"><center>Список удочек пуст.</center></div>';
    }
} 
// --- СПИСОК НАЖИВОК ---
elseif ($section == 'baits') {
    $list_q = $base->query("SELECT fb.*, r.color_code, r.name_ru FROM `fishing_baits` fb JOIN `rarities` r ON fb.rarity_id = r.id ORDER BY fb.rarity_id DESC, price_amount ASC");
    if ($list_q->num_rows > 0) {
        while($item = $list_q->fetch_assoc()) {
            $cost_color = $u[$item['price_currency']] >= $item['price_amount'] ? '#E0E0E0' : 'ff5050';
            $color_code = get_rarity_color($item['rarity_id']);

            echo '<div class="event_item">';
            echo '<table cellpadding="0" cellspacing="0" width="100%"><tr><td width="60%">';
            // --- ОТОБРАЖЕНИЕ КАРТИНКИ НАЖИВКИ ---
            echo '<img src="/images/items/fishing/'.$item['image'].'" width="32px" style="border: 1px solid '.$color_code.'; margin-right: 5px; vertical-align: middle;">';
            echo '<b>' . get_item_color_by_rarity($item['rarity_id'], $item['name']) . '</b>';
            echo '<br/>Кол-во в наборе: '.$item['amount_in_pack'];
            echo '</td><td width="40%" align="right" valign="middle">';
            // --- ЦЕНА ---
            echo 'Цена: <img src="/images/icons/'.$item['price_currency'].'.png" width="12px"> <font color="'.$cost_color.'">'.n_f($item['price_amount']).'</font>';
            echo ' <a class="btn_mini" href="/fishing/shop/buy/'.$item['id'].'/?type=bait">Купить и Надеть</a>';
            echo '</td></tr></table></div>';
        }
    } else {
        echo '<div class="event"><center>Список наживок пуст.</center></div>';
    }
}

end_of_shop_logic:
echo '<br/><a class="btn" href="/fishing/"><img src="/images/icons/back.png"> Назад в Рыбалку</a>';
echo '</div>';
include_once ('./core/foot.php');
?>