<?php
include_once ('../core/base.php');
$header = 'Управление Событиями';
include_once ('../core/head.php');
falseauth();
adm();

// Переменная $event здесь не используется, так как мы работаем со списком событий.

if($u['admin'] == 3){

echo '<div class="b">';

switch($act){

default:
    echo '<div class="title">Список Событий</div>';
    
    $bp_q = $base->query("SELECT * FROM `event` ORDER BY `id` DESC");
    if ($bp_q->num_rows > 0) {
        while ($event_item = $bp_q->fetch_assoc()) {
            $status_color = $event_item['is_active'] == 'yes' ? 'lime' : 'red';
            $status_text = $event_item['is_active'] == 'yes' ? 'АКТИВНО' : 'Неактивно';
            
            // Проверка, если событие активно, но дата конца прошла
            if ($event_item['is_active'] == 'yes' && $event_item['end_date'] < time() && $event_item['end_date'] != 0) {
                 $status_text = 'ЗАВЕРШЕНО (Активировано)';
                 $status_color = 'orange';
            }

            echo '<a class="btn" href="/panel/event/edit/'.$event_item['id'].'/">
                <font color="'.$status_color.'">'.$status_text.'</font>: '.$event_item['name'].'
                <br/><small>Валюта: '.$event_item['currency_name'].'</small>
            </a>';
        }
    } else {
        echo '<div class="event"><center>Нет созданных событий.</center></div>';
    }

    echo '<br/><a class="btn" href="/panel/event/new/"><img src="/images/icons/admin.png"> Создать новое событие</a>';
    echo '<a class="btn" href="/panel/"><img src="/images/icons/back.png"> Назад</a>';
    break;

case 'new':
    echo '<div class="title">Создание нового События</div>';
    
    if (isset($_POST['add'])) {
        $name = fl($_POST['name']);
        $currency_name = fl($_POST['currency_name']);
        $currency_image = fl($_POST['currency_image']);
        $min_reward = fl($_POST['min_reward']);
        $max_reward = fl($_POST['max_reward']);
        $start_date = strtotime(fl($_POST['start_date'])); // Преобразование даты в timestamp
        $end_date = strtotime(fl($_POST['end_date']));     // Преобразование даты в timestamp
        
        if (empty($name) || empty($currency_name) || empty($currency_image) || empty($start_date) || empty($end_date)) {
            error('Заполните все поля, включая даты.');
        } elseif ($start_date >= $end_date) {
             error('Дата начала должна быть раньше даты окончания.');
        } else {
            $base->query("INSERT INTO `event` SET 
                `name` = '{$name}',
                `is_active` = 'no',
                `currency_name` = '{$currency_name}',
                `currency_image` = '{$currency_image}',
                `min_daily_reward` = '{$min_reward}',
                `max_daily_reward` = '{$max_reward}',
                `image_filename` = 'christmas_tree.png',
                `start_date` = '{$start_date}',
                `end_date` = '{$end_date}'");
            $_SESSION['message'] = 'Событие успешно создано.';
            header('Location: /panel/event/');
            exit;
        }
    }
    
    // Форма создания события
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название События:<br/><input type="text" name="name" required><br/></font>';
    echo '<font color="#ffffff">Название Валюты (напр., Снежинка):<br/><input type="text" name="currency_name" value="Снежинка" required><br/></font>';
    echo '<font color="#ffffff">Иконка Валюты (имя файла, напр., snowflake):<br/><input type="text" name="currency_image" value="snowflake" required><br/></font>';
    echo '<font color="#ffffff">Мин. награда (ежедневно):<br/><input type="number" name="min_reward" value="5" required><br/></font>';
    echo '<font color="#ffffff">Макс. награда (ежедневно):<br/><input type="number" name="max_reward" value="15" required><br/></font>';
    echo '<font color="#ffffff">Дата начала (YYYY-MM-DD HH:MM:SS):<br/><input type="text" name="start_date" placeholder="2025-12-01 00:00:00" required><br/></font>';
    echo '<font color="#ffffff">Дата конца (YYYY-MM-DD HH:MM:SS):<br/><input type="text" name="end_date" placeholder="2026-01-31 23:59:59" required><br/></font>';
    
    echo '<input type="submit" name="add" value="Создать"></form></center>';
    echo '<a class="btn" href="/panel/event/"><img src="/images/icons/back.png"> Назад</a>';
    break;

case 'edit':
    $id = fl($_GET['id']);
    $event_item = $base->query("SELECT * FROM `event` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    if (!$event_item) { header('Location: /panel/event/'); exit; }

    if (isset($_POST['update_settings'])) {
        $name = fl($_POST['name']);
        $is_active = fl($_POST['is_active']);
        $currency_name = fl($_POST['currency_name']);
        $currency_image = fl($_POST['currency_image']);
        $min_reward = fl($_POST['min_reward']);
        $max_reward = fl($_POST['max_reward']);
        $start_date = strtotime(fl($_POST['start_date']));
        $end_date = strtotime(fl($_POST['end_date'])); 
        
        if (empty($name) || empty($currency_name) || empty($currency_image) || empty($start_date) || empty($end_date)) {
            error('Заполните все поля, включая даты.');
        } elseif ($start_date >= $end_date) {
             error('Дата начала должна быть раньше даты окончания.');
        } else {
            // Если активируем событие, деактивируем все остальные
            if ($is_active == 'yes') {
                $base->query("UPDATE `event` SET `is_active` = 'no' WHERE `id` != '{$id}'");
            }

            $base->query("UPDATE `event` SET 
                `name` = '{$name}',
                `is_active` = '{$is_active}',
                `currency_name` = '{$currency_name}',
                `currency_image` = '{$currency_image}',
                `min_daily_reward` = '{$min_reward}',
                `max_daily_reward` = '{$max_reward}',
                `start_date` = '{$start_date}',
                `end_date` = '{$end_date}'
                WHERE `id` = '{$id}' LIMIT 1");
            $_SESSION['message'] = 'Настройки события обновлены.';
            header('Location: /panel/event/edit/'.$id);
            exit;
        }
    }
    
    echo '<div class="title">Редактирование: '.$event_item['name'].'</div>';
    echo '<div class="event_table">';
    echo '<form action="" method="POST">';
    
    echo '<font color="#ffffff">Название События:<br/><input type="text" name="name" value="'.$event_item['name'].'" required><br/></font>';
    
    echo '<font color="#ffffff">Активность:<br/>';
    $is_active_current = $event_item['is_active'];
    echo '<select name="is_active">';
    echo '<option value="yes" '.($is_active_current == 'yes' ? 'selected' : '').'>Активировать (Станет главным)</option>';
    echo '<option value="no" '.($is_active_current == 'no' ? 'selected' : '').'>Деактивировать</option>';
    echo '</select><br/></font>';

    echo '<font color="#ffffff">Название Валюты:<br/><input type="text" name="currency_name" value="'.$event_item['currency_name'].'" required><br/></font>';
    echo '<font color="#ffffff">Иконка Валюты (имя файла):<br/><input type="text" name="currency_image" value="'.$event_item['currency_image'].'" required><br/></font>';
    echo '<font color="#ffffff">Мин. награда (ежедневно):<br/><input type="number" name="min_reward" value="'.$event_item['min_daily_reward'].'" required><br/></font>';
    echo '<font color="#ffffff">Макс. награда (ежедневно):<br/><input type="number" name="max_reward" value="'.$event_item['max_daily_reward'].'" required><br/></font>';
    echo '<font color="#ffffff">Дата начала (YYYY-MM-DD HH:MM:SS):<br/><input type="text" name="start_date" value="'.date('Y-m-d H:i:s', $event_item['start_date']).'" required><br/></font>';
    echo '<font color="#ffffff">Дата конца (YYYY-MM-DD HH:MM:SS):<br/><input type="text" name="end_date" value="'.date('Y-m-d H:i:s', $event_item['end_date']).'" required><br/></font>';
    
    echo '<input type="submit" name="update_settings" value="Сохранить настройки">';
    echo '</form>';
    echo '</div>';
    
    echo '<div class="line"></div>';
    echo '<a class="btn" href="/panel/event/shop/'.$id.'"><img src="/images/icons/shop.png"> Управление Магазином События</a>';
    echo '<a class="btn" href="/panel/event/"><img src="/images/icons/back.png"> Назад к списку</a>';

    break;

case 'shop':
    $event_id = fl($_GET['event_id']);
    $event_item = $base->query("SELECT * FROM `event` WHERE `id` = '{$event_id}' LIMIT 1")->fetch_assoc();
    if (!$event_item) { header('Location: /panel/event/'); exit; }

    echo '<div class="title">Магазин События: '.$event_item['name'].'</div>';
    
    $shop_q = $base->query("SELECT es.*, i.name as item_name FROM `event_shop` es 
                            JOIN `items` i ON es.item_id = i.id
                            WHERE es.event_id = '{$event_id}'
                            ORDER BY es.cost ASC");
    
    echo '<div class="event_table">';
    echo '<table class="a_table a_table-common" width="100%">';
    echo '<tr><td>ID</td><td>Предмет</td><td>Кол-во</td><td>Цена</td><td>Действие</td></tr>';
    while($item = $shop_q->fetch_assoc()) {
        echo '<tr>';
        echo '<td>'.$item['id'].'</td>';
        echo '<td>'.$item['item_name'].'</td>';
        echo '<td>'.$item['amount'].'</td>';
        echo '<td>'.n_f($item['cost']).'</td>';
        echo '<td><a class="btn_mini" href="/panel/event/shop/delete/'.$item['id'].'" onclick="return confirm(\'Удалить товар?\')"><img src="/images/icons/no.png"></a></td>';
        echo '</tr>';
    }
    echo '</table></div>';
    
    echo '<br/><a class="btn" href="/panel/event/shop/add/'.$event_id.'"><img src="/images/icons/admin.png"> Добавить товар</a>';
    echo '<a class="btn" href="/panel/event/edit/'.$event_id.'"><img src="/images/icons/back.png"> Назад к настройкам</a>';
    break;

case 'shop/add':
    $event_id = fl($_GET['event_id']);
    $event_item = $base->query("SELECT * FROM `event` WHERE `id` = '{$event_id}' LIMIT 1")->fetch_assoc();
    if (!$event_item) { header('Location: /panel/event/'); exit; }

    echo '<div class="title">Добавить Товар в Магазин для '.$event_item['name'].'</div>';
    if (isset($_POST['add_item'])) {
        $item_id = fl($_POST['item_id']);
        $cost = fl($_POST['cost']);
        $amount = fl($_POST['amount']);
        
        $item_check = $base->query("SELECT id FROM `items` WHERE `id` = '{$item_id}' LIMIT 1")->num_rows;
        
        if ($item_check == 0) {
            error('Предмет с таким ID не найден в базе `items`.');
        } elseif (empty($cost) || empty($amount)) {
            error('Заполните цену и количество.');
        } else {
            $base->query("INSERT INTO `event_shop` SET 
                `event_id` = '{$event_id}', 
                `item_id` = '{$item_id}', 
                `amount` = '{$amount}', 
                `cost` = '{$cost}'");
            $_SESSION['message'] = 'Товар успешно добавлен.';
            header('Location: /panel/event/shop/'.$event_id);
            exit;
        }
    }
    echo '<center><form method="POST">';
    echo 'ID Предмета (из таблицы `items`):<br/><input type="number" name="item_id" required><br/>';
    echo 'Цена в валюте события:<br/><input type="number" name="cost" required><br/>';
    echo 'Количество (сколько получит игрок):<br/><input type="number" name="amount" value="1" required><br/>';
    echo '<input type="submit" name="add_item" value="Добавить"></form></center>';
    echo '<a class="btn" href="/panel/event/shop/'.$event_id.'"><img src="/images/icons/back.png"> Назад</a>';
    break;

case 'shop/delete':
    $id = fl($_GET['id']);
    $item = $base->query("SELECT event_id FROM `event_shop` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    
    if ($item) {
        $event_id = $item['event_id'];
        $base->query("DELETE FROM `event_shop` WHERE `id` = '{$id}' LIMIT 1");
        $_SESSION['message'] = 'Товар удален.';
        header('Location: /panel/event/shop/'.$event_id);
    } else {
        header('Location: /panel/event/');
    }
    exit;
    break;
    
case 'delete':
    $id = fl($_GET['id']);
    // Добавить логику для удаления события и всех связанных товаров из event_shop
    $base->query("DELETE FROM `event` WHERE `id` = '{$id}' LIMIT 1");
    $base->query("DELETE FROM `event_shop` WHERE `event_id` = '{$id}'");
    $_SESSION['message'] = 'Событие и связанные товары удалены.';
    header('Location: /panel/event/');
    exit;
    break;

}

echo '<br/><a class="btn" href="/panel/"><img src="/images/icons/back.png"> Назад в Админ-панель</a>';

echo '</div>';
}else{
    header('Location: /panel/');
    exit;
}

include_once ('../core/foot.php');
?>