<?php
include_once ('../core/base.php');
$header = 'Управление Рыбалкой';
include_once ('../core/head.php'); 
falseauth();
adm();

// Получение списка редкостей для выпадающих списков
$rarities_q = $base->query("SELECT * FROM `rarities` ORDER BY `id` ASC");
if ($rarities_q) {
    $rarities = $rarities_q->fetch_all(MYSQLI_ASSOC);
} else {
    $rarities = [];
    // В реальной игре здесь лучше вызвать ошибку или перенаправить, если rarities не существует
}

if($u['admin'] == 3){

echo '<div class="b">';

switch($act){

default:
    echo '<div class="title">Управление Рыбалкой</div>';
    
    echo '<a class="btn" href="/panel/fishing/rods/"><img src="/images/icons/sword.png"> Удочки</a>';
    echo '<a class="btn" href="/panel/fishing/baits/"><img src="/images/icons/potion.png"> Наживки</a>';
    echo '<a class="btn" href="/panel/fishing/fish/"><img src="/images/icons/fish.png"> Рыба (Справочник)</a>';
    echo '<a class="btn" href="/panel/"><img src="/images/icons/back.png"> Назад</a>';
    break;

// ----------------------------------------------------------------------
// --- УДОЧКИ: СПИСОК / СОЗДАНИЕ / РЕДАКТИРОВАНИЕ / УДАЛЕНИЕ ---
// ----------------------------------------------------------------------

case 'rods':
    echo '<div class="title">Редактор Удочек</div>';
    $list_q = $base->query("SELECT fr.*, r.name_ru AS rarity_name FROM `fishing_rods` fr JOIN `rarities` r ON fr.rarity_id = r.id ORDER BY fr.rarity_id DESC");
    
    if ($list_q && $list_q->num_rows > 0) {
        while($item = $list_q->fetch_assoc()) {
             $item_display = get_item_color_by_rarity($item['rarity_id'], $item['name']);
             echo '<a class="btn" href="/panel/fishing/rods/edit/'.$item['id'].'/">' . $item_display . '</a>';
        }
    } else {
        echo '<div class="event"><center>Список удочек пуст.</center></div>';
    }
    echo '<br/><a class="btn" href="/panel/fishing/rods/new/">Добавить Удочку</a>';
    echo '<a class="btn" href="/panel/fishing/">Назад</a>';
    break;

case 'rods/new':
    echo '<div class="title">Новая Удочка</div>';
    
    if (isset($_POST['add'])) {
        $name = fl($_POST['name']);
        $rarity_id = fl($_POST['rarity_id']);
        $fishing_time_min = fl($_POST['fishing_time_min']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        $image = fl($_POST['image']);
        
        if (empty($name) || empty($rarity_id) || empty($fishing_time_min) || empty($price_amount) || empty($image)) {
            error('Заполните основные поля!');
        } else {
             // 1. Создаем удочку
             $base->query("INSERT INTO `fishing_rods` (`name`, `rarity_id`, `image`, `fishing_time_min`, `price_currency`, `price_amount`) VALUES (
                '{$name}', '{$rarity_id}', '{$image}', '{$fishing_time_min}', '{$price_currency}', '{$price_amount}')");
             $rod_id = $base->insert_id;
             
             // 2. Добавляем модификаторы шансов
             foreach ($rarities as $r) {
                 $modifier = isset($_POST['mod_'.$r['id']]) ? fl($_POST['mod_'.$r['id']]) : 0;
                 if ($modifier > 0) {
                     $base->query("INSERT INTO `fishing_chance_mods` (`type`, `item_id`, `rarity_id`, `modifier_percent`) VALUES (
                         'rod', '{$rod_id}', '{$r['id']}', '{$modifier}')");
                 }
             }

            $_SESSION['message'] = 'Удочка добавлена.';
            header('Location: /panel/fishing/rods/');
            exit;
        }
    }
    
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="rod.png" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        echo '<option value="'.$r['id'].'">'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Время ловли (мин.):<br/><input type="number" name="fishing_time_min" value="10" required><br/></font>';
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency"><option value="gold">Золото</option><option value="crystals">Кристаллы</option></select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" required><br/></font>';
    
    echo '<div class="title">Модификаторы шанса рыбы</div>';
    foreach ($rarities as $r) {
         echo '<font color="#ffffff">Доп. шанс ('.$r['name_ru'].', %):</font>';
         echo '<input type="number" name="mod_'.$r['id'].'" value="0" min="0" max="10000" style="width: 60px; display: inline-block;"> %<br/>';
    }
    
    echo '<input type="submit" name="add" value="Создать"></form></center>';
    echo '<a class="btn" href="/panel/fishing/rods/">Назад</a>';
    break;

case 'rods/edit':
    $id = fl($_GET['id']);
    $item = $base->query("SELECT * FROM `fishing_rods` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    if (!$item) { header('Location: /panel/fishing/rods/'); exit; }

    $mods_q = $base->query("SELECT rarity_id, modifier_percent FROM `fishing_chance_mods` WHERE `type` = 'rod' AND `item_id` = '{$id}'")->fetch_all(MYSQLI_ASSOC);
    $mods = array_column($mods_q, 'modifier_percent', 'rarity_id');

    if (isset($_POST['save'])) {
        $name = fl($_POST['name']);
        $rarity_id = fl($_POST['rarity_id']);
        $fishing_time_min = fl($_POST['fishing_time_min']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        $image = fl($_POST['image']);
        
        if (empty($name) || empty($rarity_id) || empty($fishing_time_min) || empty($price_amount) || empty($image)) {
            error('Заполните все поля!');
        } else {
             // 1. Обновляем удочку
             $base->query("UPDATE `fishing_rods` SET `name`='{$name}', `rarity_id`='{$rarity_id}', `image`='{$image}', `fishing_time_min`='{$fishing_time_min}', `price_currency`='{$price_currency}', `price_amount`='{$price_amount}' WHERE `id`='{$id}' LIMIT 1");
             
             // 2. Удаляем старые модификаторы и добавляем новые
             $base->query("DELETE FROM `fishing_chance_mods` WHERE `type`='rod' AND `item_id`='{$id}'");
             foreach ($rarities as $r) {
                 $modifier = isset($_POST['mod_'.$r['id']]) ? fl($_POST['mod_'.$r['id']]) : 0;
                 if ($modifier > 0) {
                     $base->query("INSERT INTO `fishing_chance_mods` (`type`, `item_id`, `rarity_id`, `modifier_percent`) VALUES (
                         'rod', '{$id}', '{$r['id']}', '{$modifier}')");
                 }
             }

            $_SESSION['message'] = 'Удочка обновлена.';
            header('Location: /panel/fishing/rods/');
            exit;
        }
    }

    echo '<div class="title">Редактирование Удочки: ' . $item['name'] . '</div>';
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" value="'.$item['name'].'" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="'.$item['image'].'" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        $selected = $r['id'] == $item['rarity_id'] ? 'selected' : '';
        echo '<option value="'.$r['id'].'" '.$selected.'>'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Время ловли (мин.):<br/><input type="number" name="fishing_time_min" value="'.$item['fishing_time_min'].'" required><br/></font>';
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency">';
    echo '<option value="gold" '.($item['price_currency'] == 'gold' ? 'selected' : '').'>Золото</option>';
    echo '<option value="crystals" '.($item['price_currency'] == 'crystals' ? 'selected' : '').'>Кристаллы</option>';
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" value="'.$item['price_amount'].'" required><br/></font>';
    
    echo '<div class="title">Модификаторы шанса рыбы</div>';
    foreach ($rarities as $r) {
         $current_mod = $mods[$r['id']] ?? 0;
         echo '<font color="#ffffff">Доп. шанс ('.$r['name_ru'].', %):</font>';
         echo '<input type="number" name="mod_'.$r['id'].'" value="'.$current_mod.'" min="0" max="10000" style="width: 60px; display: inline-block;"> %<br/>';
    }
    
    echo '<input type="submit" name="save" value="Сохранить"></form></center>';
    echo '<a class="btn" href="/panel/fishing/rods/">Назад</a>';
    break;

case 'rods/delete':
    $id = fl($_GET['id']);
    $base->query("DELETE FROM `fishing_rods` WHERE `id` = '{$id}' LIMIT 1");
    $base->query("DELETE FROM `fishing_chance_mods` WHERE `type` = 'rod' AND `item_id` = '{$id}'");
    $_SESSION['message'] = 'Удочка удалена.';
    header('Location: /panel/fishing/rods/');
    exit;
    break;


// ----------------------------------------------------------------------
// --- НАЖИВКИ: СПИСОК / СОЗДАНИЕ / РЕДАКТИРОВАНИЕ / УДАЛЕНИЕ ---
// ----------------------------------------------------------------------

case 'baits':
    echo '<div class="title">Редактор Наживок</div>';
    $list_q = $base->query("SELECT fb.*, r.name_ru AS rarity_name FROM `fishing_baits` fb JOIN `rarities` r ON fb.rarity_id = r.id ORDER BY fb.rarity_id DESC");
    
    if ($list_q && $list_q->num_rows > 0) {
        while($item = $list_q->fetch_assoc()) {
             $item_display = get_item_color_by_rarity($item['rarity_id'], $item['name']);
             echo '<a class="btn" href="/panel/fishing/baits/edit/'.$item['id'].'/">' . $item_display . '</a>';
        }
    } else {
        echo '<div class="event"><center>Список наживок пуст.</center></div>';
    }
    echo '<br/><a class="btn" href="/panel/fishing/baits/new/">Добавить Наживку</a>';
    echo '<a class="btn" href="/panel/fishing/">Назад</a>';
    break;

case 'baits/new':
    echo '<div class="title">Новая Наживка</div>';
    if (isset($_POST['add'])) {
        $name = fl($_POST['name']);
        $rarity_id = fl($_POST['rarity_id']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        $amount_in_pack = fl($_POST['amount_in_pack']);
        $image = fl($_POST['image']);

        if (empty($name) || empty($rarity_id) || empty($price_amount) || empty($image)) {
            error('Заполните основные поля!');
        } else {
             // 1. Создаем наживку
             $base->query("INSERT INTO `fishing_baits` (`name`, `rarity_id`, `image`, `price_currency`, `price_amount`, `amount_in_pack`) VALUES (
                '{$name}', '{$rarity_id}', '{$image}', '{$price_currency}', '{$price_amount}', '{$amount_in_pack}')");
             $bait_id = $base->insert_id;

             // 2. Добавляем модификаторы шансов
             foreach ($rarities as $r) {
                 $modifier = isset($_POST['mod_'.$r['id']]) ? fl($_POST['mod_'.$r['id']]) : 0;
                 if ($modifier > 0) {
                     $base->query("INSERT INTO `fishing_chance_mods` (`type`, `item_id`, `rarity_id`, `modifier_percent`) VALUES (
                         'bait', '{$bait_id}', '{$r['id']}', '{$modifier}')");
                 }
             }

            $_SESSION['message'] = 'Наживка добавлена.';
            header('Location: /panel/fishing/baits/');
            exit;
        }
    }
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="bait.png" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        echo '<option value="'.$r['id'].'">'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency"><option value="gold">Золото</option><option value="crystals">Кристаллы</option></select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" required><br/></font>';
    echo '<font color="#ffffff">Кол-во в наборе:<br/><input type="number" name="amount_in_pack" value="1" required><br/></font>';

    echo '<div class="title">Модификаторы шанса рыбы</div>';
    foreach ($rarities as $r) {
         echo '<font color="#ffffff">Доп. шанс ('.$r['name_ru'].', %):</font>';
         echo '<input type="number" name="mod_'.$r['id'].'" value="0" min="0" max="10000" style="width: 60px; display: inline-block;"> %<br/>';
    }

    echo '<input type="submit" name="add" value="Создать"></form></center>';
    echo '<a class="btn" href="/panel/fishing/baits/">Назад</a>';
    break;

case 'baits/edit':
    $id = fl($_GET['id']);
    $item = $base->query("SELECT * FROM `fishing_baits` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    if (!$item) { header('Location: /panel/fishing/baits/'); exit; }

    $mods_q = $base->query("SELECT rarity_id, modifier_percent FROM `fishing_chance_mods` WHERE `type` = 'bait' AND `item_id` = '{$id}'")->fetch_all(MYSQLI_ASSOC);
    $mods = array_column($mods_q, 'modifier_percent', 'rarity_id');

    if (isset($_POST['save'])) {
        $name = fl($_POST['name']);
        $rarity_id = fl($_POST['rarity_id']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        $amount_in_pack = fl($_POST['amount_in_pack']);
        $image = fl($_POST['image']);
        
        if (empty($name) || empty($rarity_id) || empty($price_amount) || empty($image)) {
            error('Заполните все поля!');
        } else {
             // 1. Обновляем наживку
             $base->query("UPDATE `fishing_baits` SET `name`='{$name}', `rarity_id`='{$rarity_id}', `image`='{$image}', `price_currency`='{$price_currency}', `price_amount`='{$price_amount}', `amount_in_pack`='{$amount_in_pack}' WHERE `id`='{$id}' LIMIT 1");
             
             // 2. Удаляем старые модификаторы и добавляем новые
             $base->query("DELETE FROM `fishing_chance_mods` WHERE `type`='bait' AND `item_id`='{$id}'");
             foreach ($rarities as $r) {
                 $modifier = isset($_POST['mod_'.$r['id']]) ? fl($_POST['mod_'.$r['id']]) : 0;
                 if ($modifier > 0) {
                     $base->query("INSERT INTO `fishing_chance_mods` (`type`, `item_id`, `rarity_id`, `modifier_percent`) VALUES (
                         'bait', '{$id}', '{$r['id']}', '{$modifier}')");
                 }
             }

            $_SESSION['message'] = 'Наживка обновлена.';
            header('Location: /panel/fishing/baits/');
            exit;
        }
    }

    echo '<div class="title">Редактирование Наживки: ' . $item['name'] . '</div>';
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" value="'.$item['name'].'" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="'.$item['image'].'" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        $selected = $r['id'] == $item['rarity_id'] ? 'selected' : '';
        echo '<option value="'.$r['id'].'" '.$selected.'>'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency">';
    echo '<option value="gold" '.($item['price_currency'] == 'gold' ? 'selected' : '').'>Золото</option>';
    echo '<option value="crystals" '.($item['price_currency'] == 'crystals' ? 'selected' : '').'>Кристаллы</option>';
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" value="'.$item['price_amount'].'" required><br/></font>';
    echo '<font color="#ffffff">Кол-во в наборе:<br/><input type="number" name="amount_in_pack" value="'.$item['amount_in_pack'].'" required><br/></font>';
    
    echo '<div class="title">Модификаторы шанса рыбы</div>';
    foreach ($rarities as $r) {
         $current_mod = $mods[$r['id']] ?? 0;
         echo '<font color="#ffffff">Доп. шанс ('.$r['name_ru'].', %):</font>';
         echo '<input type="number" name="mod_'.$r['id'].'" value="'.$current_mod.'" min="0" max="10000" style="width: 60px; display: inline-block;"> %<br/>';
    }
    
    echo '<input type="submit" name="save" value="Сохранить"></form></center>';
    echo '<a class="btn" href="/panel/fishing/baits/">Назад</a>';
    break;

case 'baits/delete':
    $id = fl($_GET['id']);
    $base->query("DELETE FROM `fishing_baits` WHERE `id` = '{$id}' LIMIT 1");
    $base->query("DELETE FROM `fishing_chance_mods` WHERE `type` = 'bait' AND `item_id` = '{$id}'");
    $_SESSION['message'] = 'Наживка удалена.';
    header('Location: /panel/fishing/baits/');
    exit;
    break;
    

// ----------------------------------------------------------------------
// --- РЫБА: СПИСОК / СОЗДАНИЕ / РЕДАКТИРОВАНИЕ / УДАЛЕНИЕ ---
// ----------------------------------------------------------------------

case 'fish':
    echo '<div class="title">Редактор Рыбы (Справочник)</div>';
    $list_q = $base->query("SELECT f.*, r.name_ru AS rarity_name FROM `fish` f JOIN `rarities` r ON f.rarity_id = r.id ORDER BY f.rarity_id DESC");
    
    if ($list_q && $list_q->num_rows > 0) {
        while($item = $list_q->fetch_assoc()) {
             $item_display = get_item_color_by_rarity($item['rarity_id'], $item['name']);
             echo '<a class="btn" href="/panel/fishing/fish/edit/'.$item['id'].'/">' . $item_display . '</a>';
        }
    } else {
        echo '<div class="event"><center>Список рыбы пуст.</center></div>';
    }
    echo '<br/><a class="btn" href="/panel/fishing/fish/new/">Добавить Рыбу</a>';
    echo '<a class="btn" href="/panel/fishing/">Назад</a>';
    break;

case 'fish/new':
    echo '<div class="title">Новая Рыба</div>';
    if (isset($_POST['add'])) {
        $name = fl($_POST['name']);
        $image = fl($_POST['image']);
        $rarity_id = fl($_POST['rarity_id']);
        $sell_price_silver = fl($_POST['sell_price_silver']);

        if (empty($name) || empty($image) || empty($rarity_id) || empty($sell_price_silver)) {
            error('Заполните все поля!');
        } else {
             $base->query("INSERT INTO `fish` (`name`, `image`, `rarity_id`, `sell_price_silver`) VALUES (
                '{$name}', '{$image}', '{$rarity_id}', '{$sell_price_silver}')");
            $_SESSION['message'] = 'Рыба добавлена.';
            header('Location: /panel/fishing/fish/');
            exit;
        }
    }
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="common_fish.png" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        echo '<option value="'.$r['id'].'">'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Стоимость продажи (серебро):<br/><input type="number" name="sell_price_silver" required><br/></font>';

    echo '<input type="submit" name="add" value="Создать"></form></center>';
    echo '<a class="btn" href="/panel/fishing/fish/">Назад</a>';
    break;
    
case 'fish/edit':
    $id = fl($_GET['id']);
    $item = $base->query("SELECT * FROM `fish` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    if (!$item) { header('Location: /panel/fishing/fish/'); exit; }

    if (isset($_POST['save'])) {
        $name = fl($_POST['name']);
        $image = fl($_POST['image']);
        $rarity_id = fl($_POST['rarity_id']);
        $sell_price_silver = fl($_POST['sell_price_silver']);

        if (empty($name) || empty($image) || empty($rarity_id) || empty($sell_price_silver)) {
            error('Заполните все поля!');
        } else {
             $base->query("UPDATE `fish` SET `name`='{$name}', `image`='{$image}', `rarity_id`='{$rarity_id}', `sell_price_silver`='{$sell_price_silver}' WHERE `id`='{$id}' LIMIT 1");
            $_SESSION['message'] = 'Рыба обновлена.';
            header('Location: /panel/fishing/fish/');
            exit;
        }
    }
    echo '<div class="title">Редактирование Рыбы: ' . $item['name'] . '</div>';
    echo '<center><form method="POST">';
    echo '<font color="#ffffff">Название:<br/><input type="text" name="name" value="'.$item['name'].'" required><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="'.$item['image'].'" required><br/></font>';
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        $selected = $r['id'] == $item['rarity_id'] ? 'selected' : '';
        echo '<option value="'.$r['id'].'" '.$selected.'>'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Стоимость продажи (серебро):<br/><input type="number" name="sell_price_silver" value="'.$item['sell_price_silver'].'" required><br/></font>';

    echo '<input type="submit" name="save" value="Сохранить"></form></center>';
    echo '<a class="btn" href="/panel/fishing/fish/">Назад</a>';
    break;

case 'fish/delete':
    $id = fl($_GET['id']);
    $base->query("DELETE FROM `fish` WHERE `id` = '{$id}' LIMIT 1");
    $_SESSION['message'] = 'Рыба удалена.';
    header('Location: /panel/fishing/fish/');
    exit;
    break;

}

echo '</div>';
} else {
    header('Location: /panel/');
    exit;
}

include_once ('../core/foot.php');
?>