<?php
include_once ('../core/base.php');
$header = 'Управление Питомцами';
include_once ('../core/head.php'); 
falseauth();
adm();

// Получение списка редкостей для выпадающих списков
$rarities_q = $base->query("SELECT * FROM `rarities` ORDER BY `id` ASC");
if ($rarities_q) {
    $rarities = $rarities_q->fetch_all(MYSQLI_ASSOC);
} else {
    $rarities = [];
    $_SESSION['message'] = 'Ошибка: Таблица rarities не найдена. Создайте ее, выполнив SQL-запросы.';
}

if($u['admin'] == 3){

echo '<div class="b">';

switch($act){

default:
    echo '<div class="title">Список Питомцев</div>';
    
    $pets_q = $base->query("SELECT p.*, r.name_ru AS rarity_name FROM `pets` p JOIN `rarities` r ON p.rarity_id = r.id ORDER BY p.rarity_id DESC");
    
    if ($pets_q && $pets_q->num_rows > 0) {
        while($item = $pets_q->fetch_assoc()) {
             $item_display = get_item_color_by_rarity($item['rarity_id'], $item['name']);
             echo '<a class="btn" href="/panel/pets/edit/'.$item['id'].'/">' . $item_display . '</a>';
        }
    } else {
        echo '<div class="event"><center>Список питомцев пуст.</center></div>';
    }
    echo '<br/><a class="btn" href="/panel/pets/new/"><img src="/images/icons/admin.png"> Добавить нового питомца</a>';
    echo '<a class="btn" href="/panel/"><img src="/images/icons/back.png"> Назад</a>';
    break;

// ----------------------------------------------------------------------
// --- СОЗДАНИЕ ПИТОМЦА (CREATE) ---
// ----------------------------------------------------------------------

case 'new':
    echo '<div class="title">Создание нового Питомца</div>';
    
    if (isset($_POST['add'])) {
        $name = fl($_POST['name']);
        $description = fl($_POST['description']);
        $rarity_id = fl($_POST['rarity_id']);
        $image = fl($_POST['image']);
        $p_att = fl($_POST['p_att']);
        $m_att = fl($_POST['m_att']);
        $p_def = fl($_POST['p_def']);
        $m_def = fl($_POST['m_def']);
        $endurance = fl($_POST['endurance']);
        $intellect = fl($_POST['intellect']);
        $agility = fl($_POST['agility']);
        $skill = fl($_POST['skill']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        
        if (empty($name) || empty($rarity_id) || empty($image) || empty($price_amount)) {
            error('Заполните все обязательные поля (Имя, Редкость, Картинка, Цена)!');
        } else {
             $base->query("INSERT INTO `pets` 
                (`name`, `description`, `rarity_id`, `image`, `price_currency`, `price_amount`, 
                 `p_att`, `m_att`, `p_def`, `m_def`, `endurance`, `intellect`, `agility`, `skill`) 
                VALUES (
                '{$name}', '{$description}', '{$rarity_id}', '{$image}', '{$price_currency}', '{$price_amount}', 
                '{$p_att}', '{$m_att}', '{$p_def}', '{$m_def}', '{$endurance}', '{$intellect}', '{$agility}', '{$skill}')");

            $_SESSION['message'] = 'Питомец успешно создан.';
            header('Location: /panel/pets/');
            exit;
        }
    }
    
    echo '<center><form method="POST">';
    
    echo '<div class="title">Основные параметры</div>';
    echo '<font color="#ffffff">Имя питомца:<br/><input type="text" name="name" required><br/></font>';
    echo '<font color="#ffffff">Описание:<br/><textarea name="description"></textarea><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла, mobs/pets/):<br/><input type="text" name="image" value="default.png" required><br/></font>';
    
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        echo '<option value="'.$r['id'].'">'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency"><option value="gold">Золото</option><option value="crystals">Кристаллы</option></select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" required><br/></font>';
    
    echo '<div class="title">Характеристики (Бонус)</div>';
    echo '<font color="#ffffff">Физ. Атака (p_att):<br/><input type="number" name="p_att" value="0"><br/></font>';
    echo '<font color="#ffffff">Маг. Атака (m_att):<br/><input type="number" name="m_att" value="0"><br/></font>';
    echo '<font color="#ffffff">Физ. Защита (p_def):<br/><input type="number" name="p_def" value="0"><br/></font>';
    echo '<font color="#ffffff">Маг. Защита (m_def):<br/><input type="number" name="m_def" value="0"><br/></font>';
    echo '<font color="#ffffff">Выносливость (endurance):<br/><input type="number" name="endurance" value="0"><br/></font>';
    echo '<font color="#ffffff">Интеллект (intellect):<br/><input type="number" name="intellect" value="0"><br/></font>';
    echo '<font color="#ffffff">Ловкость (agility):<br/><input type="number" name="agility" value="0"><br/></font>';
    echo '<font color="#ffffff">Мастерство (skill):<br/><input type="number" name="skill" value="0"><br/></font>';

    echo '<input type="submit" name="add" value="Создать питомца"></form></center>';
    echo '<a class="btn" href="/panel/pets/">Назад</a>';
    break;

// ----------------------------------------------------------------------
// --- РЕДАКТИРОВАНИЕ ПИТОМЦА (UPDATE) ---
// ----------------------------------------------------------------------

case 'edit':
    $id = fl($_GET['id']);
    $item = $base->query("SELECT * FROM `pets` WHERE `id` = '{$id}' LIMIT 1")->fetch_assoc();
    if (!$item) { header('Location: /panel/pets/'); exit; }

    if (isset($_POST['save'])) {
        $name = fl($_POST['name']);
        $description = fl($_POST['description']);
        $rarity_id = fl($_POST['rarity_id']);
        $image = fl($_POST['image']);
        $p_att = fl($_POST['p_att']);
        // ... (Получение всех остальных характеристик)
        $skill = fl($_POST['skill']);
        $price_currency = fl($_POST['price_currency']);
        $price_amount = fl($_POST['price_amount']);
        
        if (empty($name) || empty($rarity_id) || empty($image) || empty($price_amount)) {
            error('Заполните все обязательные поля!');
        } else {
             $base->query("UPDATE `pets` SET 
                `name`='{$name}', `description`='{$description}', `rarity_id`='{$rarity_id}', `image`='{$image}', 
                `price_currency`='{$price_currency}', `price_amount`='{$price_amount}', 
                `p_att`='{$p_att}', `m_att`='".fl($_POST['m_att'])."', `p_def`='".fl($_POST['p_def'])."', `m_def`='".fl($_POST['m_def'])."', 
                `endurance`='".fl($_POST['endurance'])."', `intellect`='".fl($_POST['intellect'])."', `agility`='".fl($_POST['agility'])."', `skill`='{$skill}'
                WHERE `id`='{$id}' LIMIT 1");
                
             // Важно: Обновляем также все существующие экземпляры этого питомца у пользователей!
             $base->query("UPDATE `users_items` SET 
                `name`='{$name}', `mark`='{$rarity_id}', `image`='{$image}',
                `p_att`='{$p_att}', `m_att`='".fl($_POST['m_att'])."', `p_def`='".fl($_POST['p_def'])."', `m_def`='".fl($_POST['m_def'])."', 
                `endurance`='".fl($_POST['endurance'])."', `intellect`='".fl($_POST['intellect'])."', `agility`='".fl($_POST['agility'])."', `skill`='{$skill}'
                WHERE `ident_id`='{$id}' AND `what`='pet'");

            $_SESSION['message'] = 'Питомец успешно обновлен.';
            header('Location: /panel/pets/');
            exit;
        }
    }

    echo '<div class="title">Редактирование: ' . $item['name'] . '</div>';
    echo '<center><form method="POST">';
    
    echo '<div class="title">Основные параметры</div>';
    echo '<font color="#ffffff">Имя питомца:<br/><input type="text" name="name" value="'.$item['name'].'" required><br/></font>';
    echo '<font color="#ffffff">Описание:<br/><textarea name="description">'.$item['description'].'</textarea><br/></font>';
    echo '<font color="#ffffff">Картинка (имя файла):<br/><input type="text" name="image" value="'.$item['image'].'" required><br/></font>';
    
    echo '<font color="#ffffff">Редкость:<br/><select name="rarity_id">';
    foreach ($rarities as $r) {
        $selected = $r['id'] == $item['rarity_id'] ? 'selected' : '';
        echo '<option value="'.$r['id'].'" '.$selected.'>'.$r['name_ru'].'</option>';
    }
    echo '</select><br/></font>';
    
    echo '<font color="#ffffff">Валюта:<br/><select name="price_currency">';
    echo '<option value="gold" '.($item['price_currency'] == 'gold' ? 'selected' : '').'>Золото</option>';
    echo '<option value="crystals" '.($item['price_currency'] == 'crystals' ? 'selected' : '').'>Кристаллы</option>';
    echo '</select><br/></font>';
    echo '<font color="#ffffff">Цена:<br/><input type="number" name="price_amount" value="'.$item['price_amount'].'" required><br/></font>';
    
    echo '<div class="title">Характеристики (Бонус)</div>';
    echo '<font color="#ffffff">Физ. Атака (p_att):<br/><input type="number" name="p_att" value="'.$item['p_att'].'"><br/></font>';
    echo '<font color="#ffffff">Маг. Атака (m_att):<br/><input type="number" name="m_att" value="'.$item['m_att'].'"><br/></font>';
    echo '<font color="#ffffff">Физ. Защита (p_def):<br/><input type="number" name="p_def" value="'.$item['p_def'].'"><br/></font>';
    echo '<font color="#ffffff">Маг. Защита (m_def):<br/><input type="number" name="m_def" value="'.$item['m_def'].'"><br/></font>';
    echo '<font color="#ffffff">Выносливость (endurance):<br/><input type="number" name="endurance" value="'.$item['endurance'].'"><br/></font>';
    echo '<font color="#ffffff">Интеллект (intellect):<br/><input type="number" name="intellect" value="'.$item['intellect'].'"><br/></font>';
    echo '<font color="#ffffff">Ловкость (agility):<br/><input type="number" name="agility" value="'.$item['agility'].'"><br/></font>';
    echo '<font color="#ffffff">Мастерство (skill):<br/><input type="number" name="skill" value="'.$item['skill'].'"><br/></font>';

    echo '<input type="submit" name="save" value="Сохранить изменения"></form></center>';
    echo '<a class="btn" href="/panel/pets/">Назад</a>';
    break;

// ----------------------------------------------------------------------
// --- УДАЛЕНИЕ ПИТОМЦА (DELETE) ---
// ----------------------------------------------------------------------

case 'delete':
    $id = fl($_GET['id']);
    
    // 1. Удаляем питомца из справочника
    $base->query("DELETE FROM `pets` WHERE `id` = '{$id}' LIMIT 1");
    
    // 2. Удаляем все экземпляры этого питомца из инвентаря пользователей
    $base->query("DELETE FROM `users_items` WHERE `ident_id` = '{$id}' AND `what` = 'pet'");
    
    // 3. Сбрасываем equipped_pet_id у пользователей, если он был активен
    $base->query("UPDATE `users` SET `equipped_pet_id` = '0' WHERE `equipped_pet_id` IN (SELECT id FROM `users_items` WHERE `ident_id` = '{$id}' AND `what` = 'pet')");

    $_SESSION['message'] = 'Питомец и все его копии у игроков успешно удалены.';
    header('Location: /panel/pets/');
    exit;
    break;

}

echo '</div>';
} else {
    header('Location: /panel/');
    exit;
}

include_once ('../core/foot.php');
?>