<?php
include_once ('./core/base.php');
falseauth();

$header = 'Питомцы';
include_once ('./core/head.php');

$action = fl($_GET['action']);
$pet_id = fl($_GET['id']);
$user_pet_id = fl($_GET['user_id']); // ID записи в users_items

echo '<div class="b"><div class="title">Питомцы</div>';

echo '<center>';
// --- КОРРЕКЦИЯ ОТОБРАЖЕНИЯ НАВИГАЦИИ ---
if ($action == 'my' || isset($_GET['take']) || isset($_GET['dismiss'])) {
    echo '<div class="btn_small_pressed">Мои питомцы</div>';
    echo '<a class="btn_small" href="/pets/">Магазин</a>';
} else {
    echo '<a class="btn_small" href="/pets/my/">Мои питомцы</a>';
    echo '<div class="btn_small_pressed">Магазин</div>';
}
echo '</center>';
echo '<div class="line"></div>';


// --------------------------------------------------
// --- РАЗДЕЛ "МАГАЗИН ПИТОМЦЕВ" (pets/) ---
// --------------------------------------------------
if ($action == 'default' || $action == '') {
    echo '<div class="title">Магазин Питомцев</div>';

    // Логика покупки
    if (isset($_GET['buy']) && $pet_id > 0) {
        $pet_data = $base->query("SELECT * FROM `pets` WHERE `id` = '{$pet_id}' LIMIT 1")->fetch_assoc();
        if ($pet_data) {
            $cost_currency = $pet_data['price_currency'];
            $cost_amount = $pet_data['price_amount'];

            if ($u[$cost_currency] >= $cost_amount) {
                
                // Снятие средств
                $base->query("UPDATE `users` SET `{$cost_currency}` = `{$cost_currency}` - '{$cost_amount}' WHERE `id` = '{$u['id']}' LIMIT 1");
                
                // Добавление в инвентарь (users_items) - КРИТИЧЕСКИЙ ФИКС: ВСЕ ПОЛЯ
                // Используем what='pet' и заполняем все технические поля для гарантии INSERT
                $base->query("INSERT INTO `users_items` 
                    (`user`, `ident_id`, `name`, `what`, `image`, `amount`, `mark`, `cost`, 
                     `p_att`, `m_att`, `p_def`, `m_def`, `endurance`, `intellect`, `agility`, `skill`, 
                     `is_active`, `level`, `type`, `attack_type`, `hp_regen`, `mp_regen`, `max_quality`, `smith`, `rune`, `set`, `potion`) 
                    VALUES (
                    '{$u['id']}', '{$pet_data['id']}', '{$pet_data['name']}', 'pet', '{$pet_data['image']}', 1, '{$pet_data['rarity_id']}', '{$pet_data['price_amount']}',
                    '{$pet_data['p_att']}', '{$pet_data['m_att']}', '{$pet_data['p_def']}', '{$pet_data['m_def']}', '{$pet_data['endurance']}', '{$pet_data['intellect']}', '{$pet_data['agility']}', '{$pet_data['skill']}', 
                    'no', '0', 'none', 'none', '0', '0', '0', '0', '0', '0', '0'
                )");
                
                $_SESSION['message'] = "Вы приобрели питомца {$pet_data['name']}!";
            } else {
                $_SESSION['message'] = 'Недостаточно средств.';
            }
        } else {
            $_SESSION['message'] = 'Питомец не найден.';
        }
        header('Location: /pets/');
        exit;
    }
    
    // Отображение магазина
    $shop_q = $base->query("SELECT p.*, r.name_ru, r.color_code FROM `pets` p JOIN `rarities` r ON p.rarity_id = r.id ORDER BY p.rarity_id DESC, p.price_amount ASC");
    if ($shop_q) {
        while($pet = $shop_q->fetch_assoc()) {
            $cost_currency = $pet['price_currency'];
            $cost_amount = $pet['price_amount'];
            $cost_color = $u[$cost_currency] >= $cost_amount ? '#E0E0E0' : 'ff5050';
            $color_code = get_rarity_color($pet['rarity_id']);

            echo '<div class="event_item">';
            echo '<table cellpadding="0" cellspacing="0" width="100%"><tr><td width="50%" valign="top">';
            
            echo '<img src="/images/mobs/pets/'.$pet['image'].'" width="48px" style="border: 1px solid '.$color_code.'; margin-right: 5px; vertical-align: middle;">';
            echo get_item_color_by_rarity($pet['rarity_id'], $pet['name']);
            
            echo '<br/>Цена: <img src="/images/icons/'.$cost_currency.'.png" width="12px"> <font color="'.$cost_color.'">'.n_f($pet['price_amount']).'</font>';

            echo '</td><td width="50%" align="right" valign="middle">';
            if ($u[$cost_currency] >= $cost_amount) {
                echo '<a class="btn_small" href="/pets/buy/'.$pet['id'].'/">Купить</a>';
            } else {
                echo '<div class="btn_small_pressed">Не хватает</div>';
            }
            echo '<a class="btn_mini" href="/pets/info/'.$pet['id'].'/">Характеристики</a>';
            echo '</td></tr></table></div>';
        }
    } else {
         echo '<div class="event"><center>Магазин временно недоступен.</center></div>';
    }
}


// --------------------------------------------------
// --- РАЗДЕЛ "МОИ ПИТОМЦЫ" (pets/my) ---
// --------------------------------------------------
elseif ($action == 'my' || $action == 'take' || $action == 'dismiss' || $action == 'info') {
    echo '<div class="title">Мои Питомцы</div>';
    
    // Логика "ВЗЯТЬ"
    if (isset($_GET['take']) && $user_pet_id > 0) {
        // 1. Деактивируем текущего питомца (если есть)
        if ($u['equipped_pet_id'] > 0) {
            $base->query("UPDATE `users_items` SET `is_active` = 'no' WHERE `id` = '{$u['equipped_pet_id']}' LIMIT 1");
        }
        
        // 2. Активируем нового питомца (КРИТИЧЕСКИЙ ФИКС: УДАЛЯЕМ ПРОВЕРКУ `what`, ПОЛАГАЯСЬ НА `ident_id IN (SELECT id FROM pets)`)
        $base->query("UPDATE `users_items` SET `is_active` = 'yes' WHERE `id` = '{$user_pet_id}' AND `user` = '{$u['id']}' AND `ident_id` IN (SELECT id FROM pets) LIMIT 1");
        
        // 3. Обновляем статус в users
        $base->query("UPDATE `users` SET `equipped_pet_id` = '{$user_pet_id}' WHERE `id` = '{$u['id']}' LIMIT 1");
        
        $_SESSION['message'] = 'Питомец успешно взят! Характеристики добавлены.';
        header('Location: /pets/my/');
        exit;
    }
    
    // Логика "ОТОЗВАТЬ"
    if (isset($_GET['dismiss']) && $user_pet_id > 0) {
        // Деактивируем питомца 
        $base->query("UPDATE `users_items` SET `is_active` = 'no' WHERE `id` = '{$user_pet_id}' AND `user` = '{$u['id']}' AND `ident_id` IN (SELECT id FROM pets) LIMIT 1");
        $base->query("UPDATE `users` SET `equipped_pet_id` = '0' WHERE `id` = '{$u['id']}' LIMIT 1");
        $_SESSION['message'] = 'Питомец отозван. Характеристики сняты.';
        header('Location: /pets/my/');
        exit;
    }

    // --- ОТОБРАЖЕНИЕ СПИСКА КУПЛЕННЫХ ПИТОМЦЕВ (КРИТИЧЕСКИ ИСПРАВЛЕНО) ---
    // Используем INNER JOIN, чтобы отображать только те записи инвентаря, чей ident_id есть в pets.
    // Это исключает Нож/Рубаху/Рыбу, если у них нет идентичного ID питомца.
    $my_pets_q = $base->query("SELECT ui.*, p.rarity_id, p.image AS pet_image FROM `users_items` ui INNER JOIN `pets` p ON ui.ident_id = p.id WHERE ui.user = '{$u['id']}' ORDER BY ui.is_active DESC, p.rarity_id DESC");
    
    if ($my_pets_q && $my_pets_q->num_rows > 0) {
        while ($pet = $my_pets_q->fetch_assoc()) {
            $color_code = get_rarity_color($pet['rarity_id']);
            $is_active = $pet['is_active'] == 'yes';

            echo '<div class="event_item">';
            echo '<table cellpadding="0" cellspacing="0" width="100%"><tr>';
            echo '<td width="70%">';
            echo '<img src="/images/mobs/pets/'.$pet['pet_image'].'" width="32px" style="border: 1px solid '.$color_code.'; margin-right: 5px; vertical-align: middle;">';
            echo get_item_color_by_rarity($pet['rarity_id'], $pet['name']);
            echo ($is_active ? ' <font color="lime">(ВЗЯТ)</font>' : '');
            
            echo '</td><td width="30%" align="right" valign="middle">';
            
            if ($is_active) {
                // Передаем ID записи из users_items
                echo '<a class="btn_mini" href="/pets/dismiss/'.$pet['id'].'/">Отозвать</a>';
            } else {
                // Передаем ID записи из users_items
                echo '<a class="btn_mini green" href="/pets/take/'.$pet['id'].'/">Взять</a>';
            }
            
            echo '</td></tr></table></div>';
        }
    } else {
        echo '<div class="event"><center>У вас пока нет питомцев. Загляните в магазин!</center></div>';
    }
}


// --------------------------------------------------
// --- РАЗДЕЛ "ИНФО О ХАРАКТЕРИСТИКАХ ПИТОМЦА" (pets/info) ---
// --------------------------------------------------
elseif ($action == 'info' && $pet_id > 0) {
    $pet = $base->query("SELECT p.*, r.name_ru AS rarity_name FROM `pets` p JOIN `rarities` r ON p.rarity_id = r.id WHERE p.id = '{$pet_id}' LIMIT 1")->fetch_assoc();
    if (!$pet) { header('Location: /pets/'); exit; }

    $color_code = get_rarity_color($pet['rarity_id']);

    echo '<div class="title">Характеристики: '.$pet['name'].'</div>';
    echo '<center><img src="/images/mobs/pets/'.$pet['image'].'" width="64px" style="border: 1px solid '.$color_code.';"></center>';
    echo '<div class="event"><center>'.nl2br($pet['description']).'</center></div>';

    echo '<div class="title">Бонусы к Характеристикам</div>';
    echo '<table class="table table-common" style="margin-top: 5px; border-collapse: collapse; text-align: left;">';
    echo '<tr><td><img src="/images/icons/p_att.png"> Физ. Атака</td><td><center>+'.n_f($pet['p_att']).'</center></td><td><img src="/images/icons/endurance.png"> Выносливость</td><td><center>+'.n_f($pet['endurance']).'</center></td></tr>';
    echo '<tr><td><img src="/images/icons/p_def.png"> Физ. Защита</td><td><center>+'.n_f($pet['p_def']).'</center></td><td><img src="/images/icons/intellect.png"> Интеллект</td><td><center>+'.n_f($pet['intellect']).'</center></td></tr>';
    echo '<tr><td><img src="/images/icons/m_att.png"> Маг. Атака</td><td><center>+'.n_f($pet['m_att']).'</center></td><td><img src="/images/icons/agility.png"> Ловкость</td><td><center>+'.n_f($pet['agility']).'</center></td></tr>';
    echo '<tr><td><img src="/images/icons/m_def.png"> Маг. Защита</td><td><center>+'.n_f($pet['m_def']).'</center></td><td><img src="/images/icons/skill.png"> Мастерство</td><td><center>+'.n_f($pet['skill']).'</center></td></tr>';
    echo '</table>';
    
    echo '<br/><a class="btn" href="/pets/"><img src="/images/icons/back.png"> Назад в Магазин</a>';
}

echo '</div>';

include_once ('./core/foot.php');
?>