// tower.php
<?php
include_once ('./core/base.php');
falseauth();

$header = 'Башня Героя';
include_once ('./core/head.php');

$action = fl($_GET['action']);

// --- Проверка и инициализация прогресса ---
// Для корректной работы требуется, чтобы в таблице `users` были поля:
// `tower_max_cleared_floor` (INT, default 0)
// `battle` (varchar)
// `pve.is_tower_fight` (varchar)

if (!isset($u['tower_max_cleared_floor'])) {
    $u['tower_max_cleared_floor'] = 0; 
}
$current_floor = $u['tower_max_cleared_floor'] + 1;

// --- Логика начала боя ---
if ($action == 'fight' && $u['battle'] == 'no') {
    $floor_to_fight = $current_floor;
    
    $floor = $base->query("SELECT * FROM `tower_floors` WHERE `floor_number`='{$floor_to_fight}' LIMIT 1")->fetch_assoc();
    
    if ($floor) {
        $mob = $base->query("SELECT * FROM `mobs` WHERE `id`='{$floor['mob_id']}' LIMIT 1")->fetch_assoc();
        
        if ($mob) {
            // Инициация PvE-боя
            $base->query('INSERT INTO `pve` SET
                `user` = "'.$u['id'].'",
                `mob` = "'.$mob['id'].'",
                `mob_hp` = "'.$mob['hp'].'",
                `mob_max_hp` = "'.$mob['hp'].'",
                `mob_time_attack` = "'.time().'",
                `is_tower_fight` = "yes"'); // Флаг для победной логики в pve.php
            
            $base->query('UPDATE `users` SET `battle` = "pve" WHERE `id` = "'.$u['id'].'" LIMIT 1');
            $_SESSION['message'] = $mob['name'].' с Этажа '.$floor_to_fight.' напал!';
            header('Location: /pve/');
            exit;
        } else {
            $_SESSION['message'] = 'Ошибка: моб для этого этажа не найден.';
        }
    } else {
        $_SESSION['message'] = 'Вы достигли вершины Башни Героя!';
    }
    header('Location: /tower/');
    exit;
}

// --- Логика получения награды ---
if ($action == 'claim' && fl($_GET['floor']) > 0) {
    $floor_to_claim = fl($_GET['floor']);
    
    $progress = $base->query("SELECT * FROM `users_tower_progress` WHERE `user_id`='{$u['id']}' AND `floor_number`='{$floor_to_claim}' AND `is_claimed`='no' AND `is_cleared`='yes' LIMIT 1")->fetch_assoc();
    $floor_data = $base->query("SELECT * FROM `tower_floors` WHERE `floor_number`='{$floor_to_claim}' LIMIT 1")->fetch_assoc();

    if ($progress && $floor_data) {
        
        // 1. Выдача награды (EXP, Silver, Gold)
        $base->query("UPDATE `users` SET 
            `exp` = `exp` + '{$floor_data['reward_exp']}', 
            `silver` = `silver` + '{$floor_data['reward_silver']}', 
            `gold` = `gold` + '{$floor_data['reward_gold']}' 
            WHERE `id` = '{$u['id']}' LIMIT 1");
            
        // 2. Выдача предмета (логика скопирована из battlepass.php)
        if ($floor_data['reward_item_id'] > 0) {
            $item_id = $floor_data['reward_item_id'];
            $item_amount = $floor_data['reward_item_amount'];
            $item_data = $base->query("SELECT * FROM `items` WHERE `id` = '{$item_id}' LIMIT 1")->fetch_assoc();
            
            if ($item_data) {
                if ($item_data['what'] == 'clothing') {
                    $base->query("INSERT INTO `users_items` (user, name, description, image, level, what, type, attack_type, p_att, m_att, p_def, m_def, endurance, intellect, agility, skill, max_quality, mark, cost, ident_id, amount) VALUES (
                        '{$u['id']}', '{$item_data['name']}', '{$item_data['description']}', '{$item_data['image']}', '{$item_data['level']}', '{$item_data['what']}', '{$item_data['type']}', '{$item_data['attack_type']}', '{$item_data['p_att']}', '{$item_data['m_att']}', '{$item_data['p_def']}', '{$item_data['m_def']}', '{$item_data['endurance']}', '{$item_data['intellect']}', '{$item_data['agility']}', '{$item_data['skill']}', '{$item_data['max_quality']}', '{$item_data['mark']}', '{$item_data['cost']}', '{$item_data['id']}', '{$item_amount}')");
                } else {
                    $old_item = $base->query("SELECT id FROM `users_items` WHERE `user` = '{$u['id']}' AND `ident_id` = '{$item_id}' LIMIT 1")->num_rows;
                    if ($old_item > 0) {
                        $base->query("UPDATE `users_items` SET `amount` = `amount` + '{$item_amount}' WHERE `user` = '{$u['id']}' AND `ident_id` = '{$item_id}' LIMIT 1");
                    } else {
                         // Создание новой записи для ресурса/зелья
                         $base->query("INSERT INTO `users_items` (user, name, image, what, potion, hp_regen, mp_regen, mark, cost, ident_id, amount) VALUES (
                             '{$u['id']}', '{$item_data['name']}', '{$item_data['image']}', '{$item_data['what']}', '{$item_data['potion']}', '{$item_data['hp_regen']}', '{$item_data['mp_regen']}', '{$item_data['mark']}', '{$item_data['cost']}', '{$item_data['id']}', '{$item_amount}')");
                    }
                }
            }
        }
        
        // 3. Отметка о получении награды
        $base->query("UPDATE `users_tower_progress` SET `is_claimed`='yes' WHERE `id`='{$progress['id']}' LIMIT 1");
        
        $_SESSION['message'] = 'Награда за Этаж '.$floor_to_claim.' получена! Этаж '.($floor_to_claim + 1).' разблокирован.';

    } else {
        $_SESSION['message'] = 'Этаж не пройден, или награда уже получена.';
    }
    header('Location: /tower/');
    exit;
}


// --- Отображение интерфейса ---
$floors_q = $base->query("SELECT * FROM `tower_floors` ORDER BY `floor_number` ASC");

echo '<div class="b"><div class="title">Башня Героя</div>';

echo '<center><div class="border"><img style="width: 100%; max-width: 336px;" src="/images/places/hell_tower.png"></div></center>';

echo '<div class="event"><center>Поднимайтесь по этажам, чтобы заработать ценные награды и показать свою силу!</center></div>';

echo '<table class="a_table a_table-common" width="100%">';
echo '<tr><td width="30%"><b>Этаж</b></td><td width="70%"><b>Награда / Статус</b></td></tr>';

if ($floors_q->num_rows > 0) {
    while ($floor = $floors_q->fetch_assoc()) {
        $floor_num = $floor['floor_number'];
        $is_cleared = $floor_num <= $u['tower_max_cleared_floor'];
        $is_unlocked = $floor_num <= $current_floor; // Доступен текущий и все предыдущие
        
        $progress = $base->query("SELECT id, is_claimed, is_cleared FROM `users_tower_progress` WHERE `user_id`='{$u['id']}' AND `floor_number`='{$floor_num}' LIMIT 1")->fetch_assoc();
        $is_claimed = $progress && $progress['is_claimed'] == 'yes';
        $is_passed = $progress && $progress['is_cleared'] == 'yes';

        $mob = $base->query("SELECT name, image FROM `mobs` WHERE id='{$floor['mob_id']}' LIMIT 1")->fetch_assoc();
        $mob_name = $mob ? $mob['name'] : 'Ошибка Моба';
        
        $reward_text = '';
        if ($floor['reward_exp'] > 0) $reward_text .= '<img src="/images/icons/exp.png" width="12px"> '.n_f($floor['reward_exp']).' ';
        if ($floor['reward_silver'] > 0) $reward_text .= '<img src="/images/icons/silver.png" width="12px"> '.n_f($floor['reward_silver']).' ';
        if ($floor['reward_gold'] > 0) $reward_text .= '<img src="/images/icons/gold.png" width="12px"> '.n_f($floor['reward_gold']).' ';
        if ($floor['reward_item_id'] > 0) {
            $item = $base->query("SELECT name FROM `items` WHERE id='{$floor['reward_item_id']}' LIMIT 1")->fetch_assoc();
            $reward_text .= '<img src="/images/icons/bag.png" width="12px"> x'.$floor['reward_item_amount'].' '.$item['name'];
        }

        echo '<tr>';
        
        // Колонка Этажа / Бой
        echo '<td>';
        if ($is_unlocked && !$is_passed) {
            // Доступно: начать бой (только для текущего этажа)
            $button_class = ($floor_num == $current_floor) ? 'btn_mini green' : 'btn_mini';
            echo '<a class="'.$button_class.'" href="/tower/fight/">Этаж '.$floor_num.'</a>';
        } elseif ($is_passed && !$is_claimed) {
            // Пройдено: получить награду
            echo '<div class="btn_mini_pressed" style="background-color: gold;">Пройдено</div>';
        } elseif ($is_claimed) {
            // Получено
            echo '<div class="btn_mini_pressed" style="background-color: lime;">Получено</div>';
        } else {
            // Недоступно
            echo '<div class="btn_mini" style="background-color: #404050;">Этаж '.$floor_num.' (🔒)</div>';
        }
        echo '</td>';

        // Колонка Награды / Статус
        echo '<td>';
        if ($is_unlocked) {
            echo '<small>Моб: '.$mob_name.'</small><br/>';
            echo $reward_text;
            
            if ($is_passed && !$is_claimed) {
                 echo ' <a class="btn_mini green" href="/tower/claim/'.$floor_num.'/">Получить!</a>';
            }
        } else {
            echo '<small>Моб: ???<br/>Награда: ???</small>';
        }
        echo '</td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="2"><center>Башня еще не настроена Администрацией.</center></td></tr>';
}

echo '</table>';

echo '<br/><a class="btn" href="/"><img src="/images/icons/back.png"> Назад</a>';
echo '</div>';

include_once ('./core/foot.php');
?>