<?php 
acms_header('Добавить баннер', 'users');

$type = abs(intval(get('type')));

if ($type >= 1 && $type <= 2) {
  
  get_check_valid();
  
  session('ba_type', $type);
  
  redirect('/m/banners/add/?get=start');
  
}

$name = tabs(session('ba_name'));
$message = tabs(session('ba_message'));
$domain = tabs(session('ba_domain'));
$link = tabs(session('ba_link'));
$color_name = tabs(session('ba_color_name'));
$color_message = tabs(session('ba_color_message'));
$color_domain = tabs(session('ba_color_domain'));
$type = abs(intval(session('ba_type')));

if (get('get') == 'end') {
  
  get_check_valid();
  
  $at = intval(db::get_column("SELECT `ID` FROM `ATTACHMENTS` WHERE `USER_ID` = ? AND `ACT` = ? AND `TYPE_POST` = ? AND `ID_POST` = ? LIMIT 1", [user('ID'), 1, 'banner_ads_'.$type, 0]));
  
  if ($at == 0) {
    
    error('Вы не загрузили баннер');
    redirect('/m/banners/add/?get=start');
  
  }
  
  if (get('save') == 'ok') {
    
    $ID = db::get_add("INSERT INTO `BANNER_ADS` (`DOMAIN`, `NAME`, `MESSAGE`, `USER_ID`, `TIME`, `ACT`, `LINK`, `COLOR_NAME`, `COLOR_MESSAGE`, `COLOR_DOMAIN`, `TYPE`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$domain, $name, $message, user('ID'), TM, 2, $link, $color_name, $color_message, $color_domain, $type]);
    
    $message = "Пользователь [b]".user::login_mini(user('ID'))."[/b] создал баннерную рекламу и ждет одобрения. [url=/admin/site/modules/?mod=banners]Список баннеров[/url].";
    
    $admin = db::get_string("SELECT `ID` FROM `USERS` WHERE `ACCESS` = '99' ORDER BY `ID` DESC LIMIT 1");
    messages::get(config('SYSTEM'), $admin['ID'], $message, 0);
    
    db::get_set("UPDATE `ATTACHMENTS` SET `ID_POST` = ? WHERE `USER_ID` = ? AND `TYPE_POST` = ? AND `ID_POST` = ? LIMIT 1", [$ID, user('ID'), 'banner_ads_'.$type, 0]);
  
    session('ba_name', null);
    session('ba_message', null);
    session('ba_domain', null);
    session('ba_link', null);
    session('ba_type', null);
    session('ba_color_name', null);
    session('ba_color_message', null);
    session('ba_color_domain', null);
  
    success('Баннер успешно создан');
    redirect('/m/banners/');
    
  }
  
  ?>
  <div class='list'>    
  <link rel="stylesheet" href="/services/bnrs/style.css?id=1" type="text/css" />
    
  <b><?=lg('Как будет выглядеть баннер')?>:</b><br /><br />
  
  <?php if ($type == 2) : ?>
  <a class='bnrs_2' ajax='no' target='_blank' href='<?=$link?>'>
  <span class='bnrs_2_name' style='color: <?=$color_name?>'><?=$name?></span>
  <span class='bnrs_2_message' style='color: <?=$color_message?>'><?=$message?></span>
  <span class='bnrs_2_domain' style='color: <?=$color_domain?>'><?=$domain?></span>
  <img src='/files/upload/bnrs/<?=(is_file(ROOT.'/files/upload/bnrs/'.$at.'.gif') ? null : 'source/')?><?=$at?>.gif'>
  </a>
  <?php endif ?>
    
  <?php if ($type == 1) : ?>
  <a class='bnrs_1' ajax='no' target='_blank' href='<?=$link?>'>
  <span class='bnrs_1_name' style='color: <?=$color_name?>'><?=$name?></span>
  <span class='bnrs_1_message' style='color: <?=$color_message?>'><?=$message?></span>
  <span class='bnrs_1_domain' style='color: <?=$color_domain?>'><?=$domain?></span>
  <img src='/files/upload/bnrs/<?=(is_file(ROOT.'/files/upload/bnrs/'.$at.'.gif') ? null : 'source/')?><?=$at?>.gif'>
  </a>
  <br /><br />
  <?php endif ?>
    
  <a href='/m/banners/add/?get=end&save=ok&<?=TOKEN_URL?>' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Создать')?></a>
  <a href='/m/banners/add/?get=start' class='button-o'><?=lg('К редактированию')?></a>
  </div>
  <?
  
  back('/m/banners/add/?get=start');
  acms_footer();
  
}

if ($type >= 1 && $type <= 2 && get('get') == 'start') {
  
  attachments_result();
  
  if (post('ok')){
  
    valid::create(array(
    
      'ADS_NAME' => ['name', 'text', [0, 20], 'Название', 0],
      'ADS_MESSAGE' => ['message', 'text', [0, 30], 'Описание', 0],
      'ADS_DOMAIN' => ['domain', 'text', [0, 20], 'Домен', 0],
      'ADS_COLOR_NAME' => ['color_name', 'number', [1, 9], 'Цвет названия'],
      'ADS_COLOR_MESSAGE' => ['color_message', 'number', [1, 9], 'Цвет описания'],
      'ADS_COLOR_DOMAIN' => ['color_domain', 'number', [1, 9], 'Цвет домена'],
      'ADS_LINK' => ['link', 'link', [1, 250], 'Ссылка']
  
    ));
  
    $color = array(
    
      1 => '#FFFFFF',
      2 => '#4CAF87',
      3 => '#F8A223',
      4 => '#FA5F54',    
      5 => '#2196F3',
      6 => '#B3905D',
      7 => '#C58FCE',
      8 => '#000000',
      9 => '#6F7C81'
  
    );
  
    $color_name = $color[ADS_COLOR_NAME];
    $color_message = $color[ADS_COLOR_MESSAGE];
    $color_domain = $color[ADS_COLOR_DOMAIN];
  
    if (ERROR_LOG == 1){
    
      redirect('/m/banners/add/?get=start');
    
    }
    
    if (db::get_column("SELECT COUNT(*) FROM `ATTACHMENTS` WHERE `USER_ID` = ? AND `ACT` = ? AND `TYPE_POST` = ? AND `ID_POST` = ? LIMIT 1", [user('ID'), 1, 'banner_ads_'.$type, 0]) == 0) {
      
      error('Вы не загрузили баннер');
      redirect('/m/banners/add/?get=start');
      
    }
  
    session('ba_name', ADS_NAME);
    session('ba_message', ADS_MESSAGE);
    session('ba_domain', ADS_DOMAIN);
    session('ba_link', ADS_LINK);
    session('ba_color_name', $color_name);
    session('ba_color_message', $color_message);
    session('ba_color_domain', $color_domain);

    redirect('/m/banners/add/?get=end&'.TOKEN_URL);
  
  }
  
  $color = array(
    
    '#FFFFFF' => 1,
    '#4CAF87' => 2,
    '#F8A223' => 3,
    '#FA5F54' => 4,    
    '#2196F3' => 5,
    '#B3905D' => 6,
    '#C58FCE' => 7,
    '#000000' => 8,
    '#6F7C81' => 9
  
  );
  
  if (isset($color[$color_name])) { $color_name = $color[$color_name]; }
  if (isset($color[$color_message])) { $color_message = $color[$color_message]; }
  if (isset($color[$color_domain])) { $color_domain = $color[$color_domain]; }

  ?>
  <div class='list'>
  <form class='ajax-form' action='/m/banners/add/?get=start'>
  <?=html::input('name', 'Имя баннера', null, null, $name, 'form-control-100', 'text', null, 'text-width', 'Имя используется в верхней части баннера. Не обязательно, от 0 до 20 символов')?>
  <?=html::select('color_name', array(
    1 => ['Белый', ($color_name == 1 ? "selected" : null)],
    2 => ['Зеленый', ($color_name == 2 ? "selected" : null)], 
    3 => ['Оранжевый', ($color_name == 3 ? "selected" : null)], 
    4 => ['Красный', ($color_name == 4 ? "selected" : null)], 
    5 => ['Синий', ($color_name == 5 ? "selected" : null)], 
    6 => ['Коричневый', ($color_name == 6 ? "selected" : null)], 
    7 => ['Фиолетовый', ($color_name == 7 ? "selected" : null)], 
    8 => ['Черный', ($color_name == 8 ? "selected" : null)], 
    9 => ['Серый', ($color_name == 9 ? "selected" : null)]
  ), 'Цвет имени баннера', 'form-control-100-modify-select', 'paint-brush')?>
  <?=html::input('message', 'Описание баннера', null, null, $message, 'form-control-100', 'text', null, 'text-width', 'Описание используется ниже имени более мелким шрифтом. Не обязательно, от 0 до 35 символов')?>
  <?=html::select('color_message', array(
    1 => ['Белый', ($color_message == 1 ? "selected" : null)],
    2 => ['Зеленый', ($color_message == 2 ? "selected" : null)], 
    3 => ['Оранжевый', ($color_message == 3 ? "selected" : null)], 
    4 => ['Красный', ($color_message == 4 ? "selected" : null)], 
    5 => ['Синий', ($color_message == 5 ? "selected" : null)], 
    6 => ['Коричневый', ($color_message == 6 ? "selected" : null)], 
    7 => ['Фиолетовый', ($color_message == 7 ? "selected" : null)], 
    8 => ['Черный', ($color_message == 8 ? "selected" : null)], 
    9 => ['Серый', ($color_message == 9 ? "selected" : null)]
  ), 'Цвет описания баннера', 'form-control-100-modify-select', 'paint-brush')?>    
  <?=html::input('domain', 'Домен проекта', null, null, $domain, 'form-control-100', 'text', null, 'text-width', 'Используется для показа адреса веб-проекта. Не обязательно, от 0 до 20 символов')?>
  <?=html::select('color_domain', array(
    1 => ['Белый', ($color_domain == 1 ? "selected" : null)],
    2 => ['Зеленый', ($color_domain == 2 ? "selected" : null)], 
    3 => ['Оранжевый', ($color_domain == 3 ? "selected" : null)], 
    4 => ['Красный', ($color_domain == 4 ? "selected" : null)], 
    5 => ['Синий', ($color_domain == 5 ? "selected" : null)], 
    6 => ['Коричневый', ($color_domain == 6 ? "selected" : null)], 
    7 => ['Фиолетовый', ($color_domain == 7 ? "selected" : null)], 
    8 => ['Черный', ($color_domain == 8 ? "selected" : null)], 
    9 => ['Серый', ($color_domain == 9 ? "selected" : null)]
  ), 'Цвет домена баннера', 'form-control-100-modify-select', 'paint-brush')?>
  <?=html::input('link', 'Ссылка на проект ('.lg('вместе с').' http/https)', null, null, $link, 'form-control-100', 'text', null, 'link', 'Посетители будут переходить по клику на баннер к вашему проекту')?>
    
  <div style='background-color: #E4F3FF; color: #577287; padding: 10px; border-radius: 10px; margin-bottom: 19px'>
  <b><?=($type == 1 ? lg('Загрузите баннер для правого блока веб версии (290x260)') : lg('Загрузите баннер для низа всех страниц (160x620)'))?>:</b><br /><br />
  <a ajax="no" id="modal_bottom_open_set" onclick="upload('/system/AJAX/php/banner_ads.php?type=<?=$type?>', 'attachments_upload')" class="btn-o"><?=icons('upload', 15, 'fa-fw')?> <?=lg('Загрузить')?></a><br />
  <div id='upload-banner'>
  <?php if (get('delete_banner')) : ?>
  <?php $banner = db::get_string("SELECT `ID` FROM `ATTACHMENTS` WHERE `ID` = ? AND `USER_ID` = ? AND `ACT` = ? AND `TYPE_POST` = ? LIMIT 1", [intval(get('delete_banner')), user('ID'), 1, 'banner_ads_'.$type]); ?>
  <?php if (isset($banner['ID'])) : ?>
  <?=get_check_valid()?>
  <?php db::get_set("DELETE FROM `ATTACHMENTS` WHERE `ID` = ? LIMIT 1", [$banner['ID']]); ?>
  <?php @unlink(ROOT.'/files/upload/bnrs/'.$banner['ID'].'.gif'); ?>
  <?php @unlink(ROOT.'/files/upload/bnrs/source/'.$banner['ID'].'.gif'); ?>
  <?php endif ?>
  <?php endif ?> 
  <?php $html_banner = null; ?>
  <?php $data = db::get_string_all("SELECT `ID` FROM `ATTACHMENTS` WHERE `ACT` = ? AND `USER_ID` = ? AND `TYPE_POST` = ? AND `ID_POST` = ? ORDER BY `TIME` DESC LIMIT 1", [1, user('ID'), 'banner_ads_'.$type, 0]); ?>
  <?php while ($list = $data->fetch()) : ?>
  <?php if (is_file(ROOT.'/files/upload/bnrs/'.$list['ID'].'.gif')) : ?>
  <?php $html_banner .= '
  <div class="attachments_files_type">
  <span class="attachments_delete" onclick="request(\'/m/banners/add/?get=start&delete_banner='.$list['ID'].'&'.TOKEN_URL.'\', \'#upload-banner\', \'1\')">'.icons('times', 12).'</span>
  <a ajax="no" href="/files/upload/bnrs/source/'.$list['ID'].'.gif">
  <img src="/files/upload/bnrs/'.$list['ID'].'.gif" style="max-width: 90%">
  </a>
  </div>';
  ?>
  <?php elseif (is_file(ROOT.'/files/upload/bnrs/source/'.$list['ID'].'.gif')) : ?>
  <?php $html_banner .= '
  <div class="attachments_files_type">
  <span class="attachments_delete" onclick="request(\'/m/banners/add/?get=start&delete_banner='.$list['ID'].'&'.TOKEN_URL.'\', \'#upload-banner\', \'1\')">'.icons('times', 12).'</span>
  <a ajax="no" href="/files/upload/bnrs/source/'.$list['ID'].'.gif">
  <img src="/files/upload/bnrs/source/'.$list['ID'].'.gif" style="max-width: 90%">
  </a>
  </div>';
  ?>
  <?php endif ?>
  <?php endwhile ?>    
  <?php if (str($html_banner) > 0) : ?>      
  <div class='upload-attachments-result'>
  <div class='attachments_files_type'><?=$html_banner?></div>
  </div>
  <?php else : ?>
  <br />
  <font color='red'><small><?=lg('В случае не соотвествия размерам, система автоматически нарежет баннер под требуемый рамер')?></small></font>
  <?php endif ?>
  </div></div>    
  <?=html::button('button ajax-button', 'ok', 'arrow-right', 'Далее')?>
  <a href='/m/banners/add/' class='button-o'><?=lg('Отмена')?></a>
  </form>
  </div>
  <?
    
  back('/m/banners/add/');
  acms_footer();
    
}

?>  
<div class='list-body'>
<div class='list-menu'><b><?=lg('Выберите тип баннера')?>:</b></div>
<div class='list-menu'>
<div style='background-color: #D3E9F3; width: 85px; padding: 40px; padding-left: 0px; padding-right: 0px; text-align: center; margin-bottom: 10px;'><?=icons('arrows-v', 25)?></div>
<small><?=lg('Размещается в правом блоке веб версии сайта (290x260)')?></small><br /><br />
<span class='info green'><?=money(config('BANNER_ADS_SUM_1'), 1)?> - 1 <?=lg('день')?></span><br /><br />
<a href='/m/banners/add/?type=1&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
<div class='list-menu'>
<div style='background-color: #D3E9F3; width: 150px; padding: 1px; text-align: center; margin-bottom: 10px;'><?=icons('arrows-h', 25)?></div>
<small><?=lg('Размещается внизу всех страниц сайта (160x620)')?></small><br /><br />
<span class='info green'><?=money(config('BANNER_ADS_SUM_2'), 1)?> - 1 <?=lg('день')?></span><br /><br />
<a href='/m/banners/add/?type=2&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div> 
</div>
<?

back('/m/banners/');
acms_footer();