<?php
  
/*
----------------
Список активаций
----------------
*/

if (get('list')){
  
  $pc = db::get_string("SELECT `ID`,`CODE` FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [intval(get('list'))]);
  
  if (isset($pc['ID'])){
    
    $column = db::get_column("SELECT COUNT(*) FROM `PROMOCODES_USER` WHERE `CODE` = ?", [$pc['CODE']]);
    $spage = spage($column, PAGE_SETTINGS);
    $page = page($spage);
    $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
    
    ?>
    <div class='list-body'>
    <div class='list-menu'><font size='+1'><?=lg('Промокод')?> "<font color='#27BF91'><?=tabs($pc['CODE'])?></font>"</font></div>
    <?
      
    if ($column == 0){ 
      
      html::empty('Пока нет активаций');
    
    }
    
    $data = db::get_string_all("SELECT * FROM `PROMOCODES_USER` WHERE `CODE` = ? ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$pc['CODE']]);  
    while ($list = $data->fetch()){

      require (ROOT.'/modules/users/plugins/list-mini.php');
      echo $list_mini;
    
    }
    
    get_page('/admin/site/modules/?mod=promocodes&list='.$pc['ID'].'&', $spage, $page, 'list-menu');
    
    ?></div><?
    
    back('/admin/site/modules/?mod=promocodes');
    acms_footer();
    
  }
  
}
  
/*
--------------------
Добавление промокода
--------------------
*/
  
if (get('get') == 'add'){
  
  if (post('ok')){
    
    $count = abs(intval(post('count')));
    $code = esc(post('code'));
    $money = abs(post('money'));
    $rating = abs(post('rating'));
    $balls = abs(intval(post('balls')));
    
    if (db::get_column("SELECT COUNT(*) FROM `PROMOCODES` WHERE `CODE` = ? LIMIT 1", [$code]) > 0){
      
      error('Такой промокод уже есть');
      redirect('/admin/site/modules/?mod=promocodes&get=add');
    
    }
    
    db::get_add("INSERT INTO `PROMOCODES` (`MONEY`, `BALLS`, `RATING`, `CODE`, `COUNT`, `TIME`) VALUES (?, ?, ?, ?, ?, ?)", [$money, $balls, $rating, $code, $count, TM]);
    
    success('Промокод успешно добавлен');
    redirect('/admin/site/modules/?mod=promocodes');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=promocodes&get=add'>
  <?=html::input('money', 0, 'Сколько денег начислить после активации', null, null, 'form-control-30', 'number', null, 'money')?>
  <?=html::input('rating', 0, 'Сколько ед. рейтинга начислить после активации', null, null, 'form-control-30', 'number', null, 'bar-chart')?> 
  <?=html::input('balls', 0, 'Сколько баллов начислить после активации', null, null, 'form-control-30', 'number', null, 'plus')?>
  <?=html::input('count', 0, 'Кол-во активаций', null, null, 'form-control-30', 'number', null, 'sort-numeric-asc')?>
  <?=html::input('code', 'Промокод', 'Название промокода (например: PROMO или NewYear2022)', null, null, 'form-control-30', 'text', null, 'text-width')?>
  <?=html::button('button ajax-button', 'ok', 'plus', 'Создать промокод')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=promocodes');
  acms_footer();
  
}

/*
----------
Остановить
----------
*/

if (get('stop')){
  
  get_check_valid();
  
  $pc = db::get_string("SELECT `ID` FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [intval(get('stop'))]);
  
  if (isset($pc['ID'])){
  
    db::get_set("UPDATE `PROMOCODES` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [0, $pc['ID']]);
    
  }
  
}

/*
---------
Запустить
---------
*/

if (get('play')){
  
  get_check_valid();
  
  $pc = db::get_string("SELECT `ID` FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [intval(get('play'))]);
  
  if (isset($pc['ID'])){
  
    db::get_set("UPDATE `PROMOCODES` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $pc['ID']]);
    
  }
  
}
  
/*
------------------
Удаление промокода
------------------
*/

if (get('delete')){
  
  get_check_valid();
  
  $pc = db::get_string("SELECT `ID` FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  if (isset($pc['ID'])){
  
    db::get_set("DELETE FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [$pc['ID']]);
    
  }
  
}

/*
-------------------------
Редактирование промокодов
-------------------------
*/

if (get('edit')){
  
  $pc = db::get_string("SELECT * FROM `PROMOCODES` WHERE `ID` = ? LIMIT 1", [intval(get('edit'))]);
  
  if (!isset($pc['ID'])){
    
    error('Неизвестная ошибка');
    redirect('/admin/site/modules/?mod=promocodes');
    
  }
  
  if (post('ok')){
    
    $count = abs(intval(post('count')));
    $code = esc(post('code'));
    $money = abs(post('money'));
    $rating = abs(post('rating'));
    $balls = abs(intval(post('balls')));
    
    if ($code != $pc['CODE'] && db::get_column("SELECT COUNT(*) FROM `PROMOCODES` WHERE `CODE` = ? LIMIT 1", [$code]) > 0){
      
      error('Такой промокод уже есть');
      redirect('/admin/site/modules/?mod=promocodes&edit='.$pc['ID']);
    
    }
    
    db::get_set("UPDATE `PROMOCODES` SET `MONEY` = ?, `BALLS` = ?, `RATING` = ?, `CODE` = ?, `COUNT` = ? WHERE `ID` = ? LIMIT 1", [$money, $balls, $rating, $code, $count, $pc['ID']]);
    
    success('Изменения успешно приняты');
    redirect('/admin/site/modules/?mod=promocodes');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=promocodes&edit=<?=$pc['ID']?>'>
  <?=html::input('money', null, 'Сколько денег начислить после активации', null, $pc['MONEY'], 'form-control-30', 'number', null, 'money')?>
  <?=html::input('rating', null, 'Сколько ед. рейтинга начислить после активации', null, $pc['RATING'], 'form-control-30', 'number', null, 'bar-chart')?> 
  <?=html::input('balls', null, 'Сколько баллов начислить после активации', null, $pc['BALLS'], 'form-control-30', 'number', null, 'plus')?>
  <?=html::input('count', null, 'Кол-во активаций', null, $pc['COUNT'], 'form-control-30', 'number', null, 'sort-numeric-asc')?>
  <?=html::input('code', null, 'Название промокода (например: PROMO или NewYear2022)', null, $pc['CODE'], 'form-control-30', 'text', null, 'text-width')?>
  <?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=promocodes');
  acms_footer();
  
}

/*
-----------------
Список промокодов
-----------------
*/

?><div id='promo'><?
  
$column = db::get_column("SELECT COUNT(*) FROM `PROMOCODES`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
?>
<div class='list-body'>
    
<div class='list-menu'>
<a href='/admin/site/modules/?mod=promocodes&get=add' class='button'><?=icons('key', 15, 'fa-fw')?> <?=lg('Добавить промокод')?></a>
</div>    
<?
  
if ($column == 0){ 
  
  html::empty('Пока нет промокодов');

}
  
$data = db::get_string_all("SELECT * FROM `PROMOCODES` ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);  
while ($list = $data->fetch()){
  
  ?>
  <div class='list-menu'>
  <font size='+1'><?=lg('Промокод')?> "<font color='#27BF91'><?=tabs($list['CODE'])?></font>"</font><br /><br />    
  <?=lg('Создан')?>: <b><?=ftime($list['TIME'])?></b><br />  
  <?=lg('Денег')?>: <b><?=$list['MONEY']?></b><br />
  <?=lg('Баллов')?>: <b><?=$list['BALLS']?></b><br />
  <?=lg('Ед. рейтинга')?>: <b><?=$list['RATING']?></b><br />
  <?=lg('Осталось активаций')?>: <b><?=$list['COUNT']?></b> (<a href='/admin/site/modules/?mod=promocodes&list=<?=$list['ID']?>'><?=('список активаций')?></a>)
  <br /><br />
  <a href='/admin/site/modules/?mod=promocodes&edit=<?=$list['ID']?>' class='button3'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
  <?php if ($list['ACT'] == 1) { ?>
  <a href='/admin/site/modules/?mod=promocodes&stop=<?=$list['ID']?>&<?=TOKEN_URL?>' class='button'><?=icons('pause', 15, 'fa-fw')?> <?=lg('Остановить')?></a>
  <?php }else{ ?>
  <a href='/admin/site/modules/?mod=promocodes&play=<?=$list['ID']?>&<?=TOKEN_URL?>' class='button'><?=icons('play', 15, 'fa-fw')?> <?=lg('Запустить')?></a>
  <?php } ?>
  <button onclick="request('/admin/site/modules/?mod=promocodes&delete=<?=$list['ID']?>&<?=TOKEN_URL?>', '#promo')" class='button2'><?=icons('trash', 15, 'fa-fw')?></button> 
  </div>
  <?
  
}
  
get_page('/admin/site/modules/?mod=promocodes&', $spage, $page, 'list-menu');
  
?></div></div><?