<?php      
acms_header('Промокоды', 'users');

if (post('ok')){
  
  $code = esc(post('code'));
  $pc = db::get_string("SELECT * FROM `PROMOCODES` WHERE `CODE` = ? LIMIT 1", [$code]);
  
  if (!isset($pc['ID'])) {
    
    error('Неверный промокод');
    redirect('/account/promocodes/');
    
  }
  
  if ($pc['COUNT'] == 0) {
    
    error('Количество активаций для данного промокода исчерпано');
    redirect('/account/promocodes/');
    
  }
  
  if ($pc['ACT'] == 0) {
    
    error('Промокод не активен');
    redirect('/account/promocodes/');
    
  }
  
  if (db::get_column("SELECT COUNT(*) FROM `PROMOCODES_USER` WHERE `USER_ID` = ? AND `CODE` = ? LIMIT 1", [user('ID'), $code]) > 0){
    
    error('Вы уже активировали данный промокод раннее');
    redirect('/account/promocodes/');
    
  }
  
  db::get_add("INSERT INTO `PROMOCODES_USER` (`USER_ID`, `MONEY`, `BALLS`, `RATING`, `CODE`, `TIME`) VALUES (?, ?, ?, ?, ?, ?)", [user('ID'), $pc['MONEY'], $pc['BALLS'], $pc['RATING'], $pc['CODE'], TM]);
  db::get_set("UPDATE `PROMOCODES` SET `COUNT` = `COUNT` - ? WHERE `ID` = ? LIMIT 1", [1, $pc['ID']]);
  db::get_set("UPDATE `USERS` SET `MONEY` = `MONEY` + ?, `BALLS` = `BALLS` + ?, `RATING` = `RATING` + ? WHERE `ID` = ? LIMIT 1", [$pc['MONEY'], $pc['BALLS'], $pc['RATING'], user('ID')]);
  
  success('Поздравляем, промокод успешно активирован');
  redirect('/account/promocodes/');
  
}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/account/promocodes/'>
<?=html::input('code', 'Введите промокод', null, null, null, 'form-control-50', 'text', null, 'plus')?>
<?=html::button('button ajax-button', 'ok', 'plus', 'Активировать')?>
<form>
</div>
<?

$column = db::get_column("SELECT COUNT(`ID`) FROM `PROMOCODES_USER` WHERE `USER_ID` = ?", [user('ID')]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){
  
  html::empty();

}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `PROMOCODES_USER` WHERE `USER_ID` = ? ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [user('ID')]);
while ($list = $data->fetch()){
  
  ?>
  <div class='list-menu'>
  <font size='+1'><?=tabs($list['CODE'])?></font><br /><br />
  <?=lg('Денег')?>: <b>+<?=$list['MONEY']?></b><br />
  <?=lg('Баллов')?>: <b>+<?=$list['BALLS']?></b><br />
  <?=lg('Ед. рейтинга')?>: <b>+<?=$list['RATING']?></b><br />
  <span class='count'><?=ftime($list['TIME'])?></span>
  </div>
  <?

}

if ($column > 0){
  
  ?></div><?
  
}

get_page('/account/promocodes/?', $spage, $page);

back('/account/settings/');
acms_footer();