<?php
// admin/formats.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">📐 Управление форматами печати</h1>

    <div class="glass p-4 card-ui fade-in">
        <button class="btn btn-success mb-3" onclick="showAddForm()">➕ Добавить формат</button>

        <table class="table table-hover table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Название</th>
                    <th>Цена</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody id="formats-body">
                <?php
                $formats = $pdo->query("SELECT * FROM formats ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
                foreach ($formats as $f):
                ?>
                <tr id="format-<?= e($f['id']) ?>">
                    <td><?= e($f['id']) ?></td>
                    <td><?= e($f['name']) ?></td>
                    <td><?= e($f['price']) ?> ₽</td>
                    <td>
                        <button class="btn btn-sm btn-warning" onclick="editFormat(<?= $f['id'] ?>)">✏️ Изменить</button>
                        <button class="btn btn-sm btn-danger" onclick="deleteFormat(<?= $f['id'] ?>)">🗑️ Удалить</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Модальное окно для добавления/редактирования -->
<div class="modal" id="formatModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle">Добавить формат</h5>
        <button type="button" class="btn-close" onclick="closeModal()"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="formatId">
        <div class="mb-3">
            <label>Название</label>
            <input type="text" id="formatName" class="form-control">
        </div>
        <div class="mb-3">
            <label>Цена</label>
            <input type="number" id="formatPrice" class="form-control" min="0" step="0.01">
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" onclick="closeModal()">Отмена</button>
        <button class="btn btn-primary" onclick="saveFormat()">Сохранить</button>
      </div>
    </div>
  </div>
</div>

<script>
// Показ модального окна для добавления
function showAddForm(){
    document.getElementById('formatId').value = '';
    document.getElementById('formatName').value = '';
    document.getElementById('formatPrice').value = '';
    document.getElementById('modalTitle').innerText = 'Добавить формат';
    document.getElementById('formatModal').style.display = 'block';
}

// Закрыть модальное окно
function closeModal(){
    document.getElementById('formatModal').style.display = 'none';
}

// Редактирование формата
function editFormat(id){
    fetch('/ajax/admin/get_format.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            document.getElementById('formatId').value = data.format.id;
            document.getElementById('formatName').value = data.format.name;
            document.getElementById('formatPrice').value = data.format.price;
            document.getElementById('modalTitle').innerText = 'Редактировать формат';
            document.getElementById('formatModal').style.display = 'block';
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// Сохранение формата (добавить или обновить)
function saveFormat(){
    const id = document.getElementById('formatId').value;
    const name = document.getElementById('formatName').value;
    const price = document.getElementById('formatPrice').value;

    fetch('/ajax/admin/save_format.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, name:name, price:price, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            location.reload();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// Удаление формата
function deleteFormat(id){
    if(!confirm('Удалить этот формат?')) return;
    fetch('/ajax/admin/delete_format.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            document.getElementById('format-'+id).remove();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}
</script>

<?php require '../includes/footer.php'; ?>
