<?php
// admin/photos.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">🖼 Модерация загруженных фотографий</h1>

    <div class="row g-4">
        <?php
        $photos = $pdo->query("SELECT p.id, p.filename, u.email, p.created_at, p.status 
                               FROM photos p
                               JOIN users u ON p.user_id = u.id
                               ORDER BY p.created_at DESC")
                      ->fetchAll(PDO::FETCH_ASSOC);

        if (!$photos) {
            echo '<p>Фотографий нет.</p>';
        }

        foreach ($photos as $photo):
        ?>
        <div class="col-md-3">
            <div class="glass p-3 card-ui fade-in">
                <img src="/uploads/photos/<?= e($photo['filename']) ?>" class="img-fluid rounded mb-2" alt="Фото #<?= e($photo['id']) ?>">
                <p><strong>Пользователь:</strong> <?= e($photo['email']) ?></p>
                <p><strong>Дата:</strong> <?= e($photo['created_at']) ?></p>
                <p><strong>Статус:</strong> <span id="status-<?= $photo['id'] ?>"><?= e($photo['status']) ?></span></p>
                <div class="d-flex justify-content-between mt-2">
                    <button class="btn btn-sm btn-success" onclick="approvePhoto(<?= $photo['id'] ?>)">✅ Одобрить</button>
                    <button class="btn btn-sm btn-danger" onclick="deletePhoto(<?= $photo['id'] ?>)">🗑️ Удалить</button>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
// AJAX одобрения фото
function approvePhoto(photoId){
    fetch('/ajax/admin/approve_photo.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:photoId, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            document.getElementById('status-'+photoId).innerText = 'Одобрено';
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// AJAX удаления фото
function deletePhoto(photoId){
    if(!confirm('Удалить фото?')) return;
    fetch('/ajax/admin/delete_photo.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:photoId, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            location.reload();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}
</script>

<?php require '../includes/footer.php'; ?>
