<?php
require_once __DIR__ . '/../../config/bootstrap.php';
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/functions.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'error' => 'Доступ запрещён']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Неверный метод запроса']);
    exit;
}

$csrf_token = $_POST['csrf'] ?? $_POST['csrf_token'] ?? '';
if (empty($csrf_token) || !check_csrf($csrf_token)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

$user_id = (int)($_POST['id'] ?? 0);
$email = trim($_POST['email'] ?? '');
$name = trim($_POST['name'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$role = trim($_POST['role'] ?? 'user');
$password = $_POST['password'] ?? '';
$notifications = (int)($_POST['notifications'] ?? 1);

if ($user_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID пользователя']);
    exit;
}

if (empty($name)) {
    echo json_encode(['success' => false, 'error' => 'Поле "Имя" обязательно для заполнения']);
    exit;
}

if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'error' => 'Неверный формат email']);
    exit;
}

if (!in_array($role, ['user', 'admin'])) {
    echo json_encode(['success' => false, 'error' => 'Неверная роль пользователя']);
    exit;
}

$stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
$stmt->execute([$email, $user_id]);
if ($stmt->fetch()) {
    echo json_encode(['success' => false, 'error' => 'Email уже используется другим пользователем']);
    exit;
}

if (!empty($phone)) {
    $phone_clean = preg_replace('/\D/', '', $phone);
    
    if (strlen($phone_clean) < 10) {
        echo json_encode(['success' => false, 'error' => 'Номер телефона слишком короткий']);
        exit;
    }

    if (strlen($phone_clean) === 11 && (strpos($phone_clean, '7') === 0 || strpos($phone_clean, '8') === 0)) {
        $phone = '+7' . substr($phone_clean, 1);
    } elseif (strlen($phone_clean) === 10) {
        $phone = '+7' . $phone_clean;
    } else {
        $phone = '+' . $phone_clean;
    }
} else {
    $phone = null;
}

if (!empty($password) && strlen($password) < 6) {
    echo json_encode(['success' => false, 'error' => 'Пароль должен быть не менее 6 символов']);
    exit;
}

try {

    $updateFields = [
        'email = :email',
        'name = :name',
        'phone = :phone',
        'role = :role',
        'notifications = :notifications'
    ];
    
    $params = [
        'email' => $email,
        'name' => $name,
        'phone' => $phone,
        'role' => $role,
        'notifications' => $notifications,
        'id' => $user_id
    ];

    if (!empty($password)) {
        $updateFields[] = 'password = :password';
        $params['password'] = password_hash($password, PASSWORD_DEFAULT);
    }

    $sql = "UPDATE users SET " . implode(', ', $updateFields) . " WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $success = $stmt->execute($params);
    
    if ($success) {

        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

        error_log("Пользователь обновлён: ID={$user_id}, Админ=" . $_SESSION['user_id']);
        
        echo json_encode([
            'success' => true,
            'csrf_token' => $_SESSION['csrf_token']
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Ошибка при обновлении данных']);
    }
} catch (Exception $e) {
    error_log("Ошибка обновления пользователя: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Внутренняя ошибка сервера: ' . $e->getMessage()]);
}