<?php

require_once __DIR__ . '/../../config/bootstrap.php';
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/functions.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'error' => 'Доступ запрещён']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Неверный метод запроса']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    $input = $_POST;
}

$csrf_token = $input['csrf'] ?? '';
$order_id = (int)($input['id'] ?? 0);

if (empty($csrf_token) || !check_csrf($csrf_token)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

if ($order_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID заказа']);
    exit;
}

try {

    $pdo->beginTransaction();
    $stmt = $pdo->prepare("DELETE FROM order_items WHERE order_id = ?");
    $stmt->execute([$order_id]);
    $stmt = $pdo->prepare("DELETE FROM orders WHERE id = ?");
    $success = $stmt->execute([$order_id]);
    
    $pdo->commit();
    
    if ($success) {

        error_log("Заказ удалён: ID={$order_id}, Админ=" . $_SESSION['user_id']);
        
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Ошибка удаления заказа']);
    }
} catch (Exception $e) {
    $pdo->rollBack();
    error_log("Ошибка удаления заказа: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Внутренняя ошибка сервера: ' . $e->getMessage()]);
}
?>