<?php

require_once __DIR__ . '/../../config/bootstrap.php';
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/functions.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'error' => 'Доступ запрещён']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Неверный метод запроса']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    $input = $_POST;
}

$csrf_token = $input['csrf'] ?? '';
$order_id = (int)($input['id'] ?? 0);
$status = trim($input['status'] ?? '');

if (empty($csrf_token) || !check_csrf($csrf_token)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

if ($order_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID заказа']);
    exit;
}

$valid_statuses = ['Новый', 'В обработке', 'Печать', 'Доставляется', 'Доставлен', 'Отменен'];
if (!in_array($status, $valid_statuses)) {
    echo json_encode(['success' => false, 'error' => 'Неверный статус']);
    exit;
}

try {

    $stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?");
    $success = $stmt->execute([$status, $order_id]);
    
    if ($success) {

        error_log("Статус заказа обновлён: ID={$order_id}, Статус={$status}, Админ=" . $_SESSION['user_id']);

        $status_options = '';
        foreach ($valid_statuses as $valid_status) {
            $selected = $valid_status === $status ? 'selected' : '';
            $status_options .= '<option value="' . htmlspecialchars($valid_status) . '" ' . $selected . '>' . htmlspecialchars($valid_status) . '</option>';
        }
        
        echo json_encode([
            'success' => true,
            'status_options' => $status_options
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Ошибка обновления статуса']);
    }
} catch (Exception $e) {
    error_log("Ошибка обновления статуса заказа: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Внутренняя ошибка сервера: ' . $e->getMessage()]);
}
?>