<?php

session_start();
require '../config/bootstrap.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'error' => 'Необходимо войти в систему']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не поддерживается']);
    exit;
}

$csrf = $_POST['csrf'] ?? '';
$format_id = intval($_POST['format_id'] ?? 0);
$photo_id = intval($_POST['photo_id'] ?? 0);
$quantity = intval($_POST['quantity'] ?? 1);

error_log('=== CART ADD REQUEST ===');
error_log('CSRF received: ' . $csrf);
error_log('Format ID: ' . $format_id);
error_log('Photo ID: ' . $photo_id);
error_log('Quantity: ' . $quantity);
error_log('Session cart: ' . print_r($_SESSION['cart'] ?? [], true));

if (empty($csrf) || !check_csrf($csrf)) {
    echo json_encode([
        'success' => false, 
        'error' => 'Неверный CSRF токен',
        'debug' => [
            'received' => $csrf,
            'expected' => $_SESSION['csrf_token'] ?? 'none',
            'session_id' => session_id()
        ]
    ]);
    exit;
}

if ($format_id <= 0 || $quantity < 1) {
    echo json_encode(['success' => false, 'error' => 'Неверные данные']);
    exit;
}

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

try {
    global $pdo;
    $stmt = $pdo->prepare("SELECT id, name, price FROM formats WHERE id = ?");
    $stmt->execute([$format_id]);
    $format = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$format) {
        echo json_encode(['success' => false, 'error' => 'Формат не найден']);
        exit;
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Ошибка базы данных (формат): ' . $e->getMessage()]);
    exit;
}

$filename = '';
if ($photo_id > 0) {
    try {
        $stmt = $pdo->prepare("SELECT filename FROM photos WHERE id = ? AND user_id = ?");
        $stmt->execute([$photo_id, $_SESSION['user_id']]);
        $photo = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($photo && !empty($photo['filename'])) {
            $filename = $photo['filename'];
            error_log('Found photo filename: ' . $filename);
        } else {
            error_log('Photo not found or no filename for photo_id: ' . $photo_id);
        }
    } catch (PDOException $e) {
        error_log('Photo info error: ' . $e->getMessage());

    }
}

if ($photo_id > 0) {
    $item_key = 'format_' . $format_id . '_photo_' . $photo_id;
} else {
    $item_key = 'format_' . $format_id;
}

error_log('Generated item key: ' . $item_key);

if (isset($_SESSION['cart'][$item_key])) {

    $_SESSION['cart'][$item_key]['quantity'] += $quantity;
    error_log('Item exists, quantity increased to: ' . $_SESSION['cart'][$item_key]['quantity']);
} else {

    $_SESSION['cart'][$item_key] = [
        'format_id' => $format['id'],
        'format_name' => $format['name'],
        'price' => floatval($format['price']),
        'quantity' => $quantity,
        'photo_id' => $photo_id, // Сохраняем ID фото
        'filename' => $filename, // Сохраняем имя файла фото
        'added_at' => date('Y-m-d H:i:s')
    ];
    error_log('New item added to cart');
}

error_log('Cart after update: ' . print_r($_SESSION['cart'], true));

echo json_encode([
    'success' => true,
    'cart_count' => count($_SESSION['cart']),
    'cart_items' => $_SESSION['cart'],
    'message' => 'Товар добавлен в корзину',
    'item_added' => [
        'format_id' => $format['id'],
        'format_name' => $format['name'],
        'photo_id' => $photo_id,
        'filename' => $filename,
        'item_key' => $item_key
    ],
    'session_id' => session_id()
]);
?>