<?php
// ajax/cart_clear.php
session_start();
require '../config/bootstrap.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'error' => 'Необходимо войти в систему']);
    exit;
}

$csrf = $_POST['csrf'] ?? '';

// Временно отключаем проверку CSRF для тестирования
if (empty($csrf) || !check_csrf($csrf)) {
     echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
     exit;
}

$_SESSION['cart'] = [];

echo json_encode([
    'success' => true,
    'message' => 'Корзина очищена',
    'cart_count' => 0
]);
?>