// =========================
// admin.js – кастомный JS для админки
// =========================

document.addEventListener('DOMContentLoaded', () => {

    // =========================
    // Универсальная AJAX функция с CSRF
    // =========================
    const ajaxPost = async (url, data) => {
        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            return await response.json();
        } catch (err) {
            console.error('AJAX error:', err);
            return { success: false, error: 'Ошибка соединения с сервером' };
        }
    };

    // =========================
    // Уведомления
    // =========================
    const showAlert = (msg, type = 'success', timeout = 5000) => {
        const container = document.querySelector('#alert-container');
        if (!container) return;
        const alert = document.createElement('div');
        alert.className = `alert alert-${type} fade-in`;
        alert.textContent = msg;
        container.appendChild(alert);
        setTimeout(() => alert.remove(), timeout);
    };

    // =========================
    // Обновление статуса заказа
    // =========================
    document.querySelectorAll('.order-status-select').forEach(select => {
        select.addEventListener('change', async () => {
            const orderId = select.dataset.orderId;
            const status = select.value;
            const res = await ajaxPost('/ajax/admin/update_status.php', {
                order_id: orderId,
                status: status,
                csrf: window.CSRF_TOKEN
            });
            showAlert(res.success ? 'Статус заказа обновлён' : res.error, res.success ? 'success' : 'danger');
        });
    });

    // =========================
    // Одобрение / отклонение фото
    // =========================
    document.querySelectorAll('.btn-approve-photo, .btn-reject-photo').forEach(btn => {
        btn.addEventListener('click', async () => {
            const photoId = btn.dataset.photoId;
            const status = btn.classList.contains('btn-approve-photo') ? 'Одобрено' : 'Отклонено';
            const res = await ajaxPost('/ajax/admin/approve_photo.php', {
                photo_id: photoId,
                status: status,
                csrf: window.CSRF_TOKEN
            });
            if (res.success) {
                showAlert(res.message, 'success');
                const row = btn.closest('tr');
                if (row) row.querySelector('.photo-status').textContent = status;
            } else {
                showAlert(res.error || 'Ошибка обновления', 'danger');
            }
        });
    });

    // =========================
    // Массовая модерация / поиск пользователей (опционально)
    // =========================
    const userSearch = document.querySelector('#user-search');
    if (userSearch) {
        userSearch.addEventListener('input', () => {
            const filter = userSearch.value.toLowerCase();
            document.querySelectorAll('.user-row').forEach(row => {
                const name = row.dataset.username.toLowerCase();
                row.style.display = name.includes(filter) ? '' : 'none';
            });
        });
    }

    // =========================
    // Дашборд обновление (если используется)
    // =========================
    if (typeof loadDashboard === 'function') {
        loadDashboard(window.CSRF_TOKEN);
    }

});
