<?php

function register_user($name, $email, $password) {
    global $pdo;

    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->fetch()) {
        return ['success' => false, 'error' => 'Пользователь с таким email уже существует'];
    }

    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role, created_at) VALUES (:name, :email, :password, 'user', NOW())");
    $stmt->execute([
        'name' => $name,
        'email' => $email,
        'password' => $password_hash
    ]);

    return ['success' => true, 'user_id' => $pdo->lastInsertId()];
}

function login_user($email, $password) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if (!$user) {
        return ['success' => false, 'error' => 'Неверный email или пароль'];
    }

    if (!password_verify($password, $user['password'])) {
        return ['success' => false, 'error' => 'Неверный email или пароль'];
    }

    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_name'] = $user['name'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['user_role'] = $user['role'];

    return ['success' => true, 'user' => $user];
}

function logout_user() {
    session_unset();
    session_destroy();
}

function require_login() {
    if (!is_logged_in()) {
        redirect('/login.php');
    }
}

function require_admin() {
    if (!is_admin()) {
        redirect('/login.php');
    }
}
?>