<?php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

if (!defined('BASE_URL')) {
    define('BASE_URL', '/');
}

if (!defined('ASSETS_URL')) {
    define('ASSETS_URL', BASE_URL . 'assets/');
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PhotoPrint</title>

    <link rel="icon" href="<?= ASSETS_URL ?>images/logo.svg" type="image/svg+xml">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    <?php if (file_exists(__DIR__ . '/../assets/css/style.css')): ?>
        <link rel="stylesheet" href="<?= ASSETS_URL ?>css/style.css">
    <?php endif; ?>

    <script>
        window.CSRF_TOKEN = '<?= htmlspecialchars($_SESSION['csrf_token'] ?? '', ENT_QUOTES) ?>';
        window.BASE_URL = '<?= BASE_URL ?>';
        window.ASSETS_URL = '<?= ASSETS_URL ?>';
    </script>
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="<?= BASE_URL ?>">
                <?php if (file_exists(__DIR__ . '/../assets/images/logo.svg')): ?>
                    <img src="<?= ASSETS_URL ?>images/logo.svg" alt="PhotoPrint" width="40" class="me-2">
                <?php endif; ?>
                <span class="fw-bold">PhotoPrint</span>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar" aria-controls="mainNavbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="mainNavbar">
                <?php
                $is_logged_in = isset($_SESSION['user_id']);
                $is_admin = isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
                ?>
                
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item d-lg-none mobile-nav-item">
                        <a class="nav-link" href="<?= BASE_URL ?>">
                            <i class="bi bi-house-door"></i> Главная
                        </a>
                    </li>
                    
                    <?php if ($is_logged_in): ?>

                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>settings.php" title="Профиль">
                                <i class="bi bi-person-circle"></i>
                                <span class="nav-text">Профиль</span>
                            </a>
                        </li>
                        
                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>cart.php" title="Корзина">
                                <i class="bi bi-cart3"></i>
                                <span class="nav-text">Корзина</span>
                                <?php if (isset($_SESSION['cart_count']) && $_SESSION['cart_count'] > 0): ?>
                                    <span class="badge bg-danger badge-notification"><?= $_SESSION['cart_count'] ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        
                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>orders.php" title="Заказы">
                                <i class="bi bi-bag-check"></i>
                                <span class="nav-text">Заказы</span>
                            </a>
                        </li>
                        
                        <?php if ($is_admin): ?>
                            <li class="nav-item d-none d-lg-block">
                                <a class="nav-link nav-link-icon text-warning" href="<?= BASE_URL ?>admin/index.php" title="Админ панель">
                                    <i class="bi bi-speedometer2"></i>
                                    <span class="nav-text">Админ</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon text-danger" href="<?= BASE_URL ?>logout.php" title="Выйти">
                                <i class="bi bi-box-arrow-right"></i>
                                <span class="nav-text">Выйти</span>
                            </a>
                        </li>

                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>profile.php">
                                <i class="bi bi-person-circle"></i> Профиль
                            </a>
                        </li>
                        
                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>cart.php">
                                <i class="bi bi-cart3"></i> Корзина
                                <?php if (isset($_SESSION['cart_count']) && $_SESSION['cart_count'] > 0): ?>
                                    <span class="badge bg-danger ms-1"><?= $_SESSION['cart_count'] ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        
                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>orders.php">
                                <i class="bi bi-bag-check"></i> Мои заказы
                            </a>
                        </li>
                        
                        <?php if ($is_admin): ?>
                            <li class="nav-item d-lg-none mobile-nav-item">
                                <a class="nav-link text-warning" href="<?= BASE_URL ?>admin/index.php">
                                    <i class="bi bi-speedometer2"></i> Админ панель
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link text-danger" href="<?= BASE_URL ?>logout.php">
                                <i class="bi bi-box-arrow-right"></i> Выйти
                            </a>
                        </li>
                        
                    <?php else: ?>

                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>login.php" title="Войти">
                                <i class="bi bi-box-arrow-in-right"></i>
                                <span class="nav-text">Войти</span>
                            </a>
                        </li>
                        
                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>register.php" title="Регистрация">
                                <i class="bi bi-person-plus"></i>
                                <span class="nav-text">Регистрация</span>
                            </a>
                        </li>
                        
                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>login.php">
                                <i class="bi bi-box-arrow-in-right"></i> Войти
                            </a>
                        </li>
                        
                        <li class="nav-item d-lg-none mobile-nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>register.php">
                                <i class="bi bi-person-plus"></i> Регистрация
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="nav-item d-none d-lg-block">
                        <a class="nav-link nav-link-icon" href="<?= BASE_URL ?>" title="Главная">
                            <i class="bi bi-house-door"></i>
                            <span class="nav-text">Главная</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div id="alert-container" class="position-fixed top-0 end-0 p-3" style="z-index: 1050;"></div>

    <main class="container my-4">