<?php
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';

require_login();
?>

<nav id="sidebar" class="d-lg-block bg-light border-end vh-100 position-fixed shadow-sm" style="width: 220px;">
    <div class="sidebar-header p-3">
        <h5 class="fw-bold">Личный кабинет</h5>
        <small><?= e($_SESSION['user_name']) ?></small>
    </div>
    <ul class="nav flex-column p-2">
        <!-- Общие -->
        <li class="nav-item mb-1">
            <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>profile.php">
                <i class="bi bi-person-circle me-2"></i> Профиль
            </a>
        </li>
        <li class="nav-item mb-1">
            <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>orders.php">
                <i class="bi bi-bag-check me-2"></i> Мои заказы
            </a>
        </li>
        <li class="nav-item mb-1">
            <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>cart.php">
                <i class="bi bi-cart3 me-2"></i> Корзина
            </a>
        </li>

        <?php if (is_admin()): ?>
            <hr>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/index.php">
                    <i class="bi bi-speedometer2 me-2"></i> Дашборд
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/users.php">
                    <i class="bi bi-people me-2"></i> Пользователи
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/orders.php">
                    <i class="bi bi-bag me-2"></i> Заказы
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/photos.php">
                    <i class="bi bi-image me-2"></i> Фото
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/formats.php">
                    <i class="bi bi-card-text me-2"></i> Форматы
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/discounts.php">
                    <i class="bi bi-percent me-2"></i> Скидки
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/analytics.php">
                    <i class="bi bi-graph-up me-2"></i> Статистика
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link d-flex align-items-center" href="<?= BASE_URL ?>admin/notifications.php">
                    <i class="bi bi-envelope me-2"></i> Уведомления
                </a>
            </li>
        <?php endif; ?>
        <hr>
        <li class="nav-item">
            <a class="nav-link text-danger d-flex align-items-center" href="<?= BASE_URL ?>logout.php">
                <i class="bi bi-box-arrow-right me-2"></i> Выйти
            </a>
        </li>
    </ul>
</nav>

<div class="ms-lg-220">