<?php

require_once __DIR__ . '/config/bootstrap.php';

if (!isset($pdo)) {
    die('Ошибка: не удалось подключиться к базе данных');
}

try {

    $stmt = $pdo->query("SELECT * FROM formats ORDER BY id ASC");
    $formats = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $user_photos = [];
    if (is_logged_in()) {
        $stmt = $pdo->prepare("SELECT id, filename FROM photos WHERE user_id = ? ORDER BY uploaded_at DESC");
        $stmt->execute([$_SESSION['user_id']]);
        $user_photos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (PDOException $e) {
    die('Ошибка при получении данных из базы: ' . $e->getMessage());
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="container py-5">
    <div class="jumbotron text-center animate__animated animate__fadeInDown">
        <h1 class="display-4 fw-bold">PhotoPrint</h1>
        <p class="lead">Печать ваших фотографий в любых форматах с доставкой на дом</p>
        <?php if (!is_logged_in()): ?>
            <a href="<?= BASE_URL ?>register.php" class="btn btn-primary btn-lg me-2">Регистрация</a>
            <a href="<?= BASE_URL ?>login.php" class="btn btn-outline-primary btn-lg">Вход</a>
        <?php else: ?>
            <a href="<?= BASE_URL ?>upload.php" class="btn btn-primary btn-lg me-2">
                <i class="bi bi-cloud-upload"></i> Загрузить фото
            </a>
            <a href="<?= BASE_URL ?>profile.php" class="btn btn-outline-primary btn-lg me-2">
                <i class="bi bi-images"></i> Мои фото
            </a>
            <a href="<?= BASE_URL ?>cart.php" class="btn btn-warning btn-lg position-relative">
                <i class="bi bi-cart"></i> Корзина
                <?php if (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger cart-badge">
                        <?= count($_SESSION['cart']) ?>
                    </span>
                <?php endif; ?>
            </a>
        <?php endif; ?>
    </div>

    <?php if (is_logged_in()): ?>
        <div class="row mt-5 animate__animated animate__fadeInUp">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Ваши фото</h3>
                    <a href="<?= BASE_URL ?>upload.php" class="btn btn-sm btn-success">
                        <i class="bi bi-plus-circle"></i> Загрузить новое фото
                    </a>
                </div>
                
                <?php if (empty($user_photos)): ?>
                    <div class="alert alert-info text-center">
                        <i class="bi bi-info-circle fs-4"></i>
                        <p class="mb-0">У вас еще нет загруженных фото.</p>
                        <a href="<?= BASE_URL ?>upload.php" class="btn btn-primary mt-2">
                            <i class="bi bi-cloud-upload"></i> Загрузить первую фотографию
                        </a>
                    </div>
                <?php else: ?>
                    <div class="alert alert-success mb-3">
                        <i class="bi bi-lightbulb"></i> 
                        <strong>Инструкция:</strong> Выберите фото для печати, затем выберите формат ниже
                    </div>
                    
                    <div class="row g-3" id="photo-gallery">
                        <?php foreach ($user_photos as $photo): ?>
                            <?php
                            $photo_path = UPLOAD_DIR . 'photos/' . $photo['filename'];
                            $photo_url = BASE_URL . 'uploads/photos/' . $photo['filename'];
                            $has_photo_file = file_exists($photo_path);
                            ?>
                            <div class="col-md-3 col-sm-6">
                                <div class="card photo-select-card h-100" 
                                     data-photo-id="<?= e($photo['id']) ?>"
                                     style="cursor: pointer; transition: all 0.3s;">
                                    <div class="card-img-top position-relative" style="height: 180px; overflow: hidden;">
                                        <?php if ($has_photo_file): ?>
                                            <img src="<?= e($photo_url) ?>" 
                                                 class="w-100 h-100" 
                                                 alt="Фото"
                                                 style="object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-light w-100 h-100 d-flex align-items-center justify-content-center">
                                                <i class="bi bi-image text-muted fs-1"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div class="position-absolute top-0 end-0 m-2">
                                            <span class="badge bg-info">ID: <?= e($photo['id']) ?></span>
                                        </div>
                                    </div>
                                    <div class="card-body text-center">
                                        <button class="btn btn-sm <?= $has_photo_file ? 'btn-primary' : 'btn-secondary' ?> select-photo-btn w-100"
                                                data-photo-id="<?= e($photo['id']) ?>"
                                                data-photo-filename="<?= e($photo['filename']) ?>"
                                                <?= !$has_photo_file ? 'disabled' : '' ?>>
                                            <i class="bi bi-check-circle"></i>
                                            <?= $has_photo_file ? 'Выбрать это фото' : 'Файл отсутствует' ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="mt-3 text-center">
                        <small class="text-muted">
                            <i class="bi bi-info-circle"></i>
                            Выбрано фото: <span id="selected-photo-info" class="fw-bold">не выбрано</span>
                        </small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <h2 class="mt-5 mb-4 text-center fw-bold animate__animated animate__fadeInUp">
        <i class="bi bi-printer"></i> Доступные форматы печати
    </h2>
    
    <div class="row g-4">
        <?php if (empty($formats)): ?>
            <div class="col-12 text-center">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle fs-4"></i>
                    <p class="mb-1">Форматы печати временно недоступны</p>
                    <p class="mb-0 small">Проверьте, существует ли таблица <code>formats</code> в базе данных</p>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($formats as $format): ?>
                <div class="col-md-4">
                    <div class="card h-100 shadow-sm border-0 animate__animated animate__fadeInUp"
                         style="transition: transform 0.3s;">
                        <div class="card-body text-center d-flex flex-column">
                            <h5 class="card-title fw-bold"><?= e($format['name']) ?></h5>
                            <div class="mt-auto">
                                <p class="card-text fs-3 fw-bold text-primary">
                                    <?= number_format($format['price'], 2) ?> ₽
                                </p>
                                
                                <?php if (is_logged_in()): ?>
                                    <?php if (!empty($user_photos)): ?>
                                        <div class="mb-3">
                                            <small class="text-muted d-block">
                                                <i class="bi bi-info-circle"></i>
                                                Сначала выберите фото выше
                                            </small>
                                        </div>
                                        <button class="btn btn-success btn-lg w-100 add-to-cart" 
                                                data-format-id="<?= e($format['id']) ?>"
                                                data-format-name="<?= e($format['name']) ?>"
                                                data-price="<?= e($format['price']) ?>"
                                                disabled
                                                style="transition: all 0.3s;">
                                            <i class="bi bi-cart-plus"></i>
                                            <span class="btn-text">Выберите фото сначала</span>
                                        </button>
                                    <?php else: ?>
                                        <div class="alert alert-warning">
                                            <small class="d-block mb-2">
                                                <i class="bi bi-exclamation-circle"></i>
                                                У вас нет загруженных фото
                                            </small>
                                            <a href="<?= BASE_URL ?>upload.php" class="btn btn-sm btn-primary">
                                                <i class="bi bi-cloud-upload"></i> Загрузить фото
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <a href="<?= BASE_URL ?>login.php" class="btn btn-outline-primary btn-lg w-100">
                                        <i class="bi bi-box-arrow-in-right"></i> Войдите, чтобы заказать
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="row mt-5 animate__animated animate__fadeInUp">
        <div class="col-md-4 text-center">
            <div class="p-4 rounded-3 bg-light h-100">
                <i class="bi bi-upload fs-1 text-primary"></i>
                <h5 class="mt-3 fw-bold">Загрузите фотографии</h5>
                <p class="mb-0">Поддержка JPG, PNG и других популярных форматов</p>
            </div>
        </div>
        <div class="col-md-4 text-center">
            <div class="p-4 rounded-3 bg-light h-100">
                <i class="bi bi-cart-check fs-1 text-success"></i>
                <h5 class="mt-3 fw-bold">Выберите формат и параметры</h5>
                <p class="mb-0">Добавляйте фотографии в корзину и оформляйте заказ</p>
            </div>
        </div>
        <div class="col-md-4 text-center">
            <div class="p-4 rounded-3 bg-light h-100">
                <i class="bi bi-truck fs-1 text-warning"></i>
                <h5 class="mt-3 fw-bold">Получите заказ</h5>
                <p class="mb-0">Доставка прямо к вам домой или в офис</p>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Page loaded, CSRF Token:', window.CSRF_TOKEN);
    
    let selectedPhotoId = null;
    let selectedPhotoFilename = null;

    document.querySelectorAll('.select-photo-btn:not(:disabled)').forEach(btn => {
        btn.addEventListener('click', function() {
            selectedPhotoId = this.dataset.photoId;
            selectedPhotoFilename = this.dataset.photoFilename;
            
            console.log('Selected photo:', {
                id: selectedPhotoId,
                filename: selectedPhotoFilename
            });

            document.querySelectorAll('.photo-select-card').forEach(card => {
                card.classList.remove('border-primary', 'border-3', 'shadow');
                card.style.transform = 'scale(1)';
            });

            const selectedCard = this.closest('.photo-select-card');
            selectedCard.classList.add('border-primary', 'border-3', 'shadow');
            selectedCard.style.transform = 'scale(1.02)';
            const selectedPhotoInfo = document.querySelector('#selected-photo-info');
            if (selectedPhotoInfo) {
                selectedPhotoInfo.textContent = `ID: ${selectedPhotoId}`;
                selectedPhotoInfo.classList.add('text-success');
            }

            document.querySelectorAll('.add-to-cart').forEach(btn => {
                btn.disabled = false;
                const btnText = btn.querySelector('.btn-text');
                if (btnText) {
                    btnText.textContent = 'Добавить в корзину';
                }
                btn.classList.remove('btn-secondary');
                btn.classList.add('btn-success');
            });

            showAlert('Фото выбрано! Теперь выберите формат и нажмите "Добавить в корзину".', 'success');
        });
    });

    document.querySelectorAll('.add-to-cart').forEach(btn => {
        btn.addEventListener('click', function() {
            if (!selectedPhotoId) {
                showAlert('Сначала выберите фото из галереи выше', 'warning');
                return;
            }
            
            const formatId = this.dataset.formatId;
            const formatName = this.dataset.formatName;
            const price = this.dataset.price;
            
            console.log('Adding to cart:', { 
                photoId: selectedPhotoId, 
                photoFilename: selectedPhotoFilename,
                formatId: formatId,
                formatName: formatName,
                price: price 
            });

            const originalHtml = this.innerHTML;
            this.innerHTML = '<i class="bi bi-hourglass"></i> Добавление...';
            this.disabled = true;
            
            const formData = new FormData();
            formData.append('photo_id', selectedPhotoId);
            formData.append('format_id', formatId);
            formData.append('quantity', '1');
            formData.append('csrf', window.CSRF_TOKEN);
            
            fetch('<?= BASE_URL ?>ajax/cart_add.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Ошибка сети: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                console.log('Cart add response:', data);

                this.innerHTML = originalHtml;
                this.disabled = false;
                
                if (data.success) {
                    showAlert(
                        `<strong>${formatName}</strong> добавлен в корзину для выбранного фото!`, 
                        'success'
                    );

                    updateCartBadge(data.cart_count);

                    setTimeout(() => {
                        resetPhotoSelection();
                    }, 2000);

                    this.classList.add('animate__animated', 'animate__pulse', 'animate__fast');
                    setTimeout(() => {
                        this.classList.remove('animate__animated', 'animate__pulse', 'animate__fast');
                    }, 1000);
                } else {
                    showAlert('Ошибка: ' + (data.error || 'Не удалось добавить товар'), 'danger');
                }
            })
            .catch(error => {
                console.error('Fetch error:', error);
                this.innerHTML = originalHtml;
                this.disabled = false;
                showAlert('Ошибка сети: ' + error.message, 'danger');
            });
        });
    });

    if (document.querySelectorAll('.select-photo-btn').length > 0) {
        document.querySelectorAll('.add-to-cart').forEach(btn => {
            btn.disabled = true;
            const btnText = btn.querySelector('.btn-text');
            if (btnText) {
                btnText.textContent = 'Выберите фото сначала';
            }
        });
    }

    function showAlert(message, type = 'success') {
        const alertContainer = document.querySelector('#alert-container');
        if (!alertContainer) return;

        const oldAlerts = alertContainer.querySelectorAll('.alert');
        oldAlerts.forEach(alert => {
            alert.classList.remove('show');
            setTimeout(() => alert.remove(), 300);
        });
        
        const alert = document.createElement('div');
        alert.className = `alert alert-${type} alert-dismissible fade show animate__animated animate__fadeInDown`;
        alert.innerHTML = `
            <div class="d-flex align-items-center">
                <i class="bi ${type === 'success' ? 'bi-check-circle' : 'bi-exclamation-circle'} me-2 fs-5"></i>
                <div>${message}</div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        alertContainer.appendChild(alert);

        setTimeout(() => {
            if (alert.parentNode && alert.classList.contains('show')) {
                alert.classList.remove('show');
                setTimeout(() => alert.remove(), 300);
            }
        }, 5000);
    }
    
    function updateCartBadge(count) {
        let cartBadge = document.querySelector('.cart-badge');
        
        if (!cartBadge) {

            const cartBtn = document.querySelector('a[href*="cart.php"]');
            if (cartBtn) {
                cartBadge = document.createElement('span');
                cartBadge.className = 'position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger cart-badge';
                cartBadge.style.fontSize = '0.7rem';
                cartBtn.appendChild(cartBadge);
            }
        }
        
        if (cartBadge) {
            cartBadge.textContent = count;
            if (count > 0) {
                cartBadge.classList.remove('d-none');

                cartBadge.classList.add('animate__animated', 'animate__bounce');
                setTimeout(() => {
                    cartBadge.classList.remove('animate__animated', 'animate__bounce');
                }, 1000);
            } else {
                cartBadge.classList.add('d-none');
            }
        }
    }
    
    function resetPhotoSelection() {
        selectedPhotoId = null;
        selectedPhotoFilename = null;

        document.querySelectorAll('.photo-select-card').forEach(card => {
            card.classList.remove('border-primary', 'border-3', 'shadow');
            card.style.transform = 'scale(1)';
        });

        const selectedPhotoInfo = document.querySelector('#selected-photo-info');
        if (selectedPhotoInfo) {
            selectedPhotoInfo.textContent = 'не выбрано';
            selectedPhotoInfo.classList.remove('text-success');
        }

        document.querySelectorAll('.add-to-cart').forEach(btn => {
            btn.disabled = true;
            const btnText = btn.querySelector('.btn-text');
            if (btnText) {
                btnText.textContent = 'Выберите фото сначала';
            }
            btn.classList.remove('btn-success');
            btn.classList.add('btn-secondary');
        });
        
        showAlert('Выбор сброшен. Выберите другое фото если нужно.', 'info');
    }

    <?php if (isset($_SESSION['cart'])): ?>
        updateCartBadge(<?= count($_SESSION['cart']) ?>);
    <?php endif; ?>
});
</script>

<?php
require_once __DIR__ . '/includes/footer.php';
?>