<?php
session_start();

$width = 125;
$height = 50;
$image = imagecreatetruecolor($width, $height);
$bgColor = imagecolorallocate($image, 255, 82, 80);

imagefill($image, 0, 0, $bgColor);

$textColor = imagecolorallocate($image, 255, 226, 226);
$captchaCode = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890'), 0, 6);
$type = isset($_GET['type']) ? $_GET['type'] : 'auth';

switch($type) {
    case 'reg':
        $_SESSION['captcha_reg'] = $captchaCode;
        break;
    case 'lost':
        $_SESSION['captcha_lost'] = $captchaCode;
        break;
    case 'auth':
    default:
        $_SESSION['captcha_auth'] = $captchaCode;
        break;
}

imagettftext($image, 20, 0, 15, 35, $textColor, __DIR__ . '/css/fonts/arial.ttf', $captchaCode);

header('Content-Type: image/png');

imagepng($image);
imagedestroy($image);
?>