<?php
if (!defined('BASE_DIR')) { 
    exit(header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true)); 
}

class MySQL
{
    private static $instance;
    public $db_count = 0;
    public $db_link;
    
    private function __construct() 
    {    
        $this->db_link = new mysqli(BD_HOST, BD_USER, BD_PASS, BD_NAME, 3306);
        
        if($this->db_link->connect_error) {
            error_log("Database connection error: " . $this->db_link->connect_error);
            exit("Database connection failed");
        }
        
        $this->db_link->set_charset("utf8mb4");
    }
    
    public static function getInstance() 
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Безопасное выполнение запроса с параметрами
     */
    public function query($sql, $params = [], $types = '')
    {
        if (!empty($params)) {
            return $this->preparedQuery($sql, $params, $types);
        }
        
        // Логируем все SQL запросы в режиме разработки
        if (defined('DEBUG_MODE') && DEBUG_MODE) {
            error_log("SQL Query: " . $sql);
        }
        
        $query = $this->db_link->query($sql);
        
        if ($this->db_link->error) {
            error_log("MySQL Error: " . $this->db_link->error . " | Query: " . $sql);
            return false;
        }
        
        return $query;
    }
    
    /**
     * Подготовленные запросы для защиты от SQL-инъекций
     */
    private function preparedQuery($sql, $params, $types = '')
    {
        if (!$types) {
            $types = str_repeat('s', count($params));
        }
        
        $stmt = $this->db_link->prepare($sql);
        if (!$stmt) {
            error_log("Prepare failed: " . $this->db_link->error);
            return false;
        }
        
        $stmt->bind_param($types, ...$params);
        $result = $stmt->execute();
        
        if (!$result) {
            error_log("Execute failed: " . $stmt->error);
            $stmt->close();
            return false;
        }
        
        $result = $stmt->get_result();
        $stmt->close();
        
        return $result;
    }
    
    /**
     * Безопасная вставка
     */
    public function insert($table, $data)
    {
        $keys = array_keys($data);
        $fields = '`' . implode('`, `', $keys) . '`';
        $placeholders = str_repeat('?,', count($keys) - 1) . '?';
        $types = str_repeat('s', count($keys));
        
        $sql = "INSERT INTO `" . PREFIX . "_$table` ($fields) VALUES ($placeholders)";
        return $this->preparedQuery($sql, array_values($data), $types);
    }
    
    /**
     * Безопасное обновление
     */
    public function update($table, $data, $where, $where_params = [], $where_types = '')
    {
        $setParts = [];
        $params = [];
        $types = '';
        
        foreach ($data as $key => $value) {
            $setParts[] = "`$key` = ?";
            $params[] = $value;
            $types .= 's';
        }
        
        $sql = "UPDATE `" . PREFIX . "_$table` SET " . implode(', ', $setParts) . " WHERE $where";
        
        if (!empty($where_params)) {
            $params = array_merge($params, $where_params);
            $types .= $where_types;
        }
        
        return $this->preparedQuery($sql, $params, $types);
    }
    
    public function fetch_assoc($result)
    {
        return $result ? $result->fetch_assoc() : false;
    }
    
    public function fetch_assoc_all($result)
    {
        if (!$result) return [];
        
        $data = array();
        while($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        return $data;
    }        
    
    public function insert_id() 
    {
        return $this->db_link->insert_id;
    }
    
    public function num_rows($result)
    {
        return $result ? $result->num_rows : 0;
    }
    
    public function escape($string)
    {
        return $this->db_link->real_escape_string($string);
    }
    
    public function __destruct()
    {
        if ($this->db_link) {
            $this->db_link->close();
        }
    }
}
?>