<?php 
if (!defined('BASE_DIR')) { exit(header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true)); }

if (isset($_SESSION['user_id'])) 
{
  exit(header('Location: /account.php'));
}   

$obEngine->addTitleHtml('Сервис интернет рекламы');
?>

<div class="col-lg-8">
    <h5 class="page-title">Как начать зарабатывать?</h5>
    <div class="card mb-4">
        <div class="card-body">
            <p><?php echo $obEngine->getConfig('site_name'); ?> - это эффективный инструмент, который позволяет владельцам интернет-ресурсов с легкостью зарабатывать реальные деньги, не прикладывая к этому особых усилий и специальных знаний. Каждый день десятки заинтересованных рекламодателей будут использовать ваш сайт для размещения рекламы, а вы будете получать за это деньги.</p>
            <div class="text-center home_logo"><img src="img/advert.png" alt="Рекламный баннер" align="absmiddle"></div>
        </div>
    </div>
    <h5 class="page-title">Наши показатели</h5>
    <div class="card mb-4">
        <div class="card-body row">
            <div class="stat-block col">
                <div class="stat-img">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 480.28 480.28" style="enable-background:new 0 0 480.28 480.28;" xml:space="preserve" width="512px" height="512px">
<g>
    <g>
        <path d="M480.28,116.141v-16h-72c-4.418,0-8,3.582-8,8v13.792h-70.4c1.672-4.249,2.542-8.77,2.568-13.336V95.341    c0-4.418-3.582-8-8-8H211.096c-2.122,0-4.156,0.844-5.656,2.344l-32.24,32.24H80v-13.784c0-4.418-3.582-8-8-8H0v16h64v144H0v16h72    c4.418,0,8-3.582,8-8v-18.224h30.672l0.8,0.8l-12.128,12.136c-3.123,3.124-3.123,8.188,0,11.312L210.12,384.941    c3.124,3.123,8.188,3.123,11.312,0l12.968-12.984c11.911,6.959,27.02,4.985,36.744-4.8l78.872-78.872    c10.218-10.242,11.87-26.239,3.96-38.352H400v18.208c0,4.418,3.582,8,8,8h72v-16h-64l0.28-144H480.28z M215.776,367.973    l-16.744-16.744l17.6-17.6l-11.312-11.312l-17.6,17.6l-16-16l17.648-17.648l-11.312-11.312l-17.648,17.6l-16-16l17.696-17.696    l-11.312-11.312l-17.672,17.768l-16.84-16.8l33.6-33.6c5.701-5.682,14.923-5.682,20.624,0l78.872,78.88    c5.693,5.692,5.694,14.921,0.002,20.614c-0.001,0.001-0.002,0.002-0.002,0.002L215.776,367.973z M338.712,276.965l-78.88,78.872    c-3.469,3.464-8.448,4.949-13.248,3.952l14.072-14.048c11.94-11.928,11.95-31.278,0.022-43.218    c-0.007-0.007-0.014-0.014-0.022-0.022l-78.872-78.88c-11.952-11.919-31.296-11.919-43.248,0l-15.776,15.72l-3.12-3.112    c-1.5-1.5-3.534-2.344-5.656-2.344H80v-96l96.512,0.032c2.122,0,4.156-0.844,5.656-2.344l32.232-32.232h102.072v5.248    c-0.013,11.775-9.553,21.318-21.328,21.336h-40.04c-0.718-0.326-1.514-0.442-2.296-0.336c-2.122,0-4.156,0.844-5.656,2.344    l-63.688,63.68c-3.123,3.124-3.123,8.188,0,11.312l25.272,25.272c9.372,9.369,24.564,9.369,33.936,0l35.944-35.944l60.096,60.096    C344.393,262.047,344.393,271.267,338.712,276.965z M400.064,233.917h-61.152l-54.64-54.64c-3.124-3.123-8.188-3.123-11.312,0    l-41.6,41.6c-3.124,3.123-8.188,3.123-11.312,0l-19.616-19.616l55.352-55.344h39.36c8.285-0.035,16.317-2.852,22.808-8h82.296    L400.064,233.917z" fill="#FFFFFF"/>
    </g>
</g>
                        <g>
                            <g>
                                <path d="M234.344,390.485L216,408.829l-18.344-18.344l-11.312,11.312l24,24c3.124,3.123,8.188,3.123,11.312,0l24-24    L234.344,390.485z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <rect x="271.713" y="360.155" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -172.4593 319.957)" width="56.56" height="16" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M200,52.141c-2.122,0-4.156,0.844-5.656,2.344l-32,32l11.312,11.312l29.656-29.656H232v-16H200z" fill="#FFFFFF"/>
                            </g>
                        </g>
</svg>
                </div>
                <?php 
                $successWork = $obEngine->getConfig('success_work');
                $successCount = !empty($successWork) ? $successWork : 0;
                ?>
                <div class="stat-num"><?php echo $successCount; ?></div>
                <p><?php echo getWord($successCount, ['Успешная', 'Успешных', 'Успешных']); ?> <?php echo getWord($successCount, ['сделка', 'сделки', 'сделок']); ?></p>
            </div>

            <div class="stat-block col">
                <div class="stat-img">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px">
<g>
    <g>
        <path d="M358.4,55.467c-18.825,0-34.133,15.309-34.133,34.133v6.17l-199.441,79.77c-3.234,1.306-5.359,4.437-5.359,7.927v119.467    c0,3.49,2.125,6.622,5.359,7.919l199.441,79.77v6.178c0,18.825,15.309,34.133,34.133,34.133s34.133-15.309,34.133-34.133V89.6    C392.533,70.775,377.225,55.467,358.4,55.467z M375.467,396.8c0,9.412-7.654,17.067-17.067,17.067s-17.067-7.654-17.067-17.067    v-11.947c0-3.499-2.125-6.63-5.367-7.927l-199.433-79.77V189.244l199.433-79.77c3.243-1.306,5.367-4.437,5.367-7.927V89.6    c0-9.412,7.654-17.067,17.067-17.067s17.067,7.654,17.067,17.067V396.8z" fill="#FFFFFF"/>
    </g>
</g>
                        <g>
                            <g>
                                <path d="M128,174.933H68.267C30.626,174.933,0,205.559,0,243.2s30.626,68.267,68.267,68.267H128c4.71,0,8.533-3.814,8.533-8.533    V183.467C136.533,178.756,132.71,174.933,128,174.933z M119.467,294.4h-51.2c-28.237,0-51.2-22.963-51.2-51.2    S40.03,192,68.267,192h51.2V294.4z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M437.897,209.502l-51.2-17.067c-2.611-0.862-5.453-0.427-7.689,1.178c-2.227,1.604-3.541,4.181-3.541,6.921v85.333    c0,2.739,1.314,5.316,3.541,6.929c1.476,1.058,3.226,1.604,4.992,1.604c0.905,0,1.818-0.145,2.697-0.444l51.2-17.067    c3.49-1.152,5.837-4.412,5.837-8.09v-51.2C443.733,213.922,441.387,210.671,437.897,209.502z M426.667,262.647l-34.133,11.375    v-61.653l34.133,11.375V262.647z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M169.873,409.54l-8.567-8.576l-25.028-100.096c-0.947-3.797-4.361-6.468-8.277-6.468H59.733    c-2.611,0-5.069,1.195-6.69,3.226c-1.621,2.048-2.219,4.719-1.621,7.262l34.133,145.067c0.93,3.917,4.42,6.579,8.303,6.579    c0.538,0,1.075-0.051,1.621-0.162l64.085-12.373c0.085-0.017,0.171-0.034,0.256-0.051c3.755-0.845,7.185-2.722,9.916-5.41    c3.891-3.849,6.05-8.969,6.084-14.447C175.855,418.62,173.756,413.466,169.873,409.54z M157.747,426.385    c-0.435,0.435-0.981,0.734-1.579,0.887l-55.868,10.795l-29.79-126.601h50.825l23.996,95.932c0.375,1.502,1.152,2.876,2.244,3.968    l10.206,10.206c0.862,0.862,0.981,1.877,0.981,2.415C158.754,424.508,158.618,425.523,157.747,426.385z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <rect x="460.8" y="234.667" width="51.2" height="17.067" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>

                                <rect x="457.249" y="145.084" transform="matrix(0.8574 -0.5146 0.5146 0.8574 -10.3129 270.0117)" width="49.757" height="17.066" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>

                                <rect x="473.655" y="307.917" transform="matrix(0.5145 -0.8575 0.8575 0.5145 -51.2652 575.049)" width="17.067" height="49.758" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <rect x="324.267" y="98.133" width="17.067" height="290.133" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <rect x="85.333" y="209.067" width="17.067" height="34.133" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <rect x="51.2" y="209.067" width="17.067" height="34.133" fill="#FFFFFF"/>
                            </g>
                        </g>
</svg>
                </div>
                <?php 
                $advertLinks = $obEngine->getConfig('advert_links') ?: 0;
                $advertBanners = $obEngine->getConfig('advert_banners') ?: 0;
                $advertTotal = $advertLinks + $advertBanners;
                ?>
                <div class="stat-num"><?php echo $advertTotal; ?></div>
                <p><?php echo getWord($advertTotal, ['Рекламное', 'Рекламных', 'Рекламных']); ?> <?php echo getWord($advertTotal, ['место', 'места', 'мест']); ?></p>
            </div>

                        <div class="stat-block col">
                <div class="stat-img">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px">
<g>
    <g>
        <path d="M489.493,52.779h-70.009c6.693-5.213,11.011-13.339,11.011-22.46c0-15.693-12.768-28.462-28.462-28.462    c-15.694,0-28.462,12.768-28.462,28.462c0,4.795,1.196,9.312,3.299,13.28l-10.031,9.179H229.216    c-4.342-10.176-14.447-17.328-26.192-17.328c-11.745,0-21.849,7.151-26.192,17.328H22.508C10.097,52.779,0,62.876,0,75.286v55.409    c0,4.143,3.359,7.503,7.503,7.503c4.143,0,7.503-3.359,7.503-7.503V75.286c0-4.137,3.365-7.503,7.503-7.503h152.328    c0.395,2.874,1.21,5.615,2.398,8.152l-63.276,57.324c-4.471-2.927-9.809-4.637-15.541-4.637    c-15.693,0-28.462,12.768-28.462,28.462s12.768,28.462,28.462,28.462s28.462-12.768,28.462-28.462    c0-4.525-1.066-8.804-2.953-12.606l63.023-57.095c4.578,3.145,10.114,4.991,16.075,4.991c8.056,0,15.334-3.369,20.517-8.766    l51.093,30.346c-0.371,1.832-0.567,3.725-0.567,5.664c0,15.693,12.768,28.462,28.462,28.462s28.462-12.768,28.462-28.462    c0-4.083-0.87-7.964-2.426-11.478l44.103-40.357h116.824c4.137,0,7.503,3.365,7.503,7.503v185.389    c0,4.144,3.359,7.503,7.503,7.503c4.143,0,7.503-3.358,7.503-7.503V75.286C512,62.876,501.903,52.779,489.493,52.779z     M98.417,170.543c-7.42,0-13.457-6.036-13.457-13.456c0-7.421,6.037-13.457,13.457-13.457s13.457,6.036,13.457,13.457    C111.873,164.507,105.837,170.543,98.417,170.543z M203.024,77.369c-7.42,0-13.457-6.036-13.457-13.457    c0-7.42,6.037-13.457,13.457-13.457s13.457,6.036,13.457,13.457C216.481,71.333,210.444,77.369,203.024,77.369z M302.529,133.074    c-7.419,0-13.457-6.036-13.457-13.457c0-7.42,6.037-13.457,13.457-13.457s13.457,6.036,13.457,13.457    C315.985,127.038,309.948,133.074,302.529,133.074z M319.076,96.483c-4.667-3.348-10.379-5.327-16.548-5.327    c-8.36,0-15.887,3.623-21.099,9.381l-50.703-30.114c0.203-0.865,0.368-1.746,0.49-2.639h119.224L319.076,96.483z M402.032,43.776    c-7.419,0-13.457-6.036-13.457-13.457c0-7.421,6.037-13.457,13.457-13.457s13.457,6.036,13.457,13.457    C415.49,37.74,409.453,43.776,402.032,43.776z" fill="#FFFFFF"/>
    </g>
</g>
                        <g>
                            <g>
                                <path d="M512,290.686c0-4.144-3.359-7.503-7.503-7.503c-4.143,0-7.503,3.358-7.503,7.503v56.441h-55.239V169.4v-30.62v-31.044    c0-4.144-3.359-7.503-7.503-7.503h-56.44c-4.143,0-7.503,3.358-7.503,7.503v31.044v30.62v177.727h-28.06V308.93v-30.62v-31.044    c0-4.144-3.359-7.503-7.503-7.503h-56.44c-4.143,0-7.503,3.358-7.503,7.503v31.044v30.62v38.197h-28.059V212.085v-30.62v-31.043    c0-4.144-3.359-7.503-7.503-7.503h-56.44c-4.143,0-7.503,3.358-7.503,7.503v31.043v30.62v41.984c0,4.144,3.359,7.503,7.503,7.503    s7.503-3.358,7.503-7.503v-34.482h41.435v127.54h-41.435v-63.048c0-4.144-3.359-7.503-7.503-7.503s-7.503,3.358-7.503,7.503    v63.048h-28.059V308.93v-30.62v-31.044c0-4.144-3.359-7.503-7.503-7.503H79.301c-4.143,0-7.503,3.358-7.503,7.503v31.044v30.62    v38.197H15.005V160.705c0-4.144-3.359-7.503-7.503-7.503c-4.143,0-7.503,3.358-7.503,7.503v248.318    c0,12.41,10.096,22.508,22.508,22.508H186.83l-4.279,37.279h-35.621c-4.143,0-7.503,3.358-7.503,7.503v26.328    c0,4.144,3.359,7.503,7.503,7.503h218.143c4.143,0,7.503-3.358,7.503-7.503v-26.328c0-4.144-3.359-7.503-7.503-7.503h-35.621    l-4.279-37.279h164.322c12.411,0,22.508-10.097,22.508-22.508c0-0.049-0.006-54.201-0.007-54.249    c0.001-0.048,0.007-0.095,0.007-0.144V290.686z M385.317,115.238h41.435v16.038h-41.435V115.238z M385.317,146.282h41.435v15.615    h-41.435V146.282z M385.317,176.903h41.435v170.225h-41.435V176.903z M285.812,254.769h41.435v16.038h-41.435V254.769z     M285.812,285.813h41.435v15.615h-41.435V285.813z M285.812,316.433h41.435v30.694h-41.435V316.433z M186.307,173.961v-16.038    h41.435v16.038H186.307z M186.308,204.582v-15.615h41.435v15.615H186.308z M86.804,254.769h41.434v16.038H86.804V254.769z     M86.804,285.813h41.434v15.615H86.804V285.813z M86.804,316.433h41.434v30.694H86.804V316.433z M357.569,483.814v11.323H154.432    v-11.323H357.569z M197.654,468.809l4.279-37.279h108.133l4.279,37.279H197.654z M489.493,416.526H22.508    c-4.136,0-7.503-3.365-7.503-7.503V362.42h481.989v46.603h0.001C496.995,413.161,493.629,416.526,489.493,416.526z" fill="#FFFFFF"/>
                            </g>
                        </g>
</svg>
                </div>
                <div class="stat-num"><?php echo $obEngine->getConfig('show_advert_24'); ?></div>
                <p><?php echo getWord($obEngine->getConfig('show_advert_24'), ['Показ', 'Показа', 'Показов']); ?> в сутки</p>
            </div>

            <div class="stat-block col">
                <div class="stat-img">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px">
<g>
    <g>
        <path d="M437.02,74.981C388.667,26.628,324.38,0,256,0S123.333,26.628,74.98,74.981C26.629,123.333,0,187.62,0,256    s26.629,132.667,74.98,181.019C123.333,485.372,187.62,512,256,512s132.667-26.628,181.02-74.981    C485.371,388.667,512,324.38,512,256S485.371,123.333,437.02,74.981z M256,492C125.869,492,20,386.131,20,256S125.869,20,256,20    s236,105.869,236,236S386.131,492,256,492z" fill="#FFFFFF"/>
    </g>
</g>
                        <g>
                            <g>
                                <path d="M468.102,214.954c-13.48-70.045-60.708-128.831-126.339-157.253c-5.067-2.195-10.955,0.135-13.15,5.202    c-2.194,5.068,0.135,10.956,5.203,13.15c59.559,25.793,102.417,79.131,114.646,142.68c0.921,4.785,5.111,8.112,9.81,8.112    c0.626,0,1.262-0.059,1.899-0.182C465.594,225.62,469.145,220.377,468.102,214.954z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M302.43,45.005l-0.262-0.057c-5.396-1.164-10.719,2.27-11.881,7.67c-1.163,5.399,2.271,10.718,7.67,11.881l0.117,0.026    c0.734,0.164,1.466,0.242,2.188,0.242c4.58,0,8.712-3.168,9.75-7.824C311.215,51.552,307.82,46.208,302.43,45.005z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M180.443,436.91c-60.787-25.419-104.49-79.117-116.907-143.642c-1.043-5.423-6.279-8.979-11.709-7.93    c-5.424,1.043-8.974,6.286-7.931,11.709c6.731,34.972,22.268,68.082,44.935,95.749c22.405,27.348,51.416,48.982,83.896,62.565    c1.26,0.527,2.568,0.777,3.854,0.777c3.911,0,7.626-2.31,9.229-6.145C187.941,444.898,185.538,439.04,180.443,436.91z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M214.065,447.507l-0.618-0.136c-5.387-1.197-10.733,2.201-11.931,7.592s2.201,10.733,7.593,11.931l0.7,0.154    c0.717,0.156,1.433,0.231,2.138,0.231c4.601,0,8.742-3.195,9.761-7.873C222.883,454.009,219.461,448.682,214.065,447.507z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M459.404,290.293c-5.39-1.177-10.722,2.246-11.899,7.642c-16.697,76.625-77.239,135.712-154.238,150.529    c-5.424,1.043-8.974,6.286-7.931,11.709c0.921,4.785,5.111,8.112,9.81,8.112c0.626,0,1.263-0.059,1.9-0.182    c41.502-7.986,79.502-27.901,109.891-57.591c30.342-29.645,51.128-67.101,60.109-108.32    C468.221,296.796,464.8,291.469,459.404,290.293z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M226.662,51.828c-1.044-5.423-6.286-8.979-11.71-7.93c-41.502,7.986-79.502,27.901-109.891,57.591    c-30.342,29.645-51.128,67.101-60.109,108.32c-1.175,5.396,2.246,10.723,7.642,11.899c0.717,0.156,1.434,0.231,2.139,0.231    c4.601,0,8.742-3.194,9.761-7.873C81.191,137.44,141.733,78.354,218.731,63.537C224.155,62.494,227.705,57.251,226.662,51.828z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M256,222c-18.748,0-34,15.252-34,34s15.252,34,34,34s34-15.252,34-34S274.748,222,256,222z M256,270    c-7.72,0-14-6.28-14-14c0-7.72,6.28-14,14-14c7.72,0,14,6.28,14,14C270,263.72,263.72,270,256,270z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M256.152,40c-5.522,0-10,4.477-10,10v22.408c0,5.523,4.478,10,10,10c5.523,0,10-4.477,10-10V50    C266.152,44.477,261.674,40,256.152,40z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M255.848,422.464c-5.522,0-10,4.477-10,10V462c0,5.523,4.478,10,10,10c5.522,0,10-4.477,10-10v-29.536    C265.848,426.941,261.37,422.464,255.848,422.464z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M462,246.152h-27c-5.522,0-10,4.477-10,10s4.478,10,10,10h27c5.522,0,10-4.477,10-10    C472,250.629,467.522,246.152,462,246.152z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M79,245.848H50c-5.522,0-10,4.477-10,10s4.478,10,10,10h29c5.522,0,10-4.477,10-10C89,250.325,84.522,245.848,79,245.848z    " fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M232,246h-45.667c-5.522,0-10,4.477-10,10s4.478,10,10,10H232c5.522,0,10-4.477,10-10S237.522,246,232,246z" fill="#FFFFFF"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M256,128.333c-5.522,0-10,4.477-10,10V232c0,5.523,4.478,10,10,10c5.522,0,10-4.477,10-10v-93.667    C266,132.81,261.522,128.333,256,128.333z" fill="#FFFFFF"/>
                            </g>
                        </g>
</svg>
                </div>
                <?php
                $datetime1 = date_create($obEngine->getConfig('data_start'));
                $datetime2 = new DateTime();
                $interval = date_diff($datetime1, $datetime2);
                $site_work_day = $interval->days;
                ?>
                <div class="stat-num"><?php echo $site_work_day; ?></div>
                <p><?php echo getWord($site_work_day, ['День', 'Дня', 'Дней']); ?></p>
            </div>

        </div>
    </div>
    <h5 class="page-title">Хотите разместить рекламу?</h5>
    <div class="card mb-4">
        <div class="card-body row">
            <div class="col-12">
                <p><?php echo $obEngine->getConfig('site_name'); ?> - это сервис интернет-рекламы, который позволяет максимально быстро и выгодно разместить вашу контекстную или баннерную рекламу на сайтах-партнерах. С помощью нашей платформы вы сможете провести по-настоящему эффективную рекламную кампанию, которая привлечет вам надежных партнеров и целевых посетителей.</p>
            </div>
            <div class="rules-list__item col">
                <span class="rules-list__title">Рекламодателю</span>
                <div class="rules-list-bullets">
                    <div class="rules-list-bullets__item">
                        Большой выбор площадок для рекламы
                    </div>
                    <div class="rules-list-bullets__item">
                        Показ рекламы сразу после оплаты
                    </div>
                    <div class="rules-list-bullets__item">
                        Пополнение через <a href="https://yoomoney.ru"><b>ЮMoney</b></a>
                    </div>
                    <div class="rules-list-bullets__item">
                        Возврат средств в случае удаления
                    </div>
                </div>
            </div>
            <div class="rules-list__item col">
                <span class="rules-list__title">Вебмастеру</span>
                <div class="rules-list-bullets">
                    <div class="rules-list-bullets__item">
                        Простая интеграция рекламных блоков
                    </div>
                    <div class="rules-list-bullets__item">
                        Подробная статистика доходов
                    </div>
                    <div class="rules-list-bullets__item">
                        Выплаты на <a href="https://yoomoney.ru"><b>ЮMoney</b></a>
                    </div>
                    <div class="rules-list-bullets__item">
                       Минимальная сумма выплаты <b><?php echo $obEngine->getConfig('min_pay'); ?></b> рублей
                    </div>
                </div>
            </div>
        </div>
    </div>
    <h5 class="page-title">Партнерская программа!</h5>
    <div class="card">
    <div class="card-body">
    <?php
    $ref_proc = $obEngine->getConfig('ref_proc');
    ?>
    <p>Партнерская программа позволяет получать доход в размере <b><?php echo $ref_proc; ?>%</b> от суммы каждой покупки ссылки или баннера, а также пополнения баланса пользователями. Чем больше у вас активных рефералов, тем выше ваш заработок.</p>
</div>
</div>
</div>

<?php include 'module/user_menu.php'; ?>