<?php 
if (!defined('BASE_DIR')) { exit(header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true)); }

if (!isset($_SESSION['user_id'])) { exit(header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true)); } 

if ($users_info['ban'] == 1) { exit(header('Location: /ban.php?mode='.$users_info['ban'])); } 

$obEngine->addTitleHtml('Пополнение баланса');
?>

<div class="col-lg-8">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0 text-light">Пополнение баланса</h4>
    </div>
    <div class="card shadow-sm">
        <div class="card-body p-4">
            <?php
            if (isset($_GET['mode']) && $_GET['mode'] == 'preview') {
                $referer = $_SERVER['HTTP_REFERER'] ?? '';
                if (strpos($referer, 'payin.php') === false && strpos($referer, $_SERVER['HTTP_HOST']) === false) {
                    exit(header('Location: /payin.php?msg=200'));
                }
                
                if (isset($_POST['label'])) {
                    
                    $label = clear($_POST['label']);
                    $query = $mysqli->query("SELECT `money`, `user_id` FROM `".PREFIX."_history_pay` WHERE `param` = '".$label."' AND `status` = '0' LIMIT 1");
                    
                    if ($query->num_rows) {
                        $res = $query->fetch_assoc();
                        
                        
                        if ($res['user_id'] != $_SESSION['user_id']) {
                            exit(header('Location: /payin.php?msg=200'));
                        }
                        
                        $actual_sum = $res['money']; 
                        
                        $mysqli->query("UPDATE `".PREFIX."_history_pay` SET `payment` = 'yoomoney' WHERE `param` = '".$label."'");

                        $params = array(
                            'receiver' => YooMoney,
                            'label' => $label,
                            'quickpay-form' => 'button',
                            'sum' => $actual_sum,
                            'paymentType' => 'AC',
                            'formcomment' => 'Пополнение игрового баланса [USER ID '.$_SESSION['user_id'].']',
                            'short-dest' => 'Пополнение игрового баланса [USER ID '.$_SESSION['user_id'].']',
                            'successURL' => 'https://adred.ru/success.php'
                        );

                        $url = 'https://yoomoney.ru/quickpay/confirm?' . http_build_query($params);
                        header('Location: ' . $url);
                        exit;
                    } else {
                        exit(header('Location: /payin.php?msg=200'));
                    }
                }

                $sum = isset($_POST['sum']) ? round(floatval($_POST["sum"]), 2) : 0;
                
                if ($sum < 5 || $sum > 50000) { 
                    exit(header('Location: /payin.php?msg=200')); 
                }
                
                $comm = sprintf("%.2f", ($sum * $obEngine->getConfig('comm_pay')) / 100);
                $sum_comm = sprintf("%.2f", $sum + $comm);
                
                if ($sum_comm <= 0) { 
                    exit(header('Location: /payin.php?msg=200')); 
                }
                
                $param = md5(time() . $_SESSION['user_id'] . rand(1000, 9999));
                $mysqli->query("INSERT INTO `".PREFIX."_history_pay` (`param`,`time_add`,`user_id`,`type`,`payment`,`price`,`money`,`wallet`,`status`) VALUES ('".$param."_yoomoney',NOW(),'".$_SESSION['user_id']."','1','yoomoney','".$sum."','".$sum_comm."','', '0')");
                $id_zakaz_yoomoney = $mysqli->insert_id();
                ?>

                <div class="text-center mb-4">
                    <h5 class="text-light">Подтверждение платежа</h5>
                    <p class="text-muted">Пожалуйста, проверьте детали перед оплатой</p>
                </div>

                <div class="card border mb-4">
                    <div class="card-header bg-dark">
                        <h6 class="mb-0 text-light">Детали платежа</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom">
                                    <span class="text-light">Сумма пополнения:</span>
                                    <strong class="text-dark"><?php echo $sum; ?> руб.</strong>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom">
                                    <span class="text-light">Комиссия системы:</span>
                                    <strong class="text-danger"><?php echo $comm; ?> руб.</strong>
                                </div>
                                <div class="d-flex justify-content-between align-items-center pt-2">
                                    <span class="fw-bold text-light">Итого к оплате:</span>
                                    <strong class="text-primary fs-5"><?php echo $sum_comm; ?> руб.</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-4">
                    <h6 class="text-center mb-3 text-dark">Выбор способа оплаты</h6>
                    
                    <div class="row g-3 justify-content-center">
                        <div class="col-md-6">
                            <div class="card border h-100">
                                <div class="card-header bg-dark text-center">
                                    <h6 class="mb-0 text-light">ЮMoney</h6>
                                </div>
                                <div class="card-body text-center p-4">
                                    <div class="mb-3">
                                        <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                            <i class="fab fa-yandex fa-2x"></i>
                                        </div>
                                        <p class="text-muted small mb-0">Банковская карта, ЮMoney баланс</p>
                                    </div>
                                    <form method="POST" class="mb-2">
                                        <input type="hidden" name="sum" value="<?php echo $sum_comm; ?>">
                                        <input type="hidden" name="label" value="<?php echo $param.'_yoomoney'; ?>">
                                        <button type="submit" class="btn btn-warning w-100 py-2 fw-medium">
                                            Оплатить
                                        </button>
                                    </form>
                                    <small class="text-muted">+ комиссия <?php echo $comm; ?> руб.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <a href="/payin.php" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Обратно
                    </a>
                </div>
                
                <?php
            } else {
                $sum = isset($_GET['sum']) ? floatval($_GET['sum']) : 5;
                if ($sum < 5) $sum = 5;
                if ($sum > 50000) $sum = 50000;
                
                $comm = sprintf("%.2f", ($sum * $obEngine->getConfig('comm_pay')) / 100);
                ?>
                
<div class="card border mb-4">
    <div class="card-header bg-dark">
        <h6 class="mb-0 text-light text-center">Введите сумму пополнения</h6>
    </div>
    <div class="card-body">
        <p class="text-muted mb-4 text-center">Минимальная сумма 5 рублей</p>
        
        <form name="form1" method="post" action="?mode=preview" onsubmit="return validate1();">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10">
                    <label for="sum" class="form-label fw-medium text-dark text-center w-100">Сумма пополнения (руб.)</label>
                    <div class="input-group input-group-lg mx-auto" style="max-width: 500px;">
                        <input type="number" 
                               name="sum" 
                               id="sum" 
                               value="<?php echo $sum; ?>" 
                               onkeyup="calculate();" 
                               onchange="calculate();"
                               min="5" 
                               max="50000" 
                               class="form-control"
                               placeholder="Введите сумму"
                               required>
                        <button type="submit" class="btn btn-primary fw-medium border-0 px-4">
                            Продолжить
                        </button>
                    </div>
                    <div class="form-text text-muted text-center mt-2">От 5 до 50 000 рублей</div>
                </div>
            </div>
        </form>
    </div>
</div>
              
<div class="card border mb-4">
    <div class="card-header bg-dark">
        <h6 class="mb-0 text-light text-center">Быстрый выбор суммы</h6>
    </div>
    <div class="card-body">
        <div class="d-flex flex-wrap gap-2 justify-content-center">
            <?php 
            $quick_amounts = [50, 100, 500, 1000, 5000];
            foreach ($quick_amounts as $amount): 
            ?>
                <button type="button" 
                        class="btn btn-outline-light btn-sm quick-amount" 
                        data-amount="<?php echo $amount; ?>">
                    <?php echo $amount; ?> ₽
                </button>
            <?php endforeach; ?>
        </div>
    </div>
</div>
                
                <?php
                $query = $mysqli->query("SELECT *, DATE_FORMAT(time_add, '%d.%m.%Y, %H:%i') as f_time_add FROM `".PREFIX."_history_pay` WHERE `user_id` = '".$_SESSION['user_id']."' and `type` = '1' and `status` = '1' ORDER BY time_add DESC LIMIT 10");
                if ($query->num_rows) {
                ?>
                
                <div class="card border">
                    <div class="card-header bg-dark d-flex justify-content-between align-items-center">
                        <h6 class="mb-0 text-light">История пополнений</h6>
                        <span class="badge bg-secondary"><?php echo $query->num_rows; ?> операций</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th class="border-0 ps-4">№</th>
                                        <th class="border-0">Дата</th>
                                        <th class="border-0">Система</th>
                                        <th class="border-0 text-end pe-4">Сумма</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $n = 1;
                                    while ($row = $query->fetch_assoc()) {

                                        $payment_display = $row['payment'];
                                        $badge_class = 'bg-secondary';
                                        
                                        if ($row['payment'] == 'yoomoney') {
                                            $payment_display = 'ЮMoney';
                                            $badge_class = 'bg-warning';
                                        }
                                        ?>
                                        <tr>
                                            <td class="ps-4 text-dark"><?php echo $n; ?></td>
                                            <td class="text-muted"><?php echo $row['f_time_add']; ?></td>
                                            <td>
                                                <span class="badge <?php echo $badge_class; ?>">
                                                    <?php echo $payment_display; ?>
                                                </span>
                                            </td>
                                            <td class="text-end fw-medium pe-4">
                                                <span class="text-success">+<?php echo $row['price']; ?> ₽</span>
                                            </td>
                                        </tr>
                                        <?php
                                        $n++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php
                }
            }
            ?>
        </div>
    </div>
</div>

<?php include 'module/user_menu.php'; ?>

<script type="text/javascript">
function calculate() {
    const sumInput = document.getElementById('sum');
    let amount = parseFloat(sumInput.value) || 0;
    
    if (amount < 5) amount = 5;
    if (amount > 50000) amount = 50000;
    sumInput.value = amount;
    
    const commissionRate = <?php echo $obEngine->getConfig('comm_pay') / 100; ?>;
    const commission = (amount * commissionRate).toFixed(2);
}

function validate1() {
    const amount = parseFloat(document.getElementById('sum').value);
    
    if (amount < 5 || isNaN(amount)) {
        alert('Минимальная сумма для пополнения 5 рублей');
        return false;
    }
    
    if (amount > 50000) {
        alert('Максимальная сумма для пополнения 50 000 рублей');
        return false;
    }
    
    return true;
}

document.addEventListener('DOMContentLoaded', function() {
    const quickAmounts = document.querySelectorAll('.quick-amount');
    quickAmounts.forEach(button => {
        button.addEventListener('click', function() {
            const amount = this.getAttribute('data-amount');
            document.getElementById('sum').value = amount;
            calculate();
        });
    });
    
    calculate();
});
</script>