<?php
namespace addPage;
class Battle{
    public $top     = 'Битва';
    public $html    = '';
    private $duels  = [];
    private $goldWin = 20;
    private $clefWin = 20;
    private $clefLose = 5;
    private $clefDraw = 20;
    public function __construct(&$game){
        $this->game = $game;
        $this->db = $game->db;
        $this->sql = $game->battle;
        $this->model = new \model\Battle($this->game);
        $this->modelArms = new \model\Arms($this->game);
        $this->modelNotice = new \model\Notice($this->game);
    }
    private function cleaning(){
        $this->speed = floor($this->game->war->getSpeed($this->game->user->getParamCity("id")));
        $this->timeCrusade = $this->game->war->getTimeCrusade(["x"=>$this->game->user->getParamCity("x"), "y"=>$this->game->user->getParamCity("y")], ["x"=>$this->game->sql["x"], "y"=>$this->game->sql["y"]], $this->speed);
        $this->model->del($this->sql["id"], ($this->timeCrusade+time()));
        $this->model->delState($this->sql["id"]);
        $this->model->delArms($this->sql["id"]);
        $this->model->delLog($this->sql["id"]);
    }
    private function definingTheEnemy(){
        $this->enemyUserId = $this->sql["withWhom"];//user
        if($this->enemyUserId!=0)
            $this->userEnemy = $this->model->getUserByCity($this->enemyUserId);
    }
    private function selectUserEnemy(){
    }
    public function createLegion($position, $cityId){
        $luck   = rand(1, 3);
        if($cityId == 0)
            $legion = 0;
        else
            $legion = $this->model->selectRandLegion($cityId)["id"];
        $this->model->createArm($this->sql["id"], $position, $legion, $luck);
    }
    private function createDual($position){
        $this->createLegion($position, $this->game->user->getParamCity("id"));
        $this->createLegion($position, $this->userEnemy["id"]);
    }
    private function createDuals(){
        for ($i = 1; $i <= 3; $i++) {
            $this->createDual($i);
        }
        $this->getAllDual();
    }
    private function minusHpMy($ataka){
        $this->myStatus["hp"]-= $ataka;
        if($this->myStatus["hp"]<0)
            $this->myStatus["hp"] = 0;
        $this->myAtakaHtml = $ataka;
        $this->model->updateHp($this->myStatus["id"], $this->myStatus["hp"]);
    }
    private function setEnemyHp(){
        if($this->game->sql["type"] == 'barbar')
            $hp = $this->game->sql["hp"]; 
        else
            $hp = $this->enemyStatus["hp"];
        $this->enemyHp = $hp;
    }
    private function minusHpEnemy($ataka){
        $this->enemyHp -= $ataka;
        if($this->enemyHp<0)
            $this->enemyHp = 0;
        $this->enemyAtakaHtml = $ataka;
        if($this->game->sql["type"] == 'barbar')
            $this->model->updateHpBarbar($this->game->sql["id"], $this->enemyHp);
        else
            $this->model->updateHp($this->enemyStatus["id"], $this->enemyHp);
    }
    public function updateLegion($armId, $legion){
        $luck   = rand(1, 3);
        $this->model->updateArm($armId, $legion, $luck);
    }
    private function changeLegionMy($id){
        $legion = $this->model->selectRandLegion($this->game->user->getParamCity("id"));
        $this->updateLegion($id, $legion["id"]);
    }
    private function changeLegionEnemy($id){
        if($this->enemyUserId==0)
            $legion = 0;
        else
            $legion = $this->model->selectRandLegion($this->userEnemy["id"])["id"];
        $this->updateLegion($id, $legion);
    }
    private function setDrawBarbar(){
        
    }
    private function setDraw(){
        $this->top = 'Ничья';
        if($this->enemyUserId==0)
            $this->barbarWin();
        else{
            $this->finish = true;
            $this->model->clefPlass($this->clefDraw, $this->game->user->getParam("id"));
            $this->result = '
                <div class="center">
                    <div class="fz20">
                        Награда
                    </div>
                    <div class="fz15">
                        <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefDraw.'
                    </div>
                </div>';
            $this->cleaning();
            $tema = 'Ничья';
            $text = $this->model->getScriptMsg($this->game->user->getParam("id"), $this->game->sql["id"]).'
            <div class="p-5-10">
                Игрок: 
                <span class="textUnder fBold" onclick=goProfil()>'.$this->game->user->getParam("nick").'</span>
                не смог разбить ваш легион в 
                <span class="textUnder fBold" onclick=goCity()>городе</span>.
            </div>
            ';
            
            $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);
            
            // fix
            $this->modelNotice->create( $this->userEnemy["withWhom"], $tema, $text);
            
        }
    }
    private function barbarLose(){
        $this->top = 'Поражение';
        $this->finish = true;
        $this->model->clefPlass($this->clefLose, $this->game->user->getParam("id"));
        $this->result = '
            <div class="redPanel redPanelBack">
                <div class="white center paddingtb5">
                    <div class="hrRed">
                    </div>
                    <div class="fz20 blacPanelRedButton p-5-10">
                        Награда
                    </div>
                    <div class="hrRed">
                    </div>
                    <div class="fz15 center p-5-10">
                        <div>
                            <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefLose.'
                        </div>
                    </div>
                </div>
            </div>';
        $this->cleaning();
    }
    private function lose(){
        if($this->enemyUserId==0)
            $this->barbarLose();
        else{
            $this->top = 'Поражение';
            $this->finish = true;
            $this->model->clefPlass($this->clefLose, $this->game->user->getParam("id"));
            $this->minusArmsMy();
            $this->result = '
            <div class="redPanel redPanelBack">
                <div class="white center paddingtb5">
                    <div class="hrRed">
                    </div>
                    <div class="fz20 blacPanelRedButton p-5-10">
                        Награда
                    </div>
                    <div class="hrRed">
                    </div>
                    <div class="fz15 center p-5-10">
                        <div>
                            <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefLose.'
                        </div>
                    </div>
                    '.$this->textArms.'
                </div>
            </div>';
            $this->cleaning();
            $tema = 'Победа';
            $text = $this->model->getScriptMsg($this->game->user->getParam("id"), $this->game->sql["id"]).'
            <div class="p-5-10">
                Игрок: 
                <span class="textUnder fBold" onclick=goProfil()>'.$this->game->user->getParam("nick").'</span>
                был разбит вашим легионом в 
                <span class="textUnder fBold" onclick=goCity()>городе</span>.
                '.$this->textMailArms.'
            </div>
            ';
            
            $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);

            // fix
          //  $this->modelNotice->create( $this->userEnemy["withWhom"], $tema, $text);
            
        }
    }
    private function barbarWin(){
        if($this->game->user->getParam("alliance")>0){
            $this->model->scullPlass($this->game->user->getParam("alliance"), $this->game->sql["level"]);
            $scull = '<img src="'.$this->game->url.'/img/icons/scull.png" class="vs" height="20">'.$this->game->sql["level"];
        }
        $clef = 100 * $this->game->sql["level"];
        $this->model->mapLevelUp($this->game->sql["id"]);
        $this->finish = true;
        $this->model->clefPlass($clef, $this->game->user->getParam("id"));
        $this->result = '
            <div class="redPanel redPanelBack">
                <div class="white center paddingtb5">
                    <div class="hrRed">
                    </div>
                    <div class="fz20 blacPanelRedButton p-5-10">
                        Награда
                    </div>
                    <div class="hrRed">
                    </div>
                    <div class="fz15 center p-5-10">
                        <div>
                            <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$clef.' '.$scull.'
                        </div>
                    </div>
                </div>
            </div>';
        $this->cleaning();
    }
    private function changeStatus(){
        if($this->game->sql["invader"] == 0 and $this->sql["withWhom"]==$this->game->sql["user"]){
            $this->textStatus = 'Вы захватили город';
            $this->model->capture($this->sql["city"], $this->game->user->getParam("id"));
            $this->minusArmsEnemy($this->game->sql["id"]);
        }
        elseif($this->game->sql["invader"]==$this->sql["withWhom"]){
            $cityId = $this->model->selectCityByUser($this->game->sql["invader"])["id"];
            $this->minusArmsEnemy($cityId);
            $this->textStatus = 'Вы освободили город';
            $this->model->capture($this->sql["city"], 0);
        }
        else{
            $this->minusArmsEnemy($this->game->sql["id"]);
            $this->textStatus = 'Вы не успели захватить город';
        }
    }
    private function minusArmsEnemy($cityId){
        $result = $this->model->selectArmsDowngrade($cityId);
        $this->model->setArmsDowngrade($cityId);
        if($result->num_rows > 0){
            $this->textArms = ''; 
            while($q = $result->fetch_assoc()){
                $armName = $this->modelArms->getArmId($q["type"])["name"];
                $this->textArms .= '
                <div>
                    <img src="'.$this->game->url.'/img/arms/'.$q["type"].'.png" class="vs" height="20">'.$armName.' 
                    (<img src="'.$this->game->url.'/img/icons/level.png" class="vs" height="20">'.$q["level"].'
                    -1)
                </div>';
            }
            $this->textMailArms = '
                    <div>
                        Ваши потери:
                    </div>
                    '.$this->textArms.'
            ';
            $this->textArms = '
            <div class="hrRed">
		    </div>
            <div class="fz20 blacPanelRedButton p-5-10">
                Потери врага
            </div>
            <div class="hrRed">
			</div>
            <div class="fz15 center p-5-10">
                '.$this->textArms.'
            </div>';
        }
    }
    private function minusArmsMy(){
        // $userId = $this->userEnemy["user_id"];
        // $cityId = $this->model->selectCityByUser($userId)["id"];
        $cityId = $this->game->user->getParamCity("id");
        $result = $this->model->selectArmsDowngrade($cityId);
        $this->model->setArmsDowngrade($cityId);
        if($result->num_rows > 0){
            $this->textArms = ''; 
            while($q = $result->fetch_assoc()){
                $armName = $this->modelArms->getArmId($q["type"])["name"];
                $this->textArms .= '
                <div>
                    <img src="'.$this->game->url.'/img/arms/'.$q["type"].'.png" class="vs" height="20">'.$armName.' 
                    (<img src="'.$this->game->url.'/img/icons/level.png" class="vs" height="20">'.$q["level"].'
                    -1)
                </div>';
            }
            $this->textMailArms = '
                    <div>
                        Потери врага:
                    </div>'.$this->textArms;
            $this->textArms = '
            <div class="hrRed">
		    </div>
            <div class="fz20 blacPanelRedButton p-5-10">
                Ваши потери
            </div>
            <div class="hrRed">
			</div>
            <div class="fz15 center p-5-10">
                '.$this->textArms.'
            </div>';
        }
    }
    private function win(){
        $this->top = 'Победа';
        if($this->enemyUserId==0)
            $this->barbarWin();
        else{
            $this->changeStatus();
            $this->finish = true;
            $this->model->clefPlass($this->clefWin, $this->game->user->getParam("id"));
            $this->result = '
            <div class="redPanel redPanelBack">
                <div class="white center paddingtb5">
                    <div class="hrRed">
                    </div>
                    <div class="fz20 blacPanelRedButton p-5-10">
                        Награда
                    </div>
                    <div class="hrRed">
                    </div>
                    <div class="fz15 center p-5-10">
                        <div>
                            <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefWin.'
                        </div>
                        '.$this->textStatus.'
                    </div>
                    '.$this->textArms.'
                </div>
            </div>';
            $this->cleaning();
            $tema = 'Поражение';
            $text = $this->model->getScriptMsg($this->game->user->getParam("id"), $this->game->sql["id"]).'
            <div class="p-5-10">
                Игрок: 
                <span class="textUnder fBold" onclick=goProfil()>'.$this->game->user->getParam("nick").'</span>
                разбил ваш легион в 
                <span class="textUnder fBold" onclick=goCity()>городе</span>.
                '.$this->textMailArms.'
            </div>
            ';
            
            
            
            $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);
            
            
            // fix
         //   $this->modelNotice->create( $this->userEnemy["withWhom"], $tema, $text);
            
            
        }
    }
    private function checkStatus(){
        if($this->myStatus["hp"]==0 and $this->enemyHp == 0)//Ничья
            $this->setDraw();
        elseif($this->myStatus["hp"]==0)//Я проиграл
            $this->lose();
        elseif($this->enemyHp == 0)//Я выйграл
            $this->win();
        else
            $this->getAllDual();
    }
    private function startDuel($myId, $enemyId){
        
        $this->minusHpMy($this->enemyAtakaLuck);
        $this->minusHpEnemy($this->myAtakaLuck);
        $this->changeLegionMy($myId);
        $this->changeLegionEnemy($enemyId);
        $this->duelsHtml = '';
        $this->duels = [];
        unset($_GET["position"]);
        $this->checkStatus();
    }
    private function setHtmlDuels(){
        $this->duelsHtml = '';
        foreach ($this->duels as $key => $value) {
            $myAtaka    = 0;
            $myType     = 0;
            $enemyAtaka = 0;
            $enemyType  = 0;
            $luck       = 0;
            $myId       = 0;
            $enemyId    = 0;
            $unknown    = false;
            foreach ($this->duels[$key] as $i => $v) {
                if($this->duels[$key][$i]["city"]==$this->game->user->getParamCity("id")){
                    $myAtaka        = $this->modelArms->getParam("ataka", $this->duels[$key][$i]["type"], $this->duels[$key][$i]["level"], $this->duels[$key][$i]["up_ataka"]);
                    $myType         = $this->duels[$key][$i]["type"];
                    $luck           = $this->duels[$key][$i]["luck"];
                    $myId           = $this->duels[$key][$i]["id"];
                }
                elseif($this->duels[$key][$i]["city"] == null){
                    $enemyType      = rand(0,4);
                    $enemyAtaka     = $this->modelArms->getParam("ataka", $enemyType, $this->game->sql["level"], $this->game->sql["level"]);
                    $enemyId        = 0;
                    $unknown        = true;
                }
                else{
                    $enemyAtaka     = $this->modelArms->getParam("ataka", $this->duels[$key][$i]["type"], $this->duels[$key][$i]["level"], $this->duels[$key][$i]["up_ataka"]);
                    $enemyType      = $this->duels[$key][$i]["type"];
                    $enemyId           = $this->duels[$key][$i]["id"];
                }
                
            }
            if(isset($_GET["position"]) and $_GET["position"]==$key){
                if($luck==3){
                    $this->myAtakaLuck = round($myAtaka * 1.5);
                    $this->enemyAtakaLuck = round($enemyAtaka * 0.5);    
                }
                elseif($luck==1){
                    $this->myAtakaLuck = round($myAtaka * 0.5) ;
                    $this->enemyAtakaLuck = round($enemyAtaka * 1.5);
                }
                else{
                    $this->myAtakaLuck = round($myAtaka) ;
                    $this->enemyAtakaLuck = round($enemyAtaka);
                }
                $this->model->addLog($this->game->user->getParam("id"), $this->game->sql["id"], $this->myAtakaLuck, $myType, $this->enemyAtakaLuck, $enemyType);
                $this->startDuel($myId, $enemyId);
                return;
            }
            $this->duelsHtml .= $this->model->showHtmlDuel($key, $myAtaka, $myType, $enemyAtaka, $enemyType, $luck, $unknown);
        }
    }
    private function sortDuals(){
        while($q = $this->armsBattle->fetch_assoc()){
            if($this->duels[$q["position"]]==null)
                $this->duels[$q["position"]] = [];
            array_push($this->duels[$q["position"]], $q);
        }
        $this->setHtmlDuels();
    }
    private function getAllDual(){
        $this->armsBattle = $this->model->selectArms($this->sql["id"]);
        if($this->armsBattle->num_rows==0)
            $this->createDuals();
        else
            $this->sortDuals();
    }
    private function createStatus($user, $hp){
        $this->model->createStatus($this->sql["id"], $user, $hp);
    }
    private function createEnemyStatus(){
        if($this->enemyUserId==0){
            $hp     = 0;
            $user   = 0;
        }
        else{
            $this->arms = $this->modelArms->getSql($this->userEnemy["id"]);//Выбор по городу, а userEnemy id хранит город
            $hp = $this->modelArms->howManyHp($this->arms);
            $user = $this->enemyUserId;
        }
        $this->createStatus($user, $hp);
    }
    private function createMyStatus(){
        $this->arms = $this->modelArms->getSql($this->game->user->getParamCity("id"));
        $hp = $this->modelArms->howManyHp($this->arms); 
        $this->createStatus($this->game->user->getParam("id"), $hp);
    }
    private function determinationOfStatus(){
        while($q = $this->status->fetch_assoc()){
            if($q["user"] == $this->game->user->getParam("id"))
                $this->myStatus = $q;
            else
                $this->enemyStatus = $q;
        }
    }
    private function selectStatus(){
        $this->status = $this->model->selectStatus($this->sql["id"]);
        if($this->status->num_rows==0){
            $this->createMyStatus();
            $this->createEnemyStatus();
            $this->selectStatus();
        }
        else
            $this->determinationOfStatus();
    }
    
    public function setAnimate(){
        $this->scriptAtack = '
        <script>
            window.brouser.getLast().t = -100;
            window.brouser.getLast().p = 0;
            window.brouser.getLast().w = 60;
            function goDuel(position){
                if(window.brouser.getLast().w == 60)
                    window.brouser.addTimer(()=>{
                        if(window.brouser.getLast().p>window.brouser.getLast().t)
                            draw(position);
                        else{
                            window.brouser.openPage("'.$this->game->getUrl().'/html/page/city.php?war&go&position="+position, {"x": '.$this->game->sql["x"].', "y": '.$this->game->sql["y"].'}, false);
    
                            window.brouser.getLast().delTimer(window.brouser.getLast().getLastTimer());
                                                }
                    }, window.brouser.getLast().update);
            }
            function draw(position){
                
                window.brouser.getLast().p -= 1; 
                if(window.brouser.getLast().p<window.brouser.getLast().t/2)
                    window.brouser.getLast().w -= 0.3;
                else
                    window.brouser.getLast().w += 0.3;
                $("#legion"+position).css({ top: window.brouser.getLast().p });
                $("#myLegion"+position).css({ width: window.brouser.getLast().w });
            }
        </script>';
        // $this->scriptAtack = '
        // <script>
        //     function goDuel(position){
        //         window.brouser.openPage("'.$this->game->getUrl().'/html/page/city.php?war&go&position="+position, {"x": '.$this->game->sql["x"].', "y": '.$this->game->sql["y"].'}, false);
        //     }
        // </script>';
        
    }
    public function showHtmlLogId($q){
        $my = '';
        $enemy = '';
        if($this->game->user->getParam("id")==$q["user"]){
            $my     = $this->model->showHtmlLogMy($q["ataka"], $q["type_arm"]);
            $nick   = '<span class="green">Вы </span>';
        }
        elseif($this->game->user->getParam("alliance") == $q["alliance"]){
            $my = $this->model->showHtmlLogMy($q["ataka"], $q["type_arm"]);
            $nick   = '<span class="green" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/page/profil.php'.'&quot;,'.'{&quot;userId&quot;: '.$q["user"].'}'.')">'.$q["nick"].' </span>';
        }
        else{
            $my = $this->model->showHtmlLogEnemy($q["ataka"], $q["type_arm"]);
            $nick   = '<span class="red" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/page/profil.php'.'&quot;,'.'{&quot;userId&quot;: '.$q["user"].'}'.')">'.$q["nick"].' </span>';
        }
        return $nick.$my;
    }
    private function setLog(){
        
        
        // вычисляем если ли у нападавющего купол  02.09.2025
        
      //  $userIm = $this->modelUser->getByDome($this->user->getParam("id"));
        
        
       
        
        if ($this->game->user->getParam("dome") > time())
        {

            $query = "UPDATE `users` SET `dome` = {?} WHERE `id` = {?}";
		    $this->game->db->query($query,[time() - 86400 * 3, $this->game->user->getParam("id")]);
		
        }
        
        $logSql = $this->model->selectLog($this->game->sql["id"]);
        $log = '';
        if($logSql->num_rows>0){
            while($q = $logSql->fetch_assoc()){
                $log .= '<div>'.$this->showHtmlLogId($q).'</div>';
            }
            $log = '
            <hr>
            <div class="p-5-10">
                <div class="center bgPanelMini white fz20">
                    <div class="blacPanelRedButton p-5-10">
                        Журнал
                    </div>
                    <div class="center p-5-10">
                    '.$log.'
                    </div>
                </div>
            </div>';   
        }
        $this->logHtml = $log;
    }
    public function start(){
        $this->html = 'Битва';
        $this->setAnimate();
        $this->definingTheEnemy();
        $this->selectStatus();
        $this->setEnemyHp();
        $this->getAllDual();
        if($this->finish==false){
            if($this->enemyUserId==0){
                $enemyName  = 'Варвар';
                $enemyId    = $this->userEnemy["user_id"];
            }
            else{
                $enemyName  = $this->userEnemy["nick"];
                $enemyId    = $this->userEnemy["user_id"];
            }
            $this->enemyHtmlPanel   =  $this->model->showHtmlUser($enemyId, $enemyName, $this->enemyHp, $this->enemyAtakaHtml);
            $this->myHtmlPanel      =  $this->model->showHtmlUser($this->game->user->getParam("id"), $this->game->user->getParam("nick"), $this->myStatus["hp"], $this->myAtakaHtml, 'ataka');
        }
        if(!$this->finish)
            $this->setLog();
        $this->html = $this->scriptAtack.'
        <div class="p-5-10">
            '.$this->result.'
            '.$this->enemyHtmlPanel.'
            <div class="center">
                '.$this->duelsHtml.'
            </div>
            '.$this->myHtmlPanel.'
        </div>
        '.$this->logHtml;
    }
}