<?php
namespace addPage;
class Battle{
    private $armAtaka;//Массив с армией атаки
    private $armDef;//Массив с армией защиты
    private $result;//Результат битвы
    private $battleAtaka;//Состояние общей армии(хп и прочее)
    private $battleDef;
    private $duels = [];
    private $selectArm;// Выбираем за какую армию воюем
    private $clefWin = 20;
    private $clefLose = 5;
    private $clefDraw = 20;
    private $finish = false;
    public function __construct(&$crusade){
        $this->crusade  = $crusade;
        $this->staff    = $crusade->staff;
        $this->game = $crusade->staff->game;
        $this->db = $crusade->game->db;
        $this->model = new \model\Battle($this->game);
        $this->modelArms = new \model\Arms($this->game);
        $this->modelNotice = new \model\Notice($this->game);
        $this->start();
    }
    private function start(){
        $this->searchForBattle();
    }
    private function lookEnemy(){
        $this->countEnemy = $this->model->findDefendersCol($this->crusade->staff->crusade["city2"]);
        if($this->countEnemy>0)
            $this->issueDefendersList();
        else
            $this->captureCity();
        //$this->html = 'Поиск врага';
    }
    private function issueDefendersList(){
        $defender = $this->model->findDefenders($this->crusade->staff->crusade["city2"]);
        $this->model->create($this->crusade->staff->crusade["id"], $defender["id"]);
        $this->start();
    }
    private function sendMsgExemptionInvader(){
        $msg = $this->model->getScriptMsg($this->crusade->staff->game->user->getParam("id"), $this->crusade->staff->crusade["city2"]).'
            <div class="p-5-10">
                Игрок: 
                <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
                Освободил освободил захваченый вами 
                <span class="textUnder fBold" onclick=goCity()>город</span>.
            </div>
        ';
        $this->modelNotice->create( $this->userCity["invader"], 'Освобождение провинции', $msg);
    }
    private function makeExemption(){
        $this->top = 'Освобождение города';
        $this->html = '<div class="p-5-10 center fz20">Вы освободили город.</div>';
        $this->model->capture($this->crusade->staff->crusade["city2"], 0);
        $msg = $this->model->getScriptMsgCapture($this->crusade->staff->game->user->getParam("id")).'
            <div class="p-5-10">
                Игрок: 
                <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
                Освободил ваш город.
            </div>
        ';
        $this->modelNotice->create( $this->userCity["user"], $this->top, $msg);
        $this->sendMsgExemptionInvader();
    }
    private function captureCityLetsGo(){
        $this->top = 'Захват города';
        $text = 'Вы захватили город.';
        $this->model->capture($this->crusade->staff->crusade["city2"], $this->crusade->staff->game->user->getParam("id"));
        $msg = $this->model->getScriptMsgCapture($this->crusade->staff->game->user->getParam("id")).'
        <div class="p-5-10">
            Игрок: 
            <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
            Захватил ваш город.
        </div>
        ';
        $this->modelNotice->create( $this->userCity["user"], $this->top, $msg);
        $this->html = '<div class="p-5-10 center fz20">'.$text.'</div>';
    }
    private function giveOutMyCity(){
        $this->top = 'Захват города';
        $this->html = '<div class="p-5-10 center fz20">Вы не можете захватить свой город.</div>';
    }
    private function alreadyCaptured(){
        $this->top = 'Захват города';
        $this->html = '<div class="p-5-10 center fz20">Уже захвачен.</div>';
    }
    private function captureCity(){
        $this->userCity = $this->model->selectCity($this->crusade->staff->crusade["city2"]); 
        if($this->userCity["invader"]>0 and $this->userCity["invader"]!=$this->crusade->staff->game->user->getParam("id"))
            $this->makeExemption();
        elseif($this->userCity["invader"]==$this->crusade->staff->game->user->getParam("id"))
            $this->alreadyCaptured();
        elseif($this->crusade->staff->crusade["city2"]!=$this->crusade->staff->game->user->getParamCity("id"))
            $this->captureCityLetsGo();
        else
            $this->giveOutMyCity();
    }
    private function searchForBattle(){
        $this->sql = $this->model->searchForBattle($this->crusade->staff->crusade["id"]);
        if($this->sql!=null)
            $this->showBattle();
        else
            $this->lookEnemy();
    }
    private function createStatus($crusade){
        $hp = $this->modelArms->howManyHp($this->arms);
        $this->model->createStatus($this->sql["id"], $crusade, $hp);
    }
    private function createMyStatus(){
        $this->arms = $this->modelArms->getSql($this->crusade->staff->game->user->getParamCity("id")); 
        $this->createStatus($this->crusade->staff->crusade["id"]);
    }
    private function createEnemyStatus(){
        $this->arms = $this->modelArms->getSql($this->crusadeEnemy["city"]); 
        $this->createStatus($this->crusadeEnemy["id"]);
    }
    private function selectStatus(){
        $this->status = $this->model->selectStatus($this->sql["id"]);
        if($this->status->num_rows==0){
            $this->createMyStatus();
            $this->createEnemyStatus();
            $this->selectStatus();
        }
        else
            $this->determinationOfStatus();
    }
    private function determinationOfStatus(){
        while($q = $this->status->fetch_assoc()){
            if($q["crusade"] == $this->crusade->staff->crusade["id"])
                $this->myStatus = $q;
            else
                $this->enemyStatus = $q;
        }
    }
    private function definingTheEnemy(){
        if($this->sql["crusade"] == $this->crusade->staff->crusade["id"])
            $this->enemyId = $this->sql["crusade2"];
        else
            $this->enemyId = $this->sql["crusade"];
    }
    private function selectUserEnemy(){
        $this->userEnemy = $this->model->getUserByCity($this->crusadeEnemy["city"]);
    }
    public function createLegion($position, $cityId){
        $legion = $this->model->selectRandLegion($cityId);
        $luck   = rand(1, 3);
        $this->model->createArm($this->sql["id"], $position, $legion["id"], $luck);
    }
    public function updateLegion($cityId, $armId){
        $legion = $this->model->selectRandLegion($cityId);
        $luck   = rand(1, 3);
        $this->model->updateArm($armId, $legion["id"], $luck);
    }
    private function createDual($position){
        $this->createLegion($position, $this->crusade->staff->game->user->getParamCity("id"));
        $this->createLegion($position, $this->crusadeEnemy["city"]);
    }
    private function createDuals(){
        for ($i = 1; $i <= 3; $i++) {
            $this->createDual($i);
        }
        $this->getAllDual();
    }
    private function sortDuals(){
        while($q = $this->armsBattle->fetch_assoc()){
            if($this->duels[$q["position"]]==null)
                $this->duels[$q["position"]] = [];
            array_push($this->duels[$q["position"]], $q);
        }
        $this->setHtmlDuels();
    }
    private function minusHpMy($ataka){
        $this->myStatus["hp"]-= $ataka;
        if($this->myStatus["hp"]<0)
            $this->myStatus["hp"] = 0;
        $this->myAtakaHtml = $ataka;
        $this->model->updateHp($this->myStatus["id"], $this->myStatus["hp"]);
    }
    private function minusHpEnemy($ataka){
        $this->enemyStatus["hp"]-= $ataka;
        if($this->enemyStatus["hp"]<0)
            $this->enemyStatus["hp"] = 0;
        $this->enemyAtakaHtml = $ataka;
        $this->model->updateHp($this->enemyStatus["id"], $this->enemyStatus["hp"]);
    }
    private function changeLegionMy($id){
        $this->updateLegion($this->crusade->staff->game->user->getParamCity("id"), $id);
    }
    private function changeLegionEnemy($id){
        $this->updateLegion($this->crusadeEnemy["city"], $id);
    }
    private function cleaning(){
        $this->model->del($this->sql["id"]);
        $this->model->delState($this->sql["id"]);
        $this->model->delArms($this->sql["id"]);
        $this->model->delLog($this->sql["id"]);
    }
    private function win(){
        $this->top = 'Победа';
        $this->finish = true;
        $this->model->clefPlass($this->clefWin, $this->crusade->staff->game->user->getParam("id"));
        $this->result = '
            <div class="center">
                <div class="fz20">
                    Награда
                </div>
                <div class="fz15">
                    <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefWin.'
                </div>
            </div>';
        $this->crusade->model->del($this->crusadeEnemy["id"]);
        $this->cleaning();
        $tema = 'Поражение';
        $text = $this->model->getScriptMsg($this->crusade->staff->game->user->getParam("id"), $this->crusade->staff->crusade["city2"]).'
        <div class="p-5-10">
            Игрок: 
            <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
            разбил ваш легион в 
            <span class="textUnder fBold" onclick=goCity()>городе</span>.
        </div>
        ';
        $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);
    }
    private function lose(){
        $this->top = 'Поражение';
        $this->finish = true;
        $this->model->clefPlass($this->clefLose, $this->crusade->staff->game->user->getParam("id"));
        $this->result = '
            <div class="center">
                <div class="fz20">
                    Награда
                </div>
                <div class="fz15">
                    <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefLose.'
                </div>
            </div>';
        $this->crusade->model->del($this->crusade->staff->crusade["id"]);
        $this->cleaning();
        $tema = 'Победа';
        $text = $this->model->getScriptMsg($this->crusade->staff->game->user->getParam("id"), $this->crusade->staff->crusade["city2"]).'
        <div class="p-5-10">
            Игрок: 
            <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
            был разбит вашим легионом в 
            <span class="textUnder fBold" onclick=goCity()>городе</span>.
        </div>
        ';
        $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);
    }
    private function setDraw(){
        $this->top = 'Ничья';
        $this->finish = true;
        $this->model->clefPlass($this->clefDraw, $this->crusade->staff->game->user->getParam("id"));
        $this->result = '
            <div class="center">
                <div class="fz20">
                    Награда
                </div>
                <div class="fz15">
                    <img src="'.$this->game->url.'/img/icons/clef.png" class="vs" height="20">'.$this->clefDraw.'
                </div>
            </div>';
        $this->cleaning();
        $tema = 'Ничья';
        $text = $this->model->getScriptMsg($this->crusade->staff->game->user->getParam("id"), $this->crusade->staff->crusade["city2"]).'
        <div class="p-5-10">
            Игрок: 
            <span class="textUnder fBold" onclick=goProfil()>'.$this->crusade->staff->game->user->getParam("nick").'</span>
            не смог разбить ваш легион в 
            <span class="textUnder fBold" onclick=goCity()>городе</span>.
        </div>
        ';
        $this->modelNotice->create( $this->userEnemy["user"], $tema, $text);
        //Отправить уведомление о ничьей
    }
    private function checkStatus(){
        if($this->myStatus["hp"]==0 and $this->enemyStatus["hp"]==0)
            $this->setDraw();
        elseif($this->myStatus["hp"]==0)
            $this->lose();
        elseif($this->enemyStatus["hp"]==0)
            $this->win();
        else
            $this->getAllDual();
    }
    private function startDuel($myId, $enemyId, $luck, $myAtaka, $enemyAtaka){
        if($luck==3){
            $myAtaka *= 1.5;
            $enemyAtaka *= 0.5;    
        }
        elseif($luck==1){
            $myAtaka *= 0.5 ;
            $enemyAtaka *= 1.5;
        }
        $this->minusHpMy($enemyAtaka);
        $this->minusHpEnemy($myAtaka);
        $this->changeLegionMy($myId);
        $this->changeLegionEnemy($enemyId);
        $this->duelsHtml = '';
        $this->duels = [];
        unset($_GET["position"]);
        $this->checkStatus();
    }
    private function setHtmlDuels(){
        $this->duelsHtml = '';
        foreach ($this->duels as $key => $value) {
            $myAtaka    = 0;
            $myType     = 0;
            $enemyAtaka = 0;
            $enemyType  = 0;
            $luck       = 0;
            $myId       = 0;
            $enemyId    = 0;
            foreach ($this->duels[$key] as $i => $v) {
                if($this->duels[$key][$i]["city"]==$this->game->user->getParamCity("id")){
                    $myAtaka        = $this->modelArms->getParam("ataka", $this->duels[$key][$i]["type"], $this->duels[$key][$i]["level"], $this->duels[$key][$i]["up_ataka"]);
                    $myType         = $this->duels[$key][$i]["type"];
                    $luck           = $this->duels[$key][$i]["luck"];
                    $myId           = $this->duels[$key][$i]["id"];
                }
                else{
                    $enemyAtaka     = $this->modelArms->getParam("ataka", $this->duels[$key][$i]["type"], $this->duels[$key][$i]["level"], $this->duels[$key][$i]["up_ataka"]);
                    $enemyType      = $this->duels[$key][$i]["type"];
                    $enemyId           = $this->duels[$key][$i]["id"];
                }
                
            }
            // if(isset($_GET["position"]) and $_GET["position"]==$key){
            //     $this->startDuel($myId, $enemyId, $luck, $myAtaka, $enemyAtaka);
            //     return;
            // }
            // $this->duelsHtml .= $this->model->showHtmlDuel($key, $myAtaka, $myType, $enemyAtaka, $enemyType, $luck);
        }
        //$this->duels = [];
    }
    private function getAllDual(){
        $this->armsBattle = $this->model->selectArms($this->sql["id"]);
        if($this->armsBattle->num_rows==0)
            $this->createDuals();
        else
            $this->sortDuals();
    }
    private function showBattle(){
        $this->top = 'Битва';
        $this->definingTheEnemy();
        $this->crusadeEnemy = $this->crusade->model->select($this->enemyId);
        $this->selectStatus();
        $this->selectUserEnemy();
        $this->getAllDual();
        if($this->finish==false){
            $this->enemyHtmlPanel   =  $this->model->showHtmlUser($this->userEnemy["user_id"], $this->userEnemy["nick"], $this->enemyStatus["hp"], $this->enemyAtakaHtml);
            $this->myHtmlPanel      =  $this->model->showHtmlUser($this->crusade->staff->game->user->getParam("id"), $this->crusade->staff->game->user->getParam("nick"), $this->myStatus["hp"], $this->myAtakaHtml, 'ataka');
        }
        $log = $this->model->showHtmlLog($this->sql["id"]);
        $this->html = '
        <script>
            function goDuel(position){
                window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms&crusade_id='.$this->staff->crusade["id"].'&ataka&position="+position, {"x": '.$this->staff->data["x"].', "y": '.$this->staff->data["y"].'}, false);
            }
        </script>
        <div class="p-5-10">
            '.$this->result.'
            '.$this->enemyHtmlPanel.'
            <div class="center">
                '.$this->duelsHtml.'
            </div>
            '.$this->myHtmlPanel.'
        </div>
        '.$log;
    }
}