<?php
namespace addPage\union;
class Chat{
    public $top = '';
    public $html = '';
    public function __construct(&$union){
        $this->union  = $union;
        $this->start();
    }
    private function addMsg(){
        $query = "INSERT INTO `alliance_chat` (`user`, `msg`, `time`, `alliance`) VALUES ({?}, {?}, {?}, {?})";
        $this->union->db->query($query, [$this->union->user->getParam("id"), $this->text, time(), $this->union->sql["id"]]);
    }
    private function sendMsg(){
        $this->text = htmlspecialchars($_POST["text"]);
        $msg = '';
        if(trim($this->text) != ''){
            if(empty(trim($this->text))) 
                $msg = '<div class="red">Сообщение содержит только запрещенные символы</div>';
            else
                $this->addMsg();
        }
        else
            $msg = 'Введите сообщение';
        if($msg!='')
            $this->union->view->addError("Ошибка", $msg);
    }
    
    private function showNewMsg(){
        
        if(isset($_POST["text"]))
            $this->sendMsg();
            
        $this->union->view->addScript($this->smile->showSmile($this->union->url));

        $form = $this->smile->getForm('/html/page/union.php?chat', ', "unionId": "'.$this->union->sql["id"].'"');

        $form = preg_replace_callback('/<input([^>]+)type="text"([^>]+)>/',
        
        
    function($matches) {
        $attrs = $matches[1] . $matches[2];
        $attrs = str_replace(['name="text"', 'value=""'], '', $attrs);

        return '
        <div class="chat-input-box">
            <textarea name="text"'.$attrs.'
                class="chat-textarea"
                placeholder="Введите ваше сообщение..."
                oninput="updateCharCounter(this)"></textarea>
            <div class="char-counter">0</div>
        </div>

        <style>
            .chat-input-box {
                width: 100%;
                position: relative;
            }
            .chat-textarea {
                width: 100%;
                min-height: 70px;
                padding: 8px;
                padding-right: 40px;  /* запас справа */
                padding-bottom: 25px; /* запас снизу */
                border: 2px solid #d17b46;
                border-radius: 10px;
                resize: vertical;
                font-family: inherit;
                font-size: 14px;
                box-sizing: border-box;
                background: #fff4e6;
                color: #5a2a00;
                outline: none;
            }
            .chat-textarea:focus {
                border: 2px solid #b34700;
                box-shadow: 0 0 5px rgba(179,71,0,0.4);
            }
            .char-counter {
                position: absolute;
                bottom: 6px;
                right: 12px;
                font-size: 11px;
                color: rgba(90,42,0,0.6); /* полупрозрачный */
                pointer-events: none;
                user-select: none;
            }
        </style>

        <script>
            function updateCharCounter(textarea) {
                var counter = textarea.parentElement.querySelector(".char-counter");
                counter.textContent = textarea.value.length;
            }
            document.addEventListener("DOMContentLoaded", function() {
                var textareas = document.querySelectorAll("textarea[name=\'text\']");
                textareas.forEach(function(textarea) {
                    updateCharCounter(textarea);
                    textarea.addEventListener("input", function() {
                        updateCharCounter(this);
                    });
                });
            });
        </script>';
    }, $form);
        
        $this->newMsg = $form;
    }
    private function start(){
        $this->top = 'Чат альянса';
        $this->smile = new \engine\Smile();
        $this->showNewMsg();
        $query = "SELECT count(*) col FROM `alliance_chat` WHERE `alliance`={?}";
        $count = $this->union->db->query($query, [$this->union->sql["id"]])->fetch_assoc()["col"];
        $k_page = \engine\Page::k_page($count, 20);
        $page = \engine\Page::page($k_page);
        $start = 20 * $page - 20;
        $query = "SELECT `alliance_chat`.*, `users`.nick AS nick, `users`.id AS userId ,IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `alliance_chat` 
        LEFT JOIN `users` 
        ON `users`.id = `alliance_chat`.user 
        
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
            GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        
        WHERE `alliance_chat`.alliance={?}
        ORDER BY `alliance_chat`.id DESC LIMIT $start, 20"; 
        $result = $this->union->db->query($query, [$this->union->sql["id"]]);
        
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $rank = $this->union->rank->getRank($q["rating"]);
                $this->msg .= '
                <div class="msg white">
                    <div class="table w100">
                        <div class="white row">
                            <div class="cell w50 fz20">
                                <img src="'.$this->union->getUrl().'/img/rank/'.$rank.'.png" class="vs" height="25">
                                <span class="textUnder fBold" onclick="window.brouser.openPage(&quot;'.$this->union->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["userId"].'})">'.$q["nick"].'</span>
                            </div>
                        </div>
                    </div>
                    <div class="fz15" style="white-space: pre-wrap; word-wrap: break-word; overflow-wrap: break-word;">'.\engine\Smile::text_msg($q["msg"]).'</div>
                </div>
                ';
            }
        }
        else{
            $this->msg= '<div class="p-5-10  fz20 center">Нет сообщений</div>';  
        }
        $this->html = $this->newMsg.'</br><hr>
            <div id="chat" class="p-0-10">
                '.$this->msg.'
            </div>';
    }
}