<?php
namespace addPage\union;
class Control{
    public $top = '';
    public $html = '';
    private $param = [
        ['to_appoint','Назначение'],
        ['invite','Приглашение'],
        ['del_user','Выгнать'],
        ['chat', 'Чат'],
        ['log', 'Журнал'],
        ['statute', 'Устав'],
        ['news', 'Новости']
    ];
    public function __construct(&$union){
        $this->union  = $union;
        $this->router();
    }
    private function contolButton(){
        $this->buttonToAppoint = $this->union->view->getRedPanelButton('/icons/toAppoint', 'Назначить',  (($this->position!=null and $this->position["to_appoint"]==1)?'"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&toAppoint&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;})"':''));
        $this->buttonDelUser = $this->union->view->getRedPanelButton('/icons/delUserUnion', 'Исключить',  (($this->position!=null and $this->position["del_user"]==1)?'"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&delUser&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;})"':''));
        $this->buttonExit = $this->union->view->getRedPanelButton('/icons/exit', 'Выход',  '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&exit&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"');
    }
    private function showButtonExit(){
        $this->union->view->addButtonQuestion('Выход', 'Вы уверены, что хотите выйти из союза?', 
        '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&exitOk&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"',
        '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"'
        );
    }
    private function showButtonExitOk(){
        $this->union->model->setUser(0, $this->union->user->getParam("id"));
        $this->union->model->deletePosition($this->union->sql["id"], $this->union->user->getParam("id"));
        $this->union->user->getParam("alliance", 0);
        $this->union->view->getButtonQuestionBlueOk('Выход', 'Вы вышли из союза', '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"');
    }
    private function setChack(){
        $this->textChack = '';
        foreach ($this->param as $key => $value) {
            if($this->userIdPosition[$value[0]]==1)
                $on = 'checked';
            else
                $on = '';
            $this->textChack .= '
            <div class="p-3-0">
                <input type="checkbox" class="checkbox vs" '.$on.' id="checkbox'.$key.'" />
                <label for="checkbox'.$key.'">'.$value[1].'</label>    
            </div>';
        }
    }
    private function setDefault(){
        $this->defaultParam = [];
        foreach ($this->param as $key => $value) {
            $this->defaultParam[$key] = 0;
        }
    }
    private function getParamStr($param){
        $str = '';
        $keys = array_keys($param);
        foreach ($param as $key => $value){
            if ( $keys[0] !== $key)
                 $str .= ', ';
            $str .= '`'.$key.'` = {?}';
            
        }
        return $str;
    }
    private function addToAppointInDb(){
        
        $param  = [];
        $param["user"] = $this->userId["id"];
        $param["name"] = strval($_POST["name"]);
        $param["alliance"] = $this->union->sql["id"];
        foreach ($this->param as $key => $value){
            $param[$value[0]] = $this->defaultParam[$key];
        }
        $str = $this->getParamStr($param);
        
        $arr = [];
        $index = 0;
        foreach ($param as $key => $value){
            $arr[$index] = $value;
            $index++; 
        }
        $query = "INSERT INTO `alliance_position` SET ".$str;
        $this->union->db->query($query,$arr);
    }
    private function toAppointUserIdGo(){
        if(strlen($_POST["name"]) >= 32)
            $this->union->view->addMessRed('Ошибка', 'Название должно содержать более 32 символов');
        elseif(strlen($_POST["name"]) <= 0){
            $this->union->model->deletePosition($this->union->sql["id"], $this->userId["id"]);
            $this->union->view->getButtonQuestionBlueOk('Должность', 'Должность удалена', '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&toAppoint&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"');
        }
        else{
            $this->union->view->getButtonQuestionBlueOk('Должность', 'Права игрока изменены', '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&toAppoint&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"');
            $this->union->model->deletePosition($this->union->sql["id"], $this->userId["id"]);
            $this->setDefault();
            foreach ($this->param as $key => $value){
                if($_POST["param"][$key]=="true"){
                    $this->defaultParam[$key] = 1;
                }
            }
            $this->addToAppointInDb();   
        }
        
    }
    private function showToAppointUserId(){
        if(isset($_GET["go"])){
            $this->toAppointUserIdGo();
        }
        $this->userIdPosition = $this->union->model->getPosition($this->userId["id"], $this->union->sql["id"]);
        $this->setChack();
        $this->top  = 'Назначить игрока';
        $this->html = $this->nav.'
        <script>
            function toAppoint(){
                let param = [];
                for (var i = 0; i < '.count ($this->param).'; i++) {
                    param[i] = $("#checkbox"+i).is(":checked");
                }
                let name = $("#name").val();
                window.brouser.openPage("'.$this->union->url.'/html/page/union.php?control&toAppoint&userId='.$this->userId["id"].'&go", {"unionId": '.$this->union->sql["id"].', "name": name,"param": param}, false);
            }
            function rename(){
                if($("#name").val().length>0)
                    $("#go").html("Назначить");
                else
                    $("#go").html("Удалить");
            }
        </script>
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack white ">
                <div class="center">
                    <div class="p-3-0">Должность:</div>
                    <input oninput=rename() id="name" type="text" maxlength="4000"  name="name" value="'.(($this->userIdPosition!=null)?$this->userIdPosition["name"]:'').'" class="form-inputPanelRed w70 left p-3-0"></input>
                </div>
                <div class="left">
                    '.$this->textChack.'
                </div>
                <div class="p10-0 center">
        			<div id="go" class="redButton w70 mAuto borderRadius10px p10-0" onclick=toAppoint()>
        		        Назначить
        		    </div>
    		    </div>
            </div>
        </div>';
    }

    private function toAppointRouter(){
        $this->userId = $this->union->model->getUserIdUnion($_GET["userId"], $this->union->sql["id"]);
        if(isset($_GET["userId"]) and $this->userId!=null)
            $this->showToAppointUserId();
        else
            $this->showToAppoint();
    }
    private function showToAppoint(){
        $this->top = 'Назначить';
        $count = $this->union->model->getUsersCount($this->union->sql["id"]);
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->union->model->getUsersToAppoint($this->union->sql["id"], $start);
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $rank = $this->union->rank->getRank($q["rating"]);
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&toAppoint&userId='.$q["id"].'&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;})"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				        <span class="w30px">
            				            <img src="'.$this->union->url.'/img/rank/'.$rank.'.png" class="vs" height="30">
                				    </span>
                				    '.$q["nick"].'
            				    </div>
            				    <div>
            				        '.$q["position_name"].'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->union->url.'/img/icons/back.png" class="vs" height="30">
        					</div>
            			</div>
            		</div>
        		</div>';
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/union.php?control&toAppoint&', $k_page, $page, '{"unionId": "'.$this->union->sql["id"].'"}').'</div>';   
	    }
        $this->html = $this->nav.'
        <div class="p-5-10 fz20">
            <div class="redPanel redPanelBack p10-0">
                '.$users.'
                '.$nav.'
            </div>
        </div>';
    }
    private function delUserId(){
        $user = $this->union->model->getUserUnion($_GET["userId"], $this->union->sql["id"]);
        if($user!=null){
            $this->union->view->getButtonQuestionBlueOk('Исключить', 'Игрок исключёт из союза', '"window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&delUser&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"');
            $this->union->model->deletePosition($this->union->sql["id"], $_GET["userId"]);
            $this->union->model->setUser(0, $_GET["userId"]);
        }
    }
    private function showDelUser(){
        if(isset($_GET["userId"]))
            $this->delUserId();
        $this->top = 'Исключить';
        $count = $this->union->model->getUsersCount($this->union->sql["id"]);
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->union->model->getUsersToAppoint($this->union->sql["id"], $start);
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                
                $rank = $this->union->rank->getRank($q["rating"]);
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->union->url.'/html/page/union.php?control&delUser&userId='.$q["id"].'&quot;,{&quot;unionId&quot;: &quot;'.$this->union->sql["id"].'&quot;}, false)"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				        <span class="w30px">
            				            <img src="'.$this->union->url.'/img/rank/'.$rank.'.png" class="vs" height="30">
                				    </span>
                				    '.$q["nick"].'
            				    </div>
            				    <div>
            				        '.$q["position_name"].'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->union->url.'/img/icons/back.png" class="vs" height="30">
        					</div>
            			</div>
            		</div>
        		</div>';
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/union.php?control&delUser&', $k_page, $page, '{"unionId": "'.$this->union->sql["id"].'"}').'</div>';   
	    }
        $this->html = $this->nav.'
        <div class="p-5-10 fz20">
            <div class="redPanel redPanelBack p10-0">
                '.$users.'
                '.$nav.'
            </div>
        </div>';
    }
    private function router(){
        $this->position = $this->union->model->getPosition($this->union->user->getParam("id"), $this->union->sql["id"]);
        if(isset($_GET["toAppoint"]) and $this->position!=null and $this->position["to_appoint"]==1)
           $this->toAppointRouter();
        elseif(isset($_GET["delUser"]) and $this->position!=null and $this->position["del_user"]==1)
           $this->showDelUser();
        else
            $this->showСontrol();
    }
    private function showСontrol(){
        $this->top = 'Управление';
        if(isset($_GET["exit"]))
            $this->showButtonExit();
        if(isset($_GET["exitOk"]))
            $this->showButtonExitOk();
        $this->contolButton();
        $this->html = '
        <div class="p-5-10">
            <div class="redPanel redPanelBack p10-0">
                <div class="p-5-10">
                    <div class="center fz12 w100 ">
                        '.$this->buttonToAppoint.$this->buttonDelUser.$this->buttonExit.'
                    </div>
                </div>
            </div>
        </div>
        ';
    }
}