<?php
namespace engine;
class Def{
    public function __construct(){
        $this->parserPost();
        $this->parserGet();
        $this->parserCookie();
        $this->installAccess();
    }
    private function installAccess(){
        header('Access-Control-Allow-Origin: *');
    }
    private function parserPost(){
        foreach ($_POST as $key => $value) {
            $_POST[$key] = $this->filtering($value);
        }
    }
    private function parserGet(){
        foreach ($_GET as $key => $value) {
            $_GET[$key] = $this->filtering($value);
        }
    }
    private function parserCookie(){
        foreach ($_COOKIE as $key => $value) {
            $_COOKIE[$key] = $this->filtering($value);
        }
    }
    public function filtering($text){
        if(is_array($text)){
            foreach ($text as $key => $value) {
                $text[$key] = $this->filtering($text[$key]);
            }
        }
    	else
    	    $text = htmlspecialchars($text);
    	//$text = mysql_escape_string($text);
    	return $text;
    }
}