<?php
namespace engine;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/db.php');
include_once ($root.'/class/engine/time.php');
include_once ($root.'/class/engine/user.php');
include_once ($root.'/class/engine/view.php');
include_once ($root.'/class/engine/def.php');
include_once ($root.'/class/engine/lang.php');
include_once ($root.'/class/engine/res.php');
class Engine
{
	public $db;
    private static $instances = [];
    protected function __construct() { }
    protected function __clone() { }
    public function __wakeup()
    {
        throw new \Exception("Cannot unserialize a singleton.");
    }
    public static function getInstance(): Engine
    {
        $cls = static::class;
        if (!isset(self::$instances[$cls])) {
            self::$instances[$cls] = new static();
        }

        return self::$instances[$cls];
    }
    public function start($game)
    {
        $this->game   = $game;
    }
}

class Game{
    public $version = '1.4.2';
    public function __construct(){
        $this->url  = 'https://'.$_SERVER['HTTP_HOST'];
        session_start();
        ob_start();
        $this->lang = new lang\Lang();//Цепляем язычёк
        $this->db   = new Db();
        $this->def  = new Def();
        $this->view = new View();
        $this->timer = new Time();
        $this->res = new Res($this);
        $this->user = new User($this);
        \engine\Engine::getInstance()->start($this);
    }
    //Устанавливаем доступ к страницам, которые только с авторизацией
    public function setAuthorization(){
        if($this->user->chackAute() == false)
            $this->view->breaking("Доступ неавторизованным закрыт");
    }
    public function getUrl(){
        return $this->url;
    }
}
