<?php
namespace local\build\model;
class Barracks extends GeneralModel {
    protected $name = 'Казарма';
    protected $view = '';
    protected $description = 'Позволяет тренировать войска. Уровень легионера зависит от уровня здания. Каждый новый уровень добавляет +10% к параметрам.';
    protected $les = 50;
    protected $kam = 40;
    protected $zel = 60;
    protected $eda = 60;
    protected $lud = 10;
    protected $time = 10;
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    private $upLevel = 0;//Начальный уровень прокачки легионера
    protected $page = ["Training"];
    private $html = '';
    public function __construct(&$game){
        $this->game = $game;
        $this->arms = new \model\Arms($this->game);
    }
    private function trainingArm(){
        $this->html = '';
        unset($_GET['ok']);
        $this->game->view->addMessBlue("Тренировка",  "Тренировка завершена. Войска отправлены в казармы.");
        $this->arms->create($this->game->user->getParamCity("id"), $this->type, $this->data["level"]);
        $this->setButtonTraining();
    }
    private function selectTypeArms(){
        $armsType = $this->arms->getAllArms();
        $script = '
        <script>
            function goTraining(id){
                window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Training&type="+id+"", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
            }
        </script>';
        $this->game->view->addScript($script);
        foreach ($armsType as $key => $value){
            $this->html .= '
            <div onclick=goTraining('.$key.') class="p-3-0">
        		<div class="w100 m1 bottonMini7p">
        		    <div class="btn-link">
        		        <div class="fl p6">
        		            <img src="'.$this->game->getUrl().'/img/arms/'.$key.'.png" class="vs" height="30px">
        		        </div>
        		        <div class="fl"><b>'.$value["name"].'</b></div>
        		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$this->data["level"].'ур.</div>
        		    </div>
        		</div>
        	</div>';
        }   
    }
    public function selectPageTraining(){
        $this->top = 'Тренировать';
        $this->selectTypeArms();
        $this->html = '<div class="p-5-10 center">'.$this->html.'</div>';
    }
    public function chackTypeLegion(){
        $this->type = intval($_GET["type"]);
        $this->armId = $this->arms->getArmId($this->type);
        if($this->armId!=null)
            $this->selectPageLegion();
        else
            $this->selectPageLegionNoSearch();
    }
    private function selectPageLegionNoSearch(){
        $this->top = 'Легионер';
        $this->html = '<div class="p-5-10 center fz20">Не найден!</div>';
    }
    private function setButtonTraining(){
        if($this->arms->getSql($this->game->user->getParamCity("id"))->num_rows>=$this->data["level"]){
            $this->buttonTraining = '<div class="fz20">Все места в казарме заняты.</div>';
        }
        else{
            $this->buttonTraining = '
            <script>
                function goTrainingOk(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Training&type='.$this->type.'&ok", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                }
            </script>
            <div class="center">
        	    <div class="p-3-0">
    		        <div class="bottonMini w70 mAuto" onclick=goTrainingOk()>
        		        Тренировать
        		    </div>
        	    </div>
            </div>';  
            if(isset($_GET["ok"]))
                $this->trainingArm();
        }
        
    }
    public function selectPageLegion(){
        $this->top = 'Легионер';
        $this->setButtonTraining();
        $hp = $this->arms->getParam("hp", $this->type, $this->data["level"], $this->upLevel);
        $ataka  = $this->arms->getParam("ataka", $this->type, $this->data["level"], $this->upLevel);
        $speed  = $this->arms->getParam("speed", $this->type, $this->data["level"], $this->upLevel);
        $this->html = '
        <div class="p-5-10">
            <div class="center">
                <div>
                    <img src="'.$this->game->getUrl().'/img/arms/'.$this->type.'.png" height="50px">
                </div>
                <div class="fBold p-3-0">
                    '.$this->armId["name"].' <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/level.png" class="vs" height="25">'.$this->data["level"].'ур.
                </div>
            </div>
            <div class="p-5-10 bgPanelMini white fz20 left">
                <div>
                    Здоровье: <img src="'.$this->game->getUrl().'/img/arms/param/hp.png" class="vs" height="25px">'.($hp).' 
                </div>
                <div>
                    Атака: <img src="'.$this->game->getUrl().'/img/arms/param/ataka.png" class="vs" height="25px">'.($ataka).'
                </div>
                <div>
                    Скорость: <img src="'.$this->game->getUrl().'/img/arms/param/speed.png" class="vs" height="25px">'.($speed).'
                </div>
            </div>
        </div>
        <hr>
        <div class="p-5-10 center">
            '. $this->buttonTraining.'
        </div>';
    }
    
    protected function setPageTraining(){
        if(isset($_GET["type"]))
            $this->chackTypeLegion();
        else
            $this->selectPageTraining();
        $this->game->view->addTop($this->top);
        $this->game->view->addBody($this->html);
    }
    protected function getDiscription(){
        return $this->description.'<br>
        Легионеры: <img src="'.$this->game->url.'/img/icons/legion.png" class="vs" height="20">'.$this->arms->getSql($this->game->user->getParamCity("id"))->num_rows.'/'.$this->data["level"];
    }
    protected function getBuildBotton(){
        $script = '
            <script>
                function setPageTraining(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Training", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        return '
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageTraining()>
		        Тренировать
		    </div>
	    </div>
        ';
    }
}