<?php
namespace local\build\model;
class Diplomat extends GeneralModel {
    protected $name = 'Дипломатический центр';
    protected $view = '';
    protected $description = 'Позволяет создавать и вступать в союзы.';
    protected $les = 60;
    protected $kam = 50;
    protected $zel = 50;
    protected $eda = 50;
    protected $lud = 15;
    protected $time = 7;
    protected $page = ["Route"];
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    public function __construct(&$game){
        $this->game = $game;
        $this->union = new \model\Union($this->game);
        $this->unionId = $this->game->user->getParam("alliance");
    }
    protected function getDiscription(){
        return $this->description;
    }
    private function toAccept(){
        $this->toAcceptId = intval($_GET["toAccept"]);
        $sqlUnion = $this->union->getInvitationId($this->toAcceptId, $this->game->user->getParam("id"));
        if($sqlUnion!=null){
            $this->union->setUser($sqlUnion["alliance"], $this->game->user->getParam("id"));
            $this->game->view->getButtonQuestionBlueOk(
                'Приглашение', 
                'Вы приняли приглашение в союз', 
                '"window.brouser.openPage(&quot;'.$this->game->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: &quot;'.$sqlUnion["alliance"].'&quot;}, false)"'
            );
            $this->union->deleteInvitation($sqlUnion["id"]);
        }
        else{
            $this->game->view->addMessRed('Приглашение', 'Не найдено');
        }
    }
    private function refuse(){
        $this->refuseId = intval($_GET["refuse"]);
        $sqlUnion = $this->union->getInvitationId($this->refuseId, $this->game->user->getParam("id"));
        if($sqlUnion!=null){
            $this->union->deleteInvitation($sqlUnion["id"]);
            $this->game->view->getButtonQuestionBlueOk(
                'Приглашение', 
                'Удалено', 
                '"window.brouser.openPage(&quot;'.$this->game->url.'/html/html/local/build/build.php?page=Route&invitation&quot;,{&quot;x&quot;: '.$this->data["x"].', &quot;y&quot;: '.$this->data["y"].'}, false)"'
            );
        }
        else{
            $this->game->view->addMessRed('Приглашение', 'Не найдено');
        }
    }
    private function showInvitation(){
        if(isset($_GET["toAccept"]))
            $this->toAccept();
        if(isset($_GET["refuse"]))
            $this->refuse();
        $count = $this->union->showNumberInvitations($this->game->user->getParam("id"));
        $this->top = 'Приглашения - '.$count;
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->union->showInvitations($this->game->user->getParam("id"), $start);
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                
                $invit = '
                <div class="p-3-0">
    	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
    	                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px"  onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: &quot;'.$q["alliance"].'&quot;})"> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                    				    '.$q["name"].'
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->game->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                    		<div class="center p-5-5-0-5">
        				        <span class="colorGreenPanel" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/html/local/build/build.php?page=Route&invitation&toAccept='.$q["id"].'&quot;,{&quot;x&quot;: '.$this->data["x"].', &quot;y&quot;: '.$this->data["y"].'}, false)">Принять</span> 
        				        | 
        				        <span class="red" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/html/local/build/build.php?page=Route&invitation&refuse='.$q["id"].'&quot;,{&quot;x&quot;: '.$this->data["x"].', &quot;y&quot;: '.$this->data["y"].'}, false)">Отказать</span>
        				    </div>
                		</div>
    	            </div>
                </div>';
            }
        }
        else
            $invit = '
            <div class="p-5-3 fz20 center white">
                Нет приглашений
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/html/local/build/build.php?page=Route&invitation&', $k_page, $page, '{"x": '.$this->data["x"].', "y": '.$this->data["y"].'}').'</div>';   
	    }
        
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                '.$invit.'
                '.$nav.'
            </div>
        </div>';
    }
    private function setNewAlliancePost(){
        $pattern = '/^[a-z0-9]+$/i';
        $name = $_POST["name"];
        $err  = ''; 
        if($this->union->chackName($name) > 0) 
            $err = 'Название уже занято';
        elseif(empty($name)) 
            $err = 'Введите название';
        elseif(strlen($name) < 3 || strlen($name) > 30) 
            $err = 'Название должно содержать не менее 3 символов и не более 30';
		elseif(!preg_match($pattern, $name))
		    $err = 'Название должно состоять из латинских букв и цифр';
		else{
            $this->union->create($name);
            $this->unionId = $this->game->db->getConn()->insert_id;
            $this->union->joinTheUnion('Создатель союза',$this->unionId, $this->game->user->getParam("id"), 1, 1, 1, 1);
            $this->html .= '
            <script>
                function goIndexUnion(){
                    window.brouser.openPage("'.$this->game->url.'/html/page/union.php", {"unionId": '.$this->unionId.'}, false);
                }
            </script>';
            $this->game->view->getButtonQuestionBlueOk('Создание', 'Союз создан', '"window.brouser.openPage(&quot;'.$this->game->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: &quot;'.$this->unionId.'&quot;}, false)"');
		}
		if($err != '')
		    $this->game->view->addMessRed('Ошибка', $err);
    }
    private function showNewUnion(){
        $this->top = 'Создать Союз';
        $this->html .= '
        <script>
                function setNew(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Route&union", {"x": '.$this->data["x"].', "y": '.$this->data["y"].', "name": $("#name").val()}, false);
                }
            </script>
        <div class="p-5-10 center">
            <div>
	            <input id="name" type="text" name="login" class="form-input w70" placeholder="Название" maxlength="20" value="">
	        </div>
		    <div class="bottonMini w70 mAuto" onclick="setNew()">
		        Создать
		    </div>
		</div>
        '; 
        if(isset($_POST["name"]))
            $this->setNewAlliancePost();
    }
    private function setPageRouteParam(){
        if(isset($_GET["invitation"]) and $this->unionId==0)
            $this->showInvitation();
        elseif(isset($_GET["union"]) and $this->unionId==0)
            $this->showNewUnion();
        else{
            $this->top = 'Ошибка';
            $this->html = 'Вы не должны здесь находиться. Бан';
        }
    }
    protected function setPageRoute(){
        $this->setPageRouteParam();
        $this->game->view->addTop($this->top);
        $this->game->view->addBody($this->html);
    }
    protected function getBuildBotton(){
        if($this->unionId == 0){
            $button = '
            <script>
                function goInvitation(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Route&invitation", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                function goUnion(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Route&union", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                function goRatingUnion(){
                    window.brouser.openPage("'.$this->game->url.'/html/page/rating.php?union", {});
                }
            </script>
            <div class="p-3-0">
    		    <div class="bottonMini w70 mAuto" onclick=goInvitation()>
    		        Приглашения
    		    </div>
    	    </div>
    	    <div class="p-3-0">
    		    <div class="bottonMini w70 mAuto" onclick=goRatingUnion()>
    		        Союзы
    		    </div>
    	    </div>
            <div class="p-3-0">
    		    <div class="bottonMini w70 mAuto" onclick=goUnion()>
    		        Создать Союз
    		    </div>
    	    </div>
    	    ';
        }
        else{
            $button = '
            <div class="p-3-0">
    		    <div class="bottonMini w70 mAuto" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: &quot;'.$this->unionId.'&quot;})">
    		        Союз
    		    </div>
    	    </div>';
        }
        return $button;
    }
}