<?php
namespace local\build\model;

class Staff extends GeneralModel {
    protected $name = 'Лагерь';
    protected $view = '';
    protected $description = 'Центр по управлению вашим войском и военными походами. Количество одновременных походов зависит от уровня здания.';
    protected $les  = 30;
    protected $kam  = 30;
    protected $zel  = 40;
    protected $eda  = 30;
    protected $lud  = 5;
    protected $time = 10;
    protected $page = ["Arms", "Crusade"];//0 - армии, 1 - походы 
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    private   $html = '';
    public function __construct(&$game){
        $this->game = $game;
        $this->city = new \model\City($this->game);
    }
    protected function getDiscription(){
        $count = $this->city->countCrusade($this->game->user->getParam("id"));
        return $this->description.'<br>
        Походы: <img src="'.$this->game->url.'/img/icons/kazarma.png" class="vs" height="25">'.$count.'/'.$this->data["level"];
    }
    protected function setPageCrusade(){
        $crusade = '';
        $count = $this->city->countCrusade($this->game->user->getParam("id"));
        $this->top = "Походы - ".$count;
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->city->getAllCrusade($this->game->user->getParam("id"), $start);
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                    if($q["timer"]>time())
                        $icon = 'time';
                    else
                        $icon = 'attack';
                    if($q["timer"]>time())
                        $name = $this->game->timer->tl($q["timer"]-time());
                    else
                        $name = 'В бою';
	        		$crusade .= '
	        		<div class="p-3-0">
    		            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10" onclick="window.brouser.openPage(&quot;'.\engine\Engine::getInstance()->game->url.'/html/page/city.php&quot;,{&quot;cityId&quot;: '.$q["city"].'})">
    		                <div class="table w100"> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                    				    <div>
                    				        <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/'.$icon.'.png" class="vs" height="30">
            				                '.$name.'
            				                [X:'.$q["x"].' Y:'.$q["y"].']
                    				    </div>
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->game->getUrl().'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                    		<div>
    		            </div>
    	            </div>';
            }
        }
        else{
            $crusade = '<div class="p-5-10 fz20 white center">Нет походов</div>';  
        }
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/html/local/build/build.php?page=Crusade&', $k_page, $page, '{"x": '.$this->data["x"].', "y": '.$this->data["y"].'}').'</div>';   
	    }
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                '.$crusade.'
                '.$nav.'
            </div>
        </div>
        ';
        $this->game->view->addTop($this->top);
        $this->game->view->addBody($this->html);
    }
    private function showAllArms(){
        $script = '
            <script>
                function goArm(id){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms&id="+id+"", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                
            </script>';
        $this->game->view->addScript($script);
        $this->armsSql = $this->arms->getSql($this->game->user->getParamCity("id"));
        $this->top = "Армия - ".$this->armsSql->num_rows;
        $this->html = '<div class="p-5-10 center">'; 
        if($this->armsSql->num_rows>0){
            $i = 0;
            while($q = $this->armsSql->fetch_assoc()){
                $i++;
                $this->html .= '
                <div onclick=goArm('.$q["id"].') class="p-3-0">
            		<div class="w100 m1 bottonMini7p">
            		    <div class="btn-link">
            		        <div class="fl p6">
            		            <img src="'.$this->game->getUrl().'/img/arms/'.$q["type"].'.png" class="vs" height="30px">
            		        </div>
            		        <div class="fl"><b>'.$q["name"].'</b></div>
            		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$q["level"].'ур.</div>
            		    </div>
            		</div>
            	</div>
                ';
                // if($i < $this->armsSql->num_rows)
                //     $this->html .= '<hr>';
            }
        }
        else
            $this->html .= '<span class="fz20">Пусто</span>'; 
        $this->html .= '</div>'; 
    }
    private function setNameArmPost(){
        $name = $_POST["name"];
        if(strlen($name) < 3 || strlen($name) > 20){
            $nameMess = 'Ошибка';
            $text = 'Название должно содержать не менее 3 символов и не более 20';
            $this->game->view->addError($nameMess, $text);
            
        }
        else{
            $nameMess = 'Переименование';
            $text = 'Теперь легионер называется '.$name;
            $this->armSql["name"] = $name;
            $this->arms->reName($this->armSql["id"], $name);
            $this->game->view->addMessBlue($nameMess, $text);
        }
    }
    private function armRename(){
        $this->top = "Переименование";
        if(isset($_POST["name"]))
            $this->setNameArmPost();
        $script = '
            <script>
                function setRename(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms&id='.$this->armSql["id"].'&rename", {"x": '.$this->data["x"].', "y": '.$this->data["y"].', "name": $("#name").val()}, false);
                }
            </script>';
        $this->game->view->addScript($script);
        $this->html .= '
        <div class="p-5-10 center">
            <div>
	            <input id="name" type="text" name="login" class="form-input w70" placeholder="Название" maxlength="20" value="'.$this->armSql["name"].'">
	        </div>
		    <div class="bottonMini w70 mAuto" onclick="setRename()">
		        Переименовать
		    </div>
		</div>
        '; 
    }
    private function armDelError(){
        $this->game->view->addMessRed('Ошибка', 'У вас есть незаконченные походы');
    }
    private function armDelGood(){
        $this->game->view->addMessBlue('Успешно', 'Легионер распущен');
    }
    private function armDel(){
        $count = $this->city->countCrusade($this->game->user->getParam("id"));
        if($count>0){
            $this->armDelError();
        }
        else{
            $this->armDelGood();
            $this->arms->del($this->armSql["id"]);
            $this->showAllArms();
        }
    }
    private function showHtmlArmId(){
        $this->top = 'Легионер';
        $script = '
            <script>
                function setRename(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms&id='.$this->armSql["id"].'&rename", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                function setDel(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms&id='.$this->armSql["id"].'&del", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                }
            </script>';
        $this->game->view->addScript($script);
        $hp = $this->arms->getParam("hp", $this->armSql["type"], $this->armSql["level"], $this->armSql["up_hp"]);
        $ataka  = $this->arms->getParam("ataka", $this->armSql["type"], $this->armSql["level"], $this->armSql["up_ataka"]);
        $speed  = $this->arms->getParam("speed", $this->armSql["type"], $this->armSql["level"], $this->armSql["up_speed"]);
        
        $this->html .= '
        <div class="p-5-10">
            <div class="center">
                <div>
                    <img src="'.$this->game->getUrl().'/img/arms/'.$this->armSql["type"].'.png" height="50px">
                </div>
                <div class="fBold p-3-0">
                    '.$this->armSql["name"].' <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/level.png" class="vs" height="25">'.$this->armSql["level"].'ур.
                </div>
            </div>
            <div class="p-5-10 bgPanelMini white fz20 left">
                <div>
                    Здоровье: <img src="'.$this->game->getUrl().'/img/arms/param/hp.png" class="vs" height="25px">'.($hp).' 
                </div>
                <div>
                    Атака: <img src="'.$this->game->getUrl().'/img/arms/param/ataka.png" class="vs" height="25px">'.($ataka).'
                </div>
                <div>
                    Скорость: <img src="'.$this->game->getUrl().'/img/arms/param/speed.png" class="vs" height="25px">'.($speed).'
                </div>
            </div>
        </div>
        <hr>
        <div class="center">
    	    <div class="p-3-0">
		        <div class="bottonMini w70 mAuto" onclick=setRename()>
    		        Переименовать
    		    </div>
    	    </div>
    	    <div class="p-3-0">
    	        <div class="bottonMini w70 mAuto" onclick=setDel()>
    		        Распустить
    		    </div>
    	    </div>
        </div>';
        if(isset($_GET["del"]))
            $this->armDel();
    }
    private function setHtmlArmId(){
        $this->arm = $this->arms->getArmId($this->armSql["type"]);
        if(isset($_GET["rename"]))
            $this->armRename();
        
        else
            $this->showHtmlArmId();
    }
    private function noSearcheArm(){
        $this->top = 'Легионер';
        $this->html .= '
        <div class="p-5-10 center">
            Легионер не найден
        </div>';
    }
    private function showIdArms(){
        $this->armSql = $this->arms->getSqlId($this->game->user->getParamCity("id"), $_GET["id"])->fetch_assoc();
        if($this->armSql != null)
            $this->setHtmlArmId();
        else
            $this->noSearcheArm();
    }
    private function showCrusadeIdError(){
        $this->top = "Поход";
        $this->html .= '
        <div class="p-5-10 center">
            Поход не найден
        </div>';
    }
    private function showCrusadeIdChack(){
        $this->crusade = $this->city->getCrusadeInCity($_GET["crusade_id"], $this->game->user->getParamCity("id"));
        if($this->crusade!=null)
            $this->showCrusadeId();
        else
            $this->showCrusadeIdError();
    }
    
    private function showCrusadeId(){
        $this->crusadePage = new \addPage\Crusade($this);
        $this->top = $this->crusadePage->getTop();
        $this->html .= $this->crusadePage->getHtml();
    }
    protected function setPageArms(){
        $this->arms = new \model\Arms($this->game);
        if(isset($_GET["crusade_id"]))
            $this->showCrusadeIdchack();
        elseif(isset($_GET["id"]))
            $this->showIdArms();
        else
            $this->showAllArms();
        $this->game->view->addTop($this->top);
        $this->game->view->addBody($this->html);
    }
    protected function getBuildBotton(){
        $script = '
            <script>
                function setPageArms(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Arms", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                function setPageCrusade(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Crusade", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        return '
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageArms()>
		        Армия
		    </div>
	    </div>
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageCrusade()>
		        Походы
		    </div>
	    </div>
        ';
    }
}