<?php
namespace local\build\model;

function formatSecondsToDHMS($seconds) {
    $days = floor($seconds / (3600 * 24));
    $hours = floor(($seconds % (3600 * 24)) / 3600);
    $minutes = floor(($seconds % 3600) / 60);
    $seconds = $seconds % 60;

    return sprintf("%d д. %02d ч. %02d м. %02d с.", $days, $hours, $minutes, $seconds);
}

class TownHall extends GeneralModel {
    protected $name = 'Капитолий';
    protected $view = '';
    protected $description = 'Капитолий - главное здание вашего города. 
        Здесь у вас содержится значительная часть ресурсов, 
        а также проживают местные и наемные строители. 
        Уровень здания влияет на количество вмещаемых ресурсов, а также их добычу.';
    protected $les = 200;
    protected $kam = 300;
    protected $zel = 200;
    protected $eda = 300;
    protected $lud = 50;
    protected $time = 10;
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    protected $page = ["Builder"];
    private $top = ''; 
    protected $production = 20;
    protected $hold = 100;
    protected $people = 50;
    public function __construct(&$game){
        $this->game = $game;
    }
    protected function getDiscription(){
        $this->countBuilders = $this->develop->queue;
        $busy = $this->develop->getDo($this->game->user->getParamCity("id"))->num_rows;
        $result = $this->develop->getBuilders($this->game->user->getParam("id"));
        return $this->description.'<br>
        Строители: <img src="'.$this->game->url.'/img/icons/builder.png" class="vs" height="25">'.$busy.'/'.($this->countBuilders+$result->num_rows).'<br>
        Прирост ресурсов: <img src="'.$this->game->url.'/img/menu/panel/res.png" class="vs" height="25">'.($this->production*$this->data["level"]).' ед/час<br>
        Вместимость ресурсов: <img src="'.$this->game->url.'/img/menu/panel/res.png" class="vs" height="25">'.($this->hold*$this->data["level"]).' ед.<br>
        Население: <img src="'.$this->game->url.'/img/icons/lud.png" class="vs" height="25">'.($this->people*$this->data["level"]).' чел<br>';
    }
    protected function getBuildBotton(){
        $script = '
            <script>
                function setPageBuilder(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Builder", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        return '
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageBuilder()>
		        Строители
		    </div>
	    </div>';
    }
    
    protected function setPageBuilder(){
        
       // 05.09.2025
        $d = $this->game->db->query("SELECT * FROM `users` WHERE `id` = {?} LIMIT 1", [$this->game->user->getParam("id")])->fetch_assoc();
        
        if ($d["builder_end_time"] > time())
        $d_u = 1;
        else
        $d_u = 0;
        
        $result = $this->develop->getBuilders($this->game->user->getParam("id"));
        $count = $result->num_rows + $d_u;
		$htmlBuilders = '';
	    while($q = $result->fetch_assoc()){
	        $htmlBuilders .= '
	        <div class="p-5-10 fz20">
                <div class="redPanel p-5-10 redPanelBack">
                    <div class="table w100 tborder10-5"> 
            			<div class="white row">
            				<div class="cell w10">
            				    <div class="p6">
            				        <img src="'.$this->game->url.'/img/icons/builder.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 left vam p6 ">
            				    Наёмный
            				</div>
            				<div class="cell fz20 right vam p6 ">
            				    <img src="'.$this->game->url.'/img/icons/time.png" class="vs" height="25">6 д.19 ч.
            				</div>
            			</div>
            		</div>
            	</div>
            </div>';
	    }
	    for($i = 0; $i<=2; $i++){
	        $htmlBuilders .= '
	        <div class="p-5-10 fz20">
                <div class="redPanel p-5-10 redPanelBack">
                    <div class="table w100 tborder10-5"> 
            			<div class="white row">
            				<div class="cell w10">
            				    <div class="p6">
            				        <img src="'.$this->game->url.'/img/icons/builder.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 left vam p6 ">
            				    Местный
            				</div>
            				<div class="cell fz20 right vam p6 ">
            				    Навсегда
            				</div>
            			</div>
            		</div>
            	</div>
            </div>';
	    }
		
		if ($d["builder_end_time"] > time())
		$htmlBuilders .= '
	        <div class="p-5-10 fz20">
                <div class="redPanel p-5-10 redPanelBack">
                    <div class="table w100 tborder10-5"> 
            			<div class="white row">
            				<div class="cell w10">
            				    <div class="p6">
            				        <img src="'.$this->game->url.'/img/icons/builder.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 left vam p6 ">
            				<small>    Дополнительный </small>
            				</div>
            				<div class="cell fz20 right vam p6 ">
            				 <small> <img src="'.$this->url.'/img/icons/time.png" class="vs" height="20">  '.formatSecondsToDHMS($d["builder_end_time"] - time()).' </small>
            				</div>
            			</div>
            		</div>
            	</div>
            </div>';
		
		
		$this->html = $htmlBuilders;
        $this->countBuilders = $this->develop->queue+$count;
    
        $this->top = 'Строители - '.$this->countBuilders;

        $this->game->view->addTop($this->top);
        $this->game->view->addBody($this->html);
    }
    
}