<?php
namespace local;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Map extends \engine\Game{
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    public function setType(){
        $this->showJsonBuilds();
        $this->view->setType("json");
        $this->view->echoEver(); 
    }
    private function showJsonBuilds(){
        $this->user->selectMyCity();
        $this->map = new \model\Map($this);
        $this->selectXY();
        $this->selectSector();
        $center = ["x"=>$this->x, "y"=>$this->y];
        $this->view->addData("map", ["city"=>$this->dataSector, "center"=> $center]);
    }
    private function getCityType($rating){
        
        
        $types = $this->map->cityType;
        
        $name = '';
        foreach ($types as $key => $value) {
            if($rating>=$value)
                $name = $key;
        }
        return $name;
    }
    private function selectSector(){
        $x1 = $this->x-3;
		$x2 = $this->x+3;
		$y1 = $this->y-3;
		$y2 = $this->y+3;
		$this->sector = $this->map->selectSector($x1, $y1, $x2, $y2);
		$arr = [];
		while($q = $this->sector->fetch_assoc()){
		    
		    
		    
		    
		    $uD = $this->map->selectByUserId($q["user"]);
		    
		    
		    if($q["type"]=="city"){
		        $type = $this->getCityType($q["rating"]);
		        
		        if ($uD['dome'] > time())
		        $type = $type.'1';
		        
		       //$type = 'CitySenior1';
		       
		    }
		    else
		        $type = $q["type"];
		         
		        
			$info = [];
			$info["id"] = $q["id"];
			$info["type"] = $type;
			//$info["type"] = 'dome';
			$info["x"] = $q["x"];
			$info["y"] = $q["y"];
			
			array_push($arr, $info);
			
		}
        $this->dataSector = $arr;
    }
    private function setMyXY(){
        $this->x = $this->user->getParamCity("x");
        $this->y = $this->user->getParamCity("y");
    }
    private function setXYPOST(){
        if($_POST["x"]<0 or $_POST["x"]>1000000 or $_POST["y"]<0 or $_POST["y"]>1000000)
            $this->setMyXY();
    }
    private function selectXY(){
        if(isset($_POST["x"]) and isset($_POST["y"])){
            $this->x = intval($_POST["x"]);
            $this->y = intval($_POST["y"]);
            $this->setXYPOST();
        }
        else
            $this->setMyXY();
    }
}